/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.weblinks;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.weblinks.CreateWebLinkHeaders;
import com.box.sdkgen.managers.weblinks.CreateWebLinkRequestBody;
import com.box.sdkgen.managers.weblinks.DeleteWebLinkByIdHeaders;
import com.box.sdkgen.managers.weblinks.GetWebLinkByIdHeaders;
import com.box.sdkgen.managers.weblinks.UpdateWebLinkByIdHeaders;
import com.box.sdkgen.managers.weblinks.UpdateWebLinkByIdRequestBody;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.weblink.WebLink;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class WebLinksManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public WebLinksManager() {
        this.networkSession = new NetworkSession();
    }

    protected WebLinksManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public WebLink createWebLink(CreateWebLinkRequestBody requestBody) {
        return this.createWebLink(requestBody, new CreateWebLinkHeaders());
    }

    public WebLink createWebLink(CreateWebLinkRequestBody requestBody, CreateWebLinkHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/web_links"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), WebLink.class);
    }

    public WebLink getWebLinkById(String webLinkId) {
        return this.getWebLinkById(webLinkId, new GetWebLinkByIdHeaders());
    }

    public WebLink getWebLinkById(String webLinkId, GetWebLinkByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(UtilsManager.entryOf("boxapi", UtilsManager.convertToString(headers.getBoxapi()))), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/web_links/", UtilsManager.convertToString(webLinkId)), "GET").headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), WebLink.class);
    }

    public WebLink updateWebLinkById(String webLinkId) {
        return this.updateWebLinkById(webLinkId, new UpdateWebLinkByIdRequestBody(), new UpdateWebLinkByIdHeaders());
    }

    public WebLink updateWebLinkById(String webLinkId, UpdateWebLinkByIdRequestBody requestBody) {
        return this.updateWebLinkById(webLinkId, requestBody, new UpdateWebLinkByIdHeaders());
    }

    public WebLink updateWebLinkById(String webLinkId, UpdateWebLinkByIdHeaders headers) {
        return this.updateWebLinkById(webLinkId, new UpdateWebLinkByIdRequestBody(), headers);
    }

    public WebLink updateWebLinkById(String webLinkId, UpdateWebLinkByIdRequestBody requestBody, UpdateWebLinkByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/web_links/", UtilsManager.convertToString(webLinkId)), "PUT").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), WebLink.class);
    }

    public void deleteWebLinkById(String webLinkId) {
        this.deleteWebLinkById(webLinkId, new DeleteWebLinkByIdHeaders());
    }

    public void deleteWebLinkById(String webLinkId, DeleteWebLinkByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/web_links/", UtilsManager.convertToString(webLinkId)), "DELETE").headers(headersMap).responseFormat(ResponseFormat.NO_CONTENT).auth(this.auth).networkSession(this.networkSession).build());
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public WebLinksManager build() {
            return new WebLinksManager(this);
        }
    }
}

