/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.sessiontermination;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.sessiontermination.TerminateGroupsSessionsHeaders;
import com.box.sdkgen.managers.sessiontermination.TerminateGroupsSessionsRequestBody;
import com.box.sdkgen.managers.sessiontermination.TerminateUsersSessionsHeaders;
import com.box.sdkgen.managers.sessiontermination.TerminateUsersSessionsRequestBody;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.sessionterminationmessage.SessionTerminationMessage;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class SessionTerminationManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public SessionTerminationManager() {
        this.networkSession = new NetworkSession();
    }

    protected SessionTerminationManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public SessionTerminationMessage terminateUsersSessions(TerminateUsersSessionsRequestBody requestBody) {
        return this.terminateUsersSessions(requestBody, new TerminateUsersSessionsHeaders());
    }

    public SessionTerminationMessage terminateUsersSessions(TerminateUsersSessionsRequestBody requestBody, TerminateUsersSessionsHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/users/terminate_sessions"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), SessionTerminationMessage.class);
    }

    public SessionTerminationMessage terminateGroupsSessions(TerminateGroupsSessionsRequestBody requestBody) {
        return this.terminateGroupsSessions(requestBody, new TerminateGroupsSessionsHeaders());
    }

    public SessionTerminationMessage terminateGroupsSessions(TerminateGroupsSessionsRequestBody requestBody, TerminateGroupsSessionsHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/groups/terminate_sessions"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), SessionTerminationMessage.class);
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public SessionTerminationManager build() {
            return new SessionTerminationManager(this);
        }
    }
}

