/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.integrationmappings;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.integrationmappings.CreateSlackIntegrationMappingHeaders;
import com.box.sdkgen.managers.integrationmappings.CreateTeamsIntegrationMappingHeaders;
import com.box.sdkgen.managers.integrationmappings.DeleteSlackIntegrationMappingByIdHeaders;
import com.box.sdkgen.managers.integrationmappings.DeleteTeamsIntegrationMappingByIdHeaders;
import com.box.sdkgen.managers.integrationmappings.GetSlackIntegrationMappingHeaders;
import com.box.sdkgen.managers.integrationmappings.GetSlackIntegrationMappingQueryParams;
import com.box.sdkgen.managers.integrationmappings.GetTeamsIntegrationMappingHeaders;
import com.box.sdkgen.managers.integrationmappings.GetTeamsIntegrationMappingQueryParams;
import com.box.sdkgen.managers.integrationmappings.UpdateSlackIntegrationMappingByIdHeaders;
import com.box.sdkgen.managers.integrationmappings.UpdateSlackIntegrationMappingByIdRequestBody;
import com.box.sdkgen.managers.integrationmappings.UpdateTeamsIntegrationMappingByIdHeaders;
import com.box.sdkgen.managers.integrationmappings.UpdateTeamsIntegrationMappingByIdRequestBody;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.integrationmapping.IntegrationMapping;
import com.box.sdkgen.schemas.integrationmappings.IntegrationMappings;
import com.box.sdkgen.schemas.integrationmappingslackcreaterequest.IntegrationMappingSlackCreateRequest;
import com.box.sdkgen.schemas.integrationmappingsteams.IntegrationMappingsTeams;
import com.box.sdkgen.schemas.integrationmappingteams.IntegrationMappingTeams;
import com.box.sdkgen.schemas.integrationmappingteamscreaterequest.IntegrationMappingTeamsCreateRequest;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class IntegrationMappingsManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public IntegrationMappingsManager() {
        this.networkSession = new NetworkSession();
    }

    protected IntegrationMappingsManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public IntegrationMappings getSlackIntegrationMapping() {
        return this.getSlackIntegrationMapping(new GetSlackIntegrationMappingQueryParams(), new GetSlackIntegrationMappingHeaders());
    }

    public IntegrationMappings getSlackIntegrationMapping(GetSlackIntegrationMappingQueryParams queryParams) {
        return this.getSlackIntegrationMapping(queryParams, new GetSlackIntegrationMappingHeaders());
    }

    public IntegrationMappings getSlackIntegrationMapping(GetSlackIntegrationMappingHeaders headers) {
        return this.getSlackIntegrationMapping(new GetSlackIntegrationMappingQueryParams(), headers);
    }

    public IntegrationMappings getSlackIntegrationMapping(GetSlackIntegrationMappingQueryParams queryParams, GetSlackIntegrationMappingHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("marker", UtilsManager.convertToString(queryParams.getMarker())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit())), UtilsManager.entryOf("partner_item_type", UtilsManager.convertToString(queryParams.getPartnerItemType())), UtilsManager.entryOf("partner_item_id", UtilsManager.convertToString(queryParams.getPartnerItemId())), UtilsManager.entryOf("box_item_id", UtilsManager.convertToString(queryParams.getBoxItemId())), UtilsManager.entryOf("box_item_type", UtilsManager.convertToString(queryParams.getBoxItemType())), UtilsManager.entryOf("is_manually_created", UtilsManager.convertToString(queryParams.getIsManuallyCreated()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/integration_mappings/slack"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), IntegrationMappings.class);
    }

    public IntegrationMapping createSlackIntegrationMapping(IntegrationMappingSlackCreateRequest requestBody) {
        return this.createSlackIntegrationMapping(requestBody, new CreateSlackIntegrationMappingHeaders());
    }

    public IntegrationMapping createSlackIntegrationMapping(IntegrationMappingSlackCreateRequest requestBody, CreateSlackIntegrationMappingHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/integration_mappings/slack"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), IntegrationMapping.class);
    }

    public IntegrationMapping updateSlackIntegrationMappingById(String integrationMappingId) {
        return this.updateSlackIntegrationMappingById(integrationMappingId, new UpdateSlackIntegrationMappingByIdRequestBody(), new UpdateSlackIntegrationMappingByIdHeaders());
    }

    public IntegrationMapping updateSlackIntegrationMappingById(String integrationMappingId, UpdateSlackIntegrationMappingByIdRequestBody requestBody) {
        return this.updateSlackIntegrationMappingById(integrationMappingId, requestBody, new UpdateSlackIntegrationMappingByIdHeaders());
    }

    public IntegrationMapping updateSlackIntegrationMappingById(String integrationMappingId, UpdateSlackIntegrationMappingByIdHeaders headers) {
        return this.updateSlackIntegrationMappingById(integrationMappingId, new UpdateSlackIntegrationMappingByIdRequestBody(), headers);
    }

    public IntegrationMapping updateSlackIntegrationMappingById(String integrationMappingId, UpdateSlackIntegrationMappingByIdRequestBody requestBody, UpdateSlackIntegrationMappingByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/integration_mappings/slack/", UtilsManager.convertToString(integrationMappingId)), "PUT").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), IntegrationMapping.class);
    }

    public void deleteSlackIntegrationMappingById(String integrationMappingId) {
        this.deleteSlackIntegrationMappingById(integrationMappingId, new DeleteSlackIntegrationMappingByIdHeaders());
    }

    public void deleteSlackIntegrationMappingById(String integrationMappingId, DeleteSlackIntegrationMappingByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/integration_mappings/slack/", UtilsManager.convertToString(integrationMappingId)), "DELETE").headers(headersMap).responseFormat(ResponseFormat.NO_CONTENT).auth(this.auth).networkSession(this.networkSession).build());
    }

    public IntegrationMappingsTeams getTeamsIntegrationMapping() {
        return this.getTeamsIntegrationMapping(new GetTeamsIntegrationMappingQueryParams(), new GetTeamsIntegrationMappingHeaders());
    }

    public IntegrationMappingsTeams getTeamsIntegrationMapping(GetTeamsIntegrationMappingQueryParams queryParams) {
        return this.getTeamsIntegrationMapping(queryParams, new GetTeamsIntegrationMappingHeaders());
    }

    public IntegrationMappingsTeams getTeamsIntegrationMapping(GetTeamsIntegrationMappingHeaders headers) {
        return this.getTeamsIntegrationMapping(new GetTeamsIntegrationMappingQueryParams(), headers);
    }

    public IntegrationMappingsTeams getTeamsIntegrationMapping(GetTeamsIntegrationMappingQueryParams queryParams, GetTeamsIntegrationMappingHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("partner_item_type", UtilsManager.convertToString(queryParams.getPartnerItemType())), UtilsManager.entryOf("partner_item_id", UtilsManager.convertToString(queryParams.getPartnerItemId())), UtilsManager.entryOf("box_item_id", UtilsManager.convertToString(queryParams.getBoxItemId())), UtilsManager.entryOf("box_item_type", UtilsManager.convertToString(queryParams.getBoxItemType()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/integration_mappings/teams"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), IntegrationMappingsTeams.class);
    }

    public IntegrationMappingTeams createTeamsIntegrationMapping(IntegrationMappingTeamsCreateRequest requestBody) {
        return this.createTeamsIntegrationMapping(requestBody, new CreateTeamsIntegrationMappingHeaders());
    }

    public IntegrationMappingTeams createTeamsIntegrationMapping(IntegrationMappingTeamsCreateRequest requestBody, CreateTeamsIntegrationMappingHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/integration_mappings/teams"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), IntegrationMappingTeams.class);
    }

    public IntegrationMappingTeams updateTeamsIntegrationMappingById(String integrationMappingId) {
        return this.updateTeamsIntegrationMappingById(integrationMappingId, new UpdateTeamsIntegrationMappingByIdRequestBody(), new UpdateTeamsIntegrationMappingByIdHeaders());
    }

    public IntegrationMappingTeams updateTeamsIntegrationMappingById(String integrationMappingId, UpdateTeamsIntegrationMappingByIdRequestBody requestBody) {
        return this.updateTeamsIntegrationMappingById(integrationMappingId, requestBody, new UpdateTeamsIntegrationMappingByIdHeaders());
    }

    public IntegrationMappingTeams updateTeamsIntegrationMappingById(String integrationMappingId, UpdateTeamsIntegrationMappingByIdHeaders headers) {
        return this.updateTeamsIntegrationMappingById(integrationMappingId, new UpdateTeamsIntegrationMappingByIdRequestBody(), headers);
    }

    public IntegrationMappingTeams updateTeamsIntegrationMappingById(String integrationMappingId, UpdateTeamsIntegrationMappingByIdRequestBody requestBody, UpdateTeamsIntegrationMappingByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/integration_mappings/teams/", UtilsManager.convertToString(integrationMappingId)), "PUT").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), IntegrationMappingTeams.class);
    }

    public void deleteTeamsIntegrationMappingById(String integrationMappingId) {
        this.deleteTeamsIntegrationMappingById(integrationMappingId, new DeleteTeamsIntegrationMappingByIdHeaders());
    }

    public void deleteTeamsIntegrationMappingById(String integrationMappingId, DeleteTeamsIntegrationMappingByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/integration_mappings/teams/", UtilsManager.convertToString(integrationMappingId)), "DELETE").headers(headersMap).responseFormat(ResponseFormat.NO_CONTENT).auth(this.auth).networkSession(this.networkSession).build());
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public IntegrationMappingsManager build() {
            return new IntegrationMappingsManager(this);
        }
    }
}

