/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.chunkeduploads;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.Hash;
import com.box.sdkgen.internal.utils.HashName;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.chunkeduploads.CreateFileUploadSessionCommitByUrlHeaders;
import com.box.sdkgen.managers.chunkeduploads.CreateFileUploadSessionCommitByUrlRequestBody;
import com.box.sdkgen.managers.chunkeduploads.CreateFileUploadSessionCommitHeaders;
import com.box.sdkgen.managers.chunkeduploads.CreateFileUploadSessionCommitRequestBody;
import com.box.sdkgen.managers.chunkeduploads.CreateFileUploadSessionForExistingFileHeaders;
import com.box.sdkgen.managers.chunkeduploads.CreateFileUploadSessionForExistingFileRequestBody;
import com.box.sdkgen.managers.chunkeduploads.CreateFileUploadSessionHeaders;
import com.box.sdkgen.managers.chunkeduploads.CreateFileUploadSessionRequestBody;
import com.box.sdkgen.managers.chunkeduploads.DeleteFileUploadSessionByIdHeaders;
import com.box.sdkgen.managers.chunkeduploads.DeleteFileUploadSessionByUrlHeaders;
import com.box.sdkgen.managers.chunkeduploads.GetFileUploadSessionByIdHeaders;
import com.box.sdkgen.managers.chunkeduploads.GetFileUploadSessionByUrlHeaders;
import com.box.sdkgen.managers.chunkeduploads.GetFileUploadSessionPartsByUrlHeaders;
import com.box.sdkgen.managers.chunkeduploads.GetFileUploadSessionPartsByUrlQueryParams;
import com.box.sdkgen.managers.chunkeduploads.GetFileUploadSessionPartsHeaders;
import com.box.sdkgen.managers.chunkeduploads.GetFileUploadSessionPartsQueryParams;
import com.box.sdkgen.managers.chunkeduploads.PartAccumulator;
import com.box.sdkgen.managers.chunkeduploads.UploadFilePartByUrlHeaders;
import com.box.sdkgen.managers.chunkeduploads.UploadFilePartHeaders;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.filefull.FileFull;
import com.box.sdkgen.schemas.files.Files;
import com.box.sdkgen.schemas.uploadedpart.UploadedPart;
import com.box.sdkgen.schemas.uploadpart.UploadPart;
import com.box.sdkgen.schemas.uploadparts.UploadParts;
import com.box.sdkgen.schemas.uploadsession.UploadSession;
import com.box.sdkgen.serialization.json.JsonManager;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ChunkedUploadsManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public ChunkedUploadsManager() {
        this.networkSession = new NetworkSession();
    }

    protected ChunkedUploadsManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public UploadSession createFileUploadSession(CreateFileUploadSessionRequestBody requestBody) {
        return this.createFileUploadSession(requestBody, new CreateFileUploadSessionHeaders());
    }

    public UploadSession createFileUploadSession(CreateFileUploadSessionRequestBody requestBody, CreateFileUploadSessionHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getUploadUrl(), "/2.0/files/upload_sessions"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), UploadSession.class);
    }

    public UploadSession createFileUploadSessionForExistingFile(String fileId, CreateFileUploadSessionForExistingFileRequestBody requestBody) {
        return this.createFileUploadSessionForExistingFile(fileId, requestBody, new CreateFileUploadSessionForExistingFileHeaders());
    }

    public UploadSession createFileUploadSessionForExistingFile(String fileId, CreateFileUploadSessionForExistingFileRequestBody requestBody, CreateFileUploadSessionForExistingFileHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getUploadUrl(), "/2.0/files/", UtilsManager.convertToString(fileId), "/upload_sessions"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), UploadSession.class);
    }

    public UploadSession getFileUploadSessionByUrl(String url) {
        return this.getFileUploadSessionByUrl(url, new GetFileUploadSessionByUrlHeaders());
    }

    public UploadSession getFileUploadSessionByUrl(String url, GetFileUploadSessionByUrlHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(url, "GET").headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), UploadSession.class);
    }

    public UploadSession getFileUploadSessionById(String uploadSessionId) {
        return this.getFileUploadSessionById(uploadSessionId, new GetFileUploadSessionByIdHeaders());
    }

    public UploadSession getFileUploadSessionById(String uploadSessionId, GetFileUploadSessionByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getUploadUrl(), "/2.0/files/upload_sessions/", UtilsManager.convertToString(uploadSessionId)), "GET").headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), UploadSession.class);
    }

    public UploadedPart uploadFilePartByUrl(String url, InputStream requestBody, UploadFilePartByUrlHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(UtilsManager.entryOf("digest", UtilsManager.convertToString(headers.getDigest())), UtilsManager.entryOf("content-range", UtilsManager.convertToString(headers.getContentRange()))), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(url, "PUT").headers(headersMap).fileStream(requestBody).contentType("application/octet-stream").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), UploadedPart.class);
    }

    public UploadedPart uploadFilePart(String uploadSessionId, InputStream requestBody, UploadFilePartHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(UtilsManager.entryOf("digest", UtilsManager.convertToString(headers.getDigest())), UtilsManager.entryOf("content-range", UtilsManager.convertToString(headers.getContentRange()))), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getUploadUrl(), "/2.0/files/upload_sessions/", UtilsManager.convertToString(uploadSessionId)), "PUT").headers(headersMap).fileStream(requestBody).contentType("application/octet-stream").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), UploadedPart.class);
    }

    public void deleteFileUploadSessionByUrl(String url) {
        this.deleteFileUploadSessionByUrl(url, new DeleteFileUploadSessionByUrlHeaders());
    }

    public void deleteFileUploadSessionByUrl(String url, DeleteFileUploadSessionByUrlHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(url, "DELETE").headers(headersMap).responseFormat(ResponseFormat.NO_CONTENT).auth(this.auth).networkSession(this.networkSession).build());
    }

    public void deleteFileUploadSessionById(String uploadSessionId) {
        this.deleteFileUploadSessionById(uploadSessionId, new DeleteFileUploadSessionByIdHeaders());
    }

    public void deleteFileUploadSessionById(String uploadSessionId, DeleteFileUploadSessionByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getUploadUrl(), "/2.0/files/upload_sessions/", UtilsManager.convertToString(uploadSessionId)), "DELETE").headers(headersMap).responseFormat(ResponseFormat.NO_CONTENT).auth(this.auth).networkSession(this.networkSession).build());
    }

    public UploadParts getFileUploadSessionPartsByUrl(String url) {
        return this.getFileUploadSessionPartsByUrl(url, new GetFileUploadSessionPartsByUrlQueryParams(), new GetFileUploadSessionPartsByUrlHeaders());
    }

    public UploadParts getFileUploadSessionPartsByUrl(String url, GetFileUploadSessionPartsByUrlQueryParams queryParams) {
        return this.getFileUploadSessionPartsByUrl(url, queryParams, new GetFileUploadSessionPartsByUrlHeaders());
    }

    public UploadParts getFileUploadSessionPartsByUrl(String url, GetFileUploadSessionPartsByUrlHeaders headers) {
        return this.getFileUploadSessionPartsByUrl(url, new GetFileUploadSessionPartsByUrlQueryParams(), headers);
    }

    public UploadParts getFileUploadSessionPartsByUrl(String url, GetFileUploadSessionPartsByUrlQueryParams queryParams, GetFileUploadSessionPartsByUrlHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("offset", UtilsManager.convertToString(queryParams.getOffset())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(url, "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), UploadParts.class);
    }

    public UploadParts getFileUploadSessionParts(String uploadSessionId) {
        return this.getFileUploadSessionParts(uploadSessionId, new GetFileUploadSessionPartsQueryParams(), new GetFileUploadSessionPartsHeaders());
    }

    public UploadParts getFileUploadSessionParts(String uploadSessionId, GetFileUploadSessionPartsQueryParams queryParams) {
        return this.getFileUploadSessionParts(uploadSessionId, queryParams, new GetFileUploadSessionPartsHeaders());
    }

    public UploadParts getFileUploadSessionParts(String uploadSessionId, GetFileUploadSessionPartsHeaders headers) {
        return this.getFileUploadSessionParts(uploadSessionId, new GetFileUploadSessionPartsQueryParams(), headers);
    }

    public UploadParts getFileUploadSessionParts(String uploadSessionId, GetFileUploadSessionPartsQueryParams queryParams, GetFileUploadSessionPartsHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("offset", UtilsManager.convertToString(queryParams.getOffset())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getUploadUrl(), "/2.0/files/upload_sessions/", UtilsManager.convertToString(uploadSessionId), "/parts"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), UploadParts.class);
    }

    public Files createFileUploadSessionCommitByUrl(String url, CreateFileUploadSessionCommitByUrlRequestBody requestBody, CreateFileUploadSessionCommitByUrlHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(UtilsManager.entryOf("digest", UtilsManager.convertToString(headers.getDigest())), UtilsManager.entryOf("if-match", UtilsManager.convertToString(headers.getIfMatch())), UtilsManager.entryOf("if-none-match", UtilsManager.convertToString(headers.getIfNoneMatch()))), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(url, "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        if (UtilsManager.convertToString(response.getStatus()).equals("202")) {
            return null;
        }
        return JsonManager.deserialize(response.getData(), Files.class);
    }

    public Files createFileUploadSessionCommit(String uploadSessionId, CreateFileUploadSessionCommitRequestBody requestBody, CreateFileUploadSessionCommitHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(UtilsManager.entryOf("digest", UtilsManager.convertToString(headers.getDigest())), UtilsManager.entryOf("if-match", UtilsManager.convertToString(headers.getIfMatch())), UtilsManager.entryOf("if-none-match", UtilsManager.convertToString(headers.getIfNoneMatch()))), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getUploadUrl(), "/2.0/files/upload_sessions/", UtilsManager.convertToString(uploadSessionId), "/commit"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        if (UtilsManager.convertToString(response.getStatus()).equals("202")) {
            return null;
        }
        return JsonManager.deserialize(response.getData(), Files.class);
    }

    public PartAccumulator reducer(PartAccumulator acc, InputStream chunk) {
        long lastIndex = acc.getLastIndex();
        List<UploadPart> parts = acc.getParts();
        byte[] chunkBuffer = UtilsManager.readByteStream(chunk);
        Hash hash = new Hash(HashName.SHA1);
        hash.updateHash(chunkBuffer);
        String sha1 = hash.digestHash("base64");
        String digest = String.join((CharSequence)"", "sha=", sha1);
        int chunkSize = UtilsManager.bufferLength(chunkBuffer);
        long bytesStart = lastIndex + 1L;
        long bytesEnd = lastIndex + (long)chunkSize;
        String contentRange = String.join((CharSequence)"", "bytes ", UtilsManager.convertToString(bytesStart), "-", UtilsManager.convertToString(bytesEnd), "/", UtilsManager.convertToString(acc.getFileSize()));
        UploadedPart uploadedPart = this.uploadFilePartByUrl(acc.getUploadPartUrl(), UtilsManager.generateByteStreamFromBuffer(chunkBuffer), new UploadFilePartByUrlHeaders(digest, contentRange));
        UploadPart part = uploadedPart.getPart();
        String partSha1 = UtilsManager.hexToBase64(part.getSha1());
        assert (partSha1.equals(sha1));
        assert (part.getSize() == (long)chunkSize);
        assert (part.getOffset() == bytesStart);
        acc.getFileHash().updateHash(chunkBuffer);
        return new PartAccumulator(bytesEnd, Stream.concat(parts.stream(), Arrays.asList(part).stream()).collect(Collectors.toList()), acc.getFileSize(), acc.getUploadPartUrl(), acc.getFileHash());
    }

    public FileFull uploadBigFile(InputStream file, String fileName, long fileSize, String parentFolderId) {
        UploadSession uploadSession = this.createFileUploadSession(new CreateFileUploadSessionRequestBody(parentFolderId, fileSize, fileName));
        String uploadPartUrl = uploadSession.getSessionEndpoints().getUploadPart();
        String commitUrl = uploadSession.getSessionEndpoints().getCommit();
        String listPartsUrl = uploadSession.getSessionEndpoints().getListParts();
        long partSize = uploadSession.getPartSize();
        int totalParts = uploadSession.getTotalParts();
        assert (partSize * (long)totalParts >= fileSize);
        assert (uploadSession.getNumPartsProcessed() == 0);
        Hash fileHash = new Hash(HashName.SHA1);
        Iterator<InputStream> chunksIterator = UtilsManager.iterateChunks(file, partSize, fileSize);
        PartAccumulator results = UtilsManager.reduceIterator(chunksIterator, this::reducer, new PartAccumulator(-1L, Collections.emptyList(), fileSize, uploadPartUrl, fileHash));
        List<UploadPart> parts = results.getParts();
        UploadParts processedSessionParts = this.getFileUploadSessionPartsByUrl(listPartsUrl);
        assert (processedSessionParts.getTotalCount() == (long)totalParts);
        String sha1 = fileHash.digestHash("base64");
        String digest = String.join((CharSequence)"", "sha=", sha1);
        Files committedSession = this.createFileUploadSessionCommitByUrl(commitUrl, new CreateFileUploadSessionCommitByUrlRequestBody(parts), new CreateFileUploadSessionCommitByUrlHeaders(digest));
        return committedSession.getEntries().get(0);
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public ChunkedUploadsManager build() {
            return new ChunkedUploadsManager(this);
        }
    }
}

