/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.box.jwtauth;

import com.box.sdkgen.box.jwtauth.JwtConfigFile;
import com.box.sdkgen.box.tokenstorage.InMemoryTokenStorage;
import com.box.sdkgen.box.tokenstorage.TokenStorage;
import com.box.sdkgen.internal.utils.DefaultPrivateKeyDecryptor;
import com.box.sdkgen.internal.utils.JwtAlgorithm;
import com.box.sdkgen.internal.utils.PrivateKeyDecryptor;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.serialization.json.EnumWrapper;
import com.box.sdkgen.serialization.json.JsonManager;

public class JWTConfig {
    public final String clientId;
    public final String clientSecret;
    public final String jwtKeyId;
    public final String privateKey;
    public final String privateKeyPassphrase;
    public String enterpriseId;
    public String userId;
    public EnumWrapper<JwtAlgorithm> algorithm;
    public TokenStorage tokenStorage;
    public PrivateKeyDecryptor privateKeyDecryptor;

    public JWTConfig(String clientId, String clientSecret, String jwtKeyId, String privateKey, String privateKeyPassphrase) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.jwtKeyId = jwtKeyId;
        this.privateKey = privateKey;
        this.privateKeyPassphrase = privateKeyPassphrase;
        this.algorithm = new EnumWrapper<JwtAlgorithm>(JwtAlgorithm.RS256);
        this.tokenStorage = new InMemoryTokenStorage();
        this.privateKeyDecryptor = new DefaultPrivateKeyDecryptor();
    }

    protected JWTConfig(Builder builder) {
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.jwtKeyId = builder.jwtKeyId;
        this.privateKey = builder.privateKey;
        this.privateKeyPassphrase = builder.privateKeyPassphrase;
        this.enterpriseId = builder.enterpriseId;
        this.userId = builder.userId;
        this.algorithm = builder.algorithm;
        this.tokenStorage = builder.tokenStorage;
        this.privateKeyDecryptor = builder.privateKeyDecryptor;
    }

    public static JWTConfig fromConfigJsonString(String configJsonString) {
        return JWTConfig.fromConfigJsonString(configJsonString, null, null);
    }

    public static JWTConfig fromConfigJsonString(String configJsonString, TokenStorage tokenStorage) {
        return JWTConfig.fromConfigJsonString(configJsonString, tokenStorage, null);
    }

    public static JWTConfig fromConfigJsonString(String configJsonString, PrivateKeyDecryptor privateKeyDecryptor) {
        return JWTConfig.fromConfigJsonString(configJsonString, null, privateKeyDecryptor);
    }

    public static JWTConfig fromConfigJsonString(String configJsonString, TokenStorage tokenStorage, PrivateKeyDecryptor privateKeyDecryptor) {
        JwtConfigFile configJson = JsonManager.deserialize(JsonManager.jsonToSerializedData(configJsonString), JwtConfigFile.class);
        TokenStorage tokenStorageToUse = tokenStorage == null ? new InMemoryTokenStorage() : tokenStorage;
        PrivateKeyDecryptor privateKeyDecryptorToUse = privateKeyDecryptor == null ? new DefaultPrivateKeyDecryptor() : privateKeyDecryptor;
        JWTConfig newConfig = new Builder(configJson.getBoxAppSettings().getClientId(), configJson.getBoxAppSettings().getClientSecret(), configJson.getBoxAppSettings().getAppAuth().getPublicKeyId(), configJson.getBoxAppSettings().getAppAuth().getPrivateKey(), configJson.getBoxAppSettings().getAppAuth().getPassphrase()).enterpriseId(configJson.getEnterpriseId()).userId(configJson.getUserId()).tokenStorage(tokenStorageToUse).privateKeyDecryptor(privateKeyDecryptorToUse).build();
        return newConfig;
    }

    public static JWTConfig fromConfigFile(String configFilePath) {
        return JWTConfig.fromConfigFile(configFilePath, null, null);
    }

    public static JWTConfig fromConfigFile(String configFilePath, TokenStorage tokenStorage) {
        return JWTConfig.fromConfigFile(configFilePath, tokenStorage, null);
    }

    public static JWTConfig fromConfigFile(String configFilePath, PrivateKeyDecryptor privateKeyDecryptor) {
        return JWTConfig.fromConfigFile(configFilePath, null, privateKeyDecryptor);
    }

    public static JWTConfig fromConfigFile(String configFilePath, TokenStorage tokenStorage, PrivateKeyDecryptor privateKeyDecryptor) {
        String configJsonString = UtilsManager.readTextFromFile(configFilePath);
        return JWTConfig.fromConfigJsonString(configJsonString, tokenStorage, privateKeyDecryptor);
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getJwtKeyId() {
        return this.jwtKeyId;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getPrivateKeyPassphrase() {
        return this.privateKeyPassphrase;
    }

    public String getEnterpriseId() {
        return this.enterpriseId;
    }

    public String getUserId() {
        return this.userId;
    }

    public EnumWrapper<JwtAlgorithm> getAlgorithm() {
        return this.algorithm;
    }

    public TokenStorage getTokenStorage() {
        return this.tokenStorage;
    }

    public PrivateKeyDecryptor getPrivateKeyDecryptor() {
        return this.privateKeyDecryptor;
    }

    public static class Builder {
        protected final String clientId;
        protected final String clientSecret;
        protected final String jwtKeyId;
        protected final String privateKey;
        protected final String privateKeyPassphrase;
        protected String enterpriseId;
        protected String userId;
        protected EnumWrapper<JwtAlgorithm> algorithm;
        protected TokenStorage tokenStorage;
        protected PrivateKeyDecryptor privateKeyDecryptor;

        public Builder(String clientId, String clientSecret, String jwtKeyId, String privateKey, String privateKeyPassphrase) {
            this.clientId = clientId;
            this.clientSecret = clientSecret;
            this.jwtKeyId = jwtKeyId;
            this.privateKey = privateKey;
            this.privateKeyPassphrase = privateKeyPassphrase;
            this.algorithm = new EnumWrapper<JwtAlgorithm>(JwtAlgorithm.RS256);
            this.tokenStorage = new InMemoryTokenStorage();
            this.privateKeyDecryptor = new DefaultPrivateKeyDecryptor();
        }

        public Builder enterpriseId(String enterpriseId) {
            this.enterpriseId = enterpriseId;
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder algorithm(JwtAlgorithm algorithm) {
            this.algorithm = new EnumWrapper<JwtAlgorithm>(algorithm);
            return this;
        }

        public Builder algorithm(EnumWrapper<JwtAlgorithm> algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Builder tokenStorage(TokenStorage tokenStorage) {
            this.tokenStorage = tokenStorage;
            return this;
        }

        public Builder privateKeyDecryptor(PrivateKeyDecryptor privateKeyDecryptor) {
            this.privateKeyDecryptor = privateKeyDecryptor;
            return this;
        }

        public JWTConfig build() {
            return new JWTConfig(this);
        }
    }
}

