/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.schemas.signrequest;

import com.box.sdkgen.internal.Nullable;
import com.box.sdkgen.internal.utils.DateTimeUtils;
import com.box.sdkgen.schemas.filebase.FileBase;
import com.box.sdkgen.schemas.filemini.FileMini;
import com.box.sdkgen.schemas.foldermini.FolderMini;
import com.box.sdkgen.schemas.signrequest.SignRequestSignFilesField;
import com.box.sdkgen.schemas.signrequest.SignRequestStatusField;
import com.box.sdkgen.schemas.signrequest.SignRequestTypeField;
import com.box.sdkgen.schemas.signrequestbase.SignRequestBase;
import com.box.sdkgen.schemas.signrequestprefilltag.SignRequestPrefillTag;
import com.box.sdkgen.schemas.signrequestsigner.SignRequestSigner;
import com.box.sdkgen.serialization.json.EnumWrapper;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

@JsonFilter(value="nullablePropertyFilter")
public class SignRequest
extends SignRequestBase {
    @JsonDeserialize(using=SignRequestTypeField.SignRequestTypeFieldDeserializer.class)
    @JsonSerialize(using=SignRequestTypeField.SignRequestTypeFieldSerializer.class)
    protected EnumWrapper<SignRequestTypeField> type;
    @JsonProperty(value="source_files")
    protected List<FileBase> sourceFiles;
    protected List<SignRequestSigner> signers;
    @JsonProperty(value="signature_color")
    @Nullable
    protected String signatureColor;
    protected String id;
    @JsonProperty(value="prepare_url")
    @Nullable
    protected String prepareUrl;
    @JsonProperty(value="signing_log")
    protected FileMini signingLog;
    @JsonDeserialize(using=SignRequestStatusField.SignRequestStatusFieldDeserializer.class)
    @JsonSerialize(using=SignRequestStatusField.SignRequestStatusFieldSerializer.class)
    protected EnumWrapper<SignRequestStatusField> status;
    @JsonProperty(value="sign_files")
    protected SignRequestSignFilesField signFiles;
    @JsonProperty(value="auto_expire_at")
    @JsonSerialize(using=DateTimeUtils.DateTimeSerializer.class)
    @JsonDeserialize(using=DateTimeUtils.DateTimeDeserializer.class)
    @Nullable
    protected OffsetDateTime autoExpireAt;
    @JsonProperty(value="parent_folder")
    protected FolderMini parentFolder;
    @JsonProperty(value="collaborator_level")
    @Nullable
    protected String collaboratorLevel;
    @JsonProperty(value="short_id")
    protected String shortId;
    @JsonProperty(value="created_at")
    @JsonSerialize(using=DateTimeUtils.DateTimeSerializer.class)
    @JsonDeserialize(using=DateTimeUtils.DateTimeDeserializer.class)
    protected OffsetDateTime createdAt;
    @JsonProperty(value="finished_at")
    @JsonSerialize(using=DateTimeUtils.DateTimeSerializer.class)
    @JsonDeserialize(using=DateTimeUtils.DateTimeDeserializer.class)
    @Nullable
    protected OffsetDateTime finishedAt;
    @JsonProperty(value="sender_email")
    @Nullable
    protected String senderEmail;
    @JsonProperty(value="sender_id")
    @Nullable
    protected Long senderId;

    public SignRequest() {
    }

    protected SignRequest(Builder builder) {
        super(builder);
        this.type = builder.type;
        this.sourceFiles = builder.sourceFiles;
        this.signers = builder.signers;
        this.signatureColor = builder.signatureColor;
        this.id = builder.id;
        this.prepareUrl = builder.prepareUrl;
        this.signingLog = builder.signingLog;
        this.status = builder.status;
        this.signFiles = builder.signFiles;
        this.autoExpireAt = builder.autoExpireAt;
        this.parentFolder = builder.parentFolder;
        this.collaboratorLevel = builder.collaboratorLevel;
        this.shortId = builder.shortId;
        this.createdAt = builder.createdAt;
        this.finishedAt = builder.finishedAt;
        this.senderEmail = builder.senderEmail;
        this.senderId = builder.senderId;
        this.markNullableFieldsAsSet(builder.getExplicitlySetNullableFields());
    }

    public EnumWrapper<SignRequestTypeField> getType() {
        return this.type;
    }

    public List<FileBase> getSourceFiles() {
        return this.sourceFiles;
    }

    public List<SignRequestSigner> getSigners() {
        return this.signers;
    }

    public String getSignatureColor() {
        return this.signatureColor;
    }

    public String getId() {
        return this.id;
    }

    public String getPrepareUrl() {
        return this.prepareUrl;
    }

    public FileMini getSigningLog() {
        return this.signingLog;
    }

    public EnumWrapper<SignRequestStatusField> getStatus() {
        return this.status;
    }

    public SignRequestSignFilesField getSignFiles() {
        return this.signFiles;
    }

    public OffsetDateTime getAutoExpireAt() {
        return this.autoExpireAt;
    }

    public FolderMini getParentFolder() {
        return this.parentFolder;
    }

    public String getCollaboratorLevel() {
        return this.collaboratorLevel;
    }

    public String getShortId() {
        return this.shortId;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public OffsetDateTime getFinishedAt() {
        return this.finishedAt;
    }

    public String getSenderEmail() {
        return this.senderEmail;
    }

    public Long getSenderId() {
        return this.senderId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignRequest casted = (SignRequest)o;
        return Objects.equals(this.isDocumentPreparationNeeded, casted.isDocumentPreparationNeeded) && Objects.equals(this.redirectUrl, casted.redirectUrl) && Objects.equals(this.declinedRedirectUrl, casted.declinedRedirectUrl) && Objects.equals(this.areTextSignaturesEnabled, casted.areTextSignaturesEnabled) && Objects.equals(this.emailSubject, casted.emailSubject) && Objects.equals(this.emailMessage, casted.emailMessage) && Objects.equals(this.areRemindersEnabled, casted.areRemindersEnabled) && Objects.equals(this.name, casted.name) && Objects.equals(this.prefillTags, casted.prefillTags) && Objects.equals(this.daysValid, casted.daysValid) && Objects.equals(this.externalId, casted.externalId) && Objects.equals(this.templateId, casted.templateId) && Objects.equals(this.externalSystemName, casted.externalSystemName) && Objects.equals(this.type, casted.type) && Objects.equals(this.sourceFiles, casted.sourceFiles) && Objects.equals(this.signers, casted.signers) && Objects.equals(this.signatureColor, casted.signatureColor) && Objects.equals(this.id, casted.id) && Objects.equals(this.prepareUrl, casted.prepareUrl) && Objects.equals(this.signingLog, casted.signingLog) && Objects.equals(this.status, casted.status) && Objects.equals(this.signFiles, casted.signFiles) && Objects.equals(this.autoExpireAt, casted.autoExpireAt) && Objects.equals(this.parentFolder, casted.parentFolder) && Objects.equals(this.collaboratorLevel, casted.collaboratorLevel) && Objects.equals(this.shortId, casted.shortId) && Objects.equals(this.createdAt, casted.createdAt) && Objects.equals(this.finishedAt, casted.finishedAt) && Objects.equals(this.senderEmail, casted.senderEmail) && Objects.equals(this.senderId, casted.senderId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.isDocumentPreparationNeeded, this.redirectUrl, this.declinedRedirectUrl, this.areTextSignaturesEnabled, this.emailSubject, this.emailMessage, this.areRemindersEnabled, this.name, this.prefillTags, this.daysValid, this.externalId, this.templateId, this.externalSystemName, this.type, this.sourceFiles, this.signers, this.signatureColor, this.id, this.prepareUrl, this.signingLog, this.status, this.signFiles, this.autoExpireAt, this.parentFolder, this.collaboratorLevel, this.shortId, this.createdAt, this.finishedAt, this.senderEmail, this.senderId);
    }

    @Override
    public String toString() {
        return "SignRequest{isDocumentPreparationNeeded='" + this.isDocumentPreparationNeeded + '\'' + ", redirectUrl='" + this.redirectUrl + '\'' + ", declinedRedirectUrl='" + this.declinedRedirectUrl + '\'' + ", areTextSignaturesEnabled='" + this.areTextSignaturesEnabled + '\'' + ", emailSubject='" + this.emailSubject + '\'' + ", emailMessage='" + this.emailMessage + '\'' + ", areRemindersEnabled='" + this.areRemindersEnabled + '\'' + ", name='" + this.name + '\'' + ", prefillTags='" + this.prefillTags + '\'' + ", daysValid='" + this.daysValid + '\'' + ", externalId='" + this.externalId + '\'' + ", templateId='" + this.templateId + '\'' + ", externalSystemName='" + this.externalSystemName + '\'' + ", type='" + this.type + '\'' + ", sourceFiles='" + this.sourceFiles + '\'' + ", signers='" + this.signers + '\'' + ", signatureColor='" + this.signatureColor + '\'' + ", id='" + this.id + '\'' + ", prepareUrl='" + this.prepareUrl + '\'' + ", signingLog='" + this.signingLog + '\'' + ", status='" + this.status + '\'' + ", signFiles='" + this.signFiles + '\'' + ", autoExpireAt='" + this.autoExpireAt + '\'' + ", parentFolder='" + this.parentFolder + '\'' + ", collaboratorLevel='" + this.collaboratorLevel + '\'' + ", shortId='" + this.shortId + '\'' + ", createdAt='" + this.createdAt + '\'' + ", finishedAt='" + this.finishedAt + '\'' + ", senderEmail='" + this.senderEmail + '\'' + ", senderId='" + this.senderId + '\'' + "}";
    }

    public static class Builder
    extends SignRequestBase.Builder {
        protected EnumWrapper<SignRequestTypeField> type;
        protected List<FileBase> sourceFiles;
        protected List<SignRequestSigner> signers;
        protected String signatureColor;
        protected String id;
        protected String prepareUrl;
        protected FileMini signingLog;
        protected EnumWrapper<SignRequestStatusField> status;
        protected SignRequestSignFilesField signFiles;
        protected OffsetDateTime autoExpireAt;
        protected FolderMini parentFolder;
        protected String collaboratorLevel;
        protected String shortId;
        protected OffsetDateTime createdAt;
        protected OffsetDateTime finishedAt;
        protected String senderEmail;
        protected Long senderId;

        public Builder type(SignRequestTypeField type) {
            this.type = new EnumWrapper<SignRequestTypeField>(type);
            return this;
        }

        public Builder type(EnumWrapper<SignRequestTypeField> type) {
            this.type = type;
            return this;
        }

        public Builder sourceFiles(List<FileBase> sourceFiles) {
            this.sourceFiles = sourceFiles;
            return this;
        }

        public Builder signers(List<SignRequestSigner> signers) {
            this.signers = signers;
            return this;
        }

        public Builder signatureColor(String signatureColor) {
            this.signatureColor = signatureColor;
            this.markNullableFieldAsSet("signature_color");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder prepareUrl(String prepareUrl) {
            this.prepareUrl = prepareUrl;
            this.markNullableFieldAsSet("prepare_url");
            return this;
        }

        public Builder signingLog(FileMini signingLog) {
            this.signingLog = signingLog;
            return this;
        }

        public Builder status(SignRequestStatusField status) {
            this.status = new EnumWrapper<SignRequestStatusField>(status);
            return this;
        }

        public Builder status(EnumWrapper<SignRequestStatusField> status) {
            this.status = status;
            return this;
        }

        public Builder signFiles(SignRequestSignFilesField signFiles) {
            this.signFiles = signFiles;
            return this;
        }

        public Builder autoExpireAt(OffsetDateTime autoExpireAt) {
            this.autoExpireAt = autoExpireAt;
            this.markNullableFieldAsSet("auto_expire_at");
            return this;
        }

        public Builder parentFolder(FolderMini parentFolder) {
            this.parentFolder = parentFolder;
            return this;
        }

        public Builder collaboratorLevel(String collaboratorLevel) {
            this.collaboratorLevel = collaboratorLevel;
            this.markNullableFieldAsSet("collaborator_level");
            return this;
        }

        public Builder shortId(String shortId) {
            this.shortId = shortId;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder finishedAt(OffsetDateTime finishedAt) {
            this.finishedAt = finishedAt;
            this.markNullableFieldAsSet("finished_at");
            return this;
        }

        public Builder senderEmail(String senderEmail) {
            this.senderEmail = senderEmail;
            this.markNullableFieldAsSet("sender_email");
            return this;
        }

        public Builder senderId(Long senderId) {
            this.senderId = senderId;
            this.markNullableFieldAsSet("sender_id");
            return this;
        }

        @Override
        public Builder isDocumentPreparationNeeded(Boolean isDocumentPreparationNeeded) {
            this.isDocumentPreparationNeeded = isDocumentPreparationNeeded;
            return this;
        }

        @Override
        public Builder redirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
            this.markNullableFieldAsSet("redirect_url");
            return this;
        }

        @Override
        public Builder declinedRedirectUrl(String declinedRedirectUrl) {
            this.declinedRedirectUrl = declinedRedirectUrl;
            this.markNullableFieldAsSet("declined_redirect_url");
            return this;
        }

        @Override
        public Builder areTextSignaturesEnabled(Boolean areTextSignaturesEnabled) {
            this.areTextSignaturesEnabled = areTextSignaturesEnabled;
            return this;
        }

        @Override
        public Builder emailSubject(String emailSubject) {
            this.emailSubject = emailSubject;
            this.markNullableFieldAsSet("email_subject");
            return this;
        }

        @Override
        public Builder emailMessage(String emailMessage) {
            this.emailMessage = emailMessage;
            this.markNullableFieldAsSet("email_message");
            return this;
        }

        @Override
        public Builder areRemindersEnabled(Boolean areRemindersEnabled) {
            this.areRemindersEnabled = areRemindersEnabled;
            return this;
        }

        @Override
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder prefillTags(List<SignRequestPrefillTag> prefillTags) {
            this.prefillTags = prefillTags;
            return this;
        }

        @Override
        public Builder daysValid(Long daysValid) {
            this.daysValid = daysValid;
            this.markNullableFieldAsSet("days_valid");
            return this;
        }

        @Override
        public Builder externalId(String externalId) {
            this.externalId = externalId;
            this.markNullableFieldAsSet("external_id");
            return this;
        }

        @Override
        public Builder templateId(String templateId) {
            this.templateId = templateId;
            this.markNullableFieldAsSet("template_id");
            return this;
        }

        @Override
        public Builder externalSystemName(String externalSystemName) {
            this.externalSystemName = externalSystemName;
            this.markNullableFieldAsSet("external_system_name");
            return this;
        }

        @Override
        public SignRequest build() {
            return new SignRequest(this);
        }
    }
}

