/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.schemas.item;

import com.box.sdkgen.internal.OneOfThree;
import com.box.sdkgen.schemas.filefull.FileFull;
import com.box.sdkgen.schemas.folderfull.FolderFull;
import com.box.sdkgen.schemas.weblink.WebLink;
import com.box.sdkgen.serialization.json.EnumWrapper;
import com.box.sdkgen.serialization.json.JsonManager;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Closeable;
import java.io.IOException;

@JsonDeserialize(using=ItemDeserializer.class)
@JsonSerialize(using=OneOfThree.OneOfThreeSerializer.class)
public class Item
extends OneOfThree<FileFull, FolderFull, WebLink> {
    protected final String sequenceId;
    protected final String name;
    protected final String id;
    protected final String etag;
    protected final String type;

    public Item(FileFull fileFull) {
        super(fileFull, null, null);
        this.sequenceId = fileFull.getSequenceId();
        this.name = fileFull.getName();
        this.id = fileFull.getId();
        this.etag = fileFull.getEtag();
        this.type = EnumWrapper.convertToString(fileFull.getType());
    }

    public Item(FolderFull folderFull) {
        super(null, folderFull, null);
        this.sequenceId = folderFull.getSequenceId();
        this.name = folderFull.getName();
        this.id = folderFull.getId();
        this.etag = folderFull.getEtag();
        this.type = EnumWrapper.convertToString(folderFull.getType());
    }

    public Item(WebLink webLink) {
        super(null, null, webLink);
        this.sequenceId = webLink.getSequenceId();
        this.name = webLink.getName();
        this.id = webLink.getId();
        this.etag = webLink.getEtag();
        this.type = EnumWrapper.convertToString(webLink.getType());
    }

    public boolean isFileFull() {
        return this.value0 != null;
    }

    public FileFull getFileFull() {
        return (FileFull)this.value0;
    }

    public boolean isFolderFull() {
        return this.value1 != null;
    }

    public FolderFull getFolderFull() {
        return (FolderFull)this.value1;
    }

    public boolean isWebLink() {
        return this.value2 != null;
    }

    public WebLink getWebLink() {
        return (WebLink)this.value2;
    }

    public String getSequenceId() {
        return this.sequenceId;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getEtag() {
        return this.etag;
    }

    public String getType() {
        return this.type;
    }

    static class ItemDeserializer
    extends JsonDeserializer<Item> {
        public Item deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode node = JsonManager.jsonToSerializedData(jp);
            JsonNode discriminant0 = node.get("type");
            if (discriminant0 != null) {
                switch (discriminant0.asText()) {
                    case "file": {
                        return new Item(JsonManager.deserialize(node, FileFull.class));
                    }
                    case "folder": {
                        return new Item(JsonManager.deserialize(node, FolderFull.class));
                    }
                    case "web_link": {
                        return new Item(JsonManager.deserialize(node, WebLink.class));
                    }
                }
            }
            throw new JsonMappingException((Closeable)jp, "Unable to deserialize Item");
        }
    }
}

