/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.schemas.event;

import com.box.sdkgen.internal.NullableFieldTracker;
import com.box.sdkgen.internal.SerializableObject;
import com.box.sdkgen.internal.utils.DateTimeUtils;
import com.box.sdkgen.schemas.appitemeventsource.AppItemEventSource;
import com.box.sdkgen.schemas.event.EventEventTypeField;
import com.box.sdkgen.schemas.eventsource.EventSource;
import com.box.sdkgen.schemas.eventsourceresource.EventSourceResource;
import com.box.sdkgen.schemas.file.File;
import com.box.sdkgen.schemas.folder.Folder;
import com.box.sdkgen.schemas.user.User;
import com.box.sdkgen.schemas.usermini.UserMini;
import com.box.sdkgen.serialization.json.EnumWrapper;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Objects;

@JsonFilter(value="nullablePropertyFilter")
public class Event
extends SerializableObject {
    protected String type;
    @JsonProperty(value="created_at")
    @JsonSerialize(using=DateTimeUtils.DateTimeSerializer.class)
    @JsonDeserialize(using=DateTimeUtils.DateTimeDeserializer.class)
    protected OffsetDateTime createdAt;
    @JsonProperty(value="recorded_at")
    @JsonSerialize(using=DateTimeUtils.DateTimeSerializer.class)
    @JsonDeserialize(using=DateTimeUtils.DateTimeDeserializer.class)
    protected OffsetDateTime recordedAt;
    @JsonProperty(value="event_id")
    protected String eventId;
    @JsonProperty(value="created_by")
    protected UserMini createdBy;
    @JsonDeserialize(using=EventEventTypeField.EventEventTypeFieldDeserializer.class)
    @JsonSerialize(using=EventEventTypeField.EventEventTypeFieldSerializer.class)
    @JsonProperty(value="event_type")
    protected EnumWrapper<EventEventTypeField> eventType;
    @JsonProperty(value="session_id")
    protected String sessionId;
    protected EventSourceResource source;
    @JsonProperty(value="additional_details")
    protected Map<String, Object> additionalDetails;

    public Event() {
    }

    protected Event(Builder builder) {
        this.type = builder.type;
        this.createdAt = builder.createdAt;
        this.recordedAt = builder.recordedAt;
        this.eventId = builder.eventId;
        this.createdBy = builder.createdBy;
        this.eventType = builder.eventType;
        this.sessionId = builder.sessionId;
        this.source = builder.source;
        this.additionalDetails = builder.additionalDetails;
        this.markNullableFieldsAsSet(builder.getExplicitlySetNullableFields());
    }

    public String getType() {
        return this.type;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public OffsetDateTime getRecordedAt() {
        return this.recordedAt;
    }

    public String getEventId() {
        return this.eventId;
    }

    public UserMini getCreatedBy() {
        return this.createdBy;
    }

    public EnumWrapper<EventEventTypeField> getEventType() {
        return this.eventType;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public EventSourceResource getSource() {
        return this.source;
    }

    public Map<String, Object> getAdditionalDetails() {
        return this.additionalDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event casted = (Event)o;
        return Objects.equals(this.type, casted.type) && Objects.equals(this.createdAt, casted.createdAt) && Objects.equals(this.recordedAt, casted.recordedAt) && Objects.equals(this.eventId, casted.eventId) && Objects.equals(this.createdBy, casted.createdBy) && Objects.equals(this.eventType, casted.eventType) && Objects.equals(this.sessionId, casted.sessionId) && Objects.equals(this.source, casted.source) && Objects.equals(this.additionalDetails, casted.additionalDetails);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.createdAt, this.recordedAt, this.eventId, this.createdBy, this.eventType, this.sessionId, this.source, this.additionalDetails);
    }

    public String toString() {
        return "Event{type='" + this.type + '\'' + ", createdAt='" + this.createdAt + '\'' + ", recordedAt='" + this.recordedAt + '\'' + ", eventId='" + this.eventId + '\'' + ", createdBy='" + this.createdBy + '\'' + ", eventType='" + this.eventType + '\'' + ", sessionId='" + this.sessionId + '\'' + ", source='" + this.source + '\'' + ", additionalDetails='" + this.additionalDetails + '\'' + "}";
    }

    public static class Builder
    extends NullableFieldTracker {
        protected String type;
        protected OffsetDateTime createdAt;
        protected OffsetDateTime recordedAt;
        protected String eventId;
        protected UserMini createdBy;
        protected EnumWrapper<EventEventTypeField> eventType;
        protected String sessionId;
        protected EventSourceResource source;
        protected Map<String, Object> additionalDetails;

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder recordedAt(OffsetDateTime recordedAt) {
            this.recordedAt = recordedAt;
            return this;
        }

        public Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public Builder createdBy(UserMini createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public Builder eventType(EventEventTypeField eventType) {
            this.eventType = new EnumWrapper<EventEventTypeField>(eventType);
            return this;
        }

        public Builder eventType(EnumWrapper<EventEventTypeField> eventType) {
            this.eventType = eventType;
            return this;
        }

        public Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public Builder source(User source) {
            this.source = new EventSourceResource(source);
            return this;
        }

        public Builder source(EventSource source) {
            this.source = new EventSourceResource(source);
            return this;
        }

        public Builder source(File source) {
            this.source = new EventSourceResource(source);
            return this;
        }

        public Builder source(Folder source) {
            this.source = new EventSourceResource(source);
            return this;
        }

        public Builder source(Map<String, Object> source) {
            this.source = new EventSourceResource(source);
            return this;
        }

        public Builder source(AppItemEventSource source) {
            this.source = new EventSourceResource(source);
            return this;
        }

        public Builder source(EventSourceResource source) {
            this.source = source;
            return this;
        }

        public Builder additionalDetails(Map<String, Object> additionalDetails) {
            this.additionalDetails = additionalDetails;
            return this;
        }

        public Event build() {
            return new Event(this);
        }
    }
}

