/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.emailaliases;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.emailaliases.CreateUserEmailAliasHeaders;
import com.box.sdkgen.managers.emailaliases.CreateUserEmailAliasRequestBody;
import com.box.sdkgen.managers.emailaliases.DeleteUserEmailAliasByIdHeaders;
import com.box.sdkgen.managers.emailaliases.GetUserEmailAliasesHeaders;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.emailalias.EmailAlias;
import com.box.sdkgen.schemas.emailaliases.EmailAliases;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class EmailAliasesManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public EmailAliasesManager() {
        this.networkSession = new NetworkSession();
    }

    protected EmailAliasesManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public EmailAliases getUserEmailAliases(String userId) {
        return this.getUserEmailAliases(userId, new GetUserEmailAliasesHeaders());
    }

    public EmailAliases getUserEmailAliases(String userId, GetUserEmailAliasesHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/users/", UtilsManager.convertToString(userId), "/email_aliases"), "GET").headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), EmailAliases.class);
    }

    public EmailAlias createUserEmailAlias(String userId, CreateUserEmailAliasRequestBody requestBody) {
        return this.createUserEmailAlias(userId, requestBody, new CreateUserEmailAliasHeaders());
    }

    public EmailAlias createUserEmailAlias(String userId, CreateUserEmailAliasRequestBody requestBody, CreateUserEmailAliasHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/users/", UtilsManager.convertToString(userId), "/email_aliases"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), EmailAlias.class);
    }

    public void deleteUserEmailAliasById(String userId, String emailAliasId) {
        this.deleteUserEmailAliasById(userId, emailAliasId, new DeleteUserEmailAliasByIdHeaders());
    }

    public void deleteUserEmailAliasById(String userId, String emailAliasId, DeleteUserEmailAliasByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/users/", UtilsManager.convertToString(userId), "/email_aliases/", UtilsManager.convertToString(emailAliasId)), "DELETE").headers(headersMap).responseFormat(ResponseFormat.NO_CONTENT).auth(this.auth).networkSession(this.networkSession).build());
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public EmailAliasesManager build() {
            return new EmailAliasesManager(this);
        }
    }
}

