/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.internal.utils;

import com.box.sdkgen.internal.utils.UtilsManager;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.time.OffsetDateTime;

public class DateTimeUtils {

    public static class DateTimeDeserializer
    extends JsonDeserializer<OffsetDateTime> {
        public OffsetDateTime deserialize(JsonParser p, DeserializationContext ctx) throws IOException {
            String dateString = p.getValueAsString();
            OffsetDateTime d = UtilsManager.dateTimeFromString(dateString);
            if (d == null) {
                throw new IOException("Invalid date time format: " + dateString);
            }
            return d;
        }
    }

    public static class DateTimeSerializer
    extends JsonSerializer<OffsetDateTime> {
        public void serialize(OffsetDateTime value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            String formattedDate = UtilsManager.dateTimeToString(value);
            gen.writeString(formattedDate);
        }
    }
}

