/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.config.implementation;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.policy.ExponentialBackoff;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.RetryStrategy;
import com.azure.data.appconfiguration.ConfigurationClientBuilder;
import com.azure.identity.ManagedIdentityCredentialBuilder;
import com.azure.spring.cloud.config.AppConfigurationCredentialProvider;
import com.azure.spring.cloud.config.ConfigurationClientBuilderSetup;
import com.azure.spring.cloud.config.implementation.AppConfigurationReplicaClient;
import com.azure.spring.cloud.config.pipline.policies.BaseAppConfigurationPolicy;
import com.azure.spring.cloud.config.properties.ConfigStore;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AppConfigurationReplicaClientsBuilder
implements EnvironmentAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppConfigurationReplicaClientsBuilder.class);
    public static final String NON_EMPTY_MSG = "%s property should not be null or empty in the connection string of Azure Config Service.";
    private static final Duration DEFAULT_MIN_RETRY_POLICY = Duration.ofMillis(800L);
    private static final Duration DEFAULT_MAX_RETRY_POLICY = Duration.ofSeconds(8L);
    private static final String CONN_STRING_REGEXP = "Endpoint=([^;]+);Id=([^;]+);Secret=([^;]+)";
    public static final String ENDPOINT_ERR_MSG = String.format("Connection string does not follow format %s.", "Endpoint=([^;]+);Id=([^;]+);Secret=([^;]+)");
    private static final Pattern CONN_STRING_PATTERN = Pattern.compile("Endpoint=([^;]+);Id=([^;]+);Secret=([^;]+)");
    private AppConfigurationCredentialProvider tokenCredentialProvider;
    private ConfigurationClientBuilderSetup clientProvider;
    private boolean isDev = false;
    private boolean isKeyVaultConfigured = false;
    private String clientId = "";
    private final int maxRetries;

    public AppConfigurationReplicaClientsBuilder(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public void setTokenCredentialProvider(AppConfigurationCredentialProvider tokenCredentialProvider) {
        this.tokenCredentialProvider = tokenCredentialProvider;
    }

    public void setClientProvider(ConfigurationClientBuilderSetup clientProvider) {
        this.clientProvider = clientProvider;
    }

    public void setKeyVaultConfigured(boolean isKeyVaultConfigured) {
        this.isKeyVaultConfigured = isKeyVaultConfigured;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public static String getEndpointFromConnectionString(String connectionString) {
        Assert.hasText((String)connectionString, (String)"Connection string cannot be empty.");
        Matcher matcher = CONN_STRING_PATTERN.matcher(connectionString);
        if (!matcher.find()) {
            throw new IllegalStateException(ENDPOINT_ERR_MSG);
        }
        String endpoint = matcher.group(1);
        Assert.hasText((String)endpoint, (String)String.format(NON_EMPTY_MSG, "Endpoint"));
        return endpoint;
    }

    List<AppConfigurationReplicaClient> buildClients(ConfigStore configStore) {
        boolean connectionStringIsPresent;
        int hasMultiConnectionString;
        ArrayList<AppConfigurationReplicaClient> clients = new ArrayList<AppConfigurationReplicaClient>();
        int hasSingleConnectionString = StringUtils.hasText((String)configStore.getConnectionString()) ? 1 : 0;
        int hasMultiEndpoints = configStore.getEndpoints().size() > 0 ? 1 : 0;
        int n = hasMultiConnectionString = configStore.getConnectionStrings().size() > 0 ? 1 : 0;
        if (hasSingleConnectionString + hasMultiEndpoints + hasMultiConnectionString > 1) {
            throw new IllegalArgumentException("More than 1 Connection method was set for connecting to App Configuration.");
        }
        TokenCredential tokenCredential = null;
        if (this.tokenCredentialProvider != null) {
            tokenCredential = this.tokenCredentialProvider.getAppConfigCredential(configStore.getEndpoint());
        }
        boolean clientIdIsPresent = StringUtils.hasText((String)this.clientId);
        boolean tokenCredentialIsPresent = tokenCredential != null;
        boolean bl = connectionStringIsPresent = configStore.getConnectionString() != null;
        if ((tokenCredentialIsPresent || clientIdIsPresent) && connectionStringIsPresent) {
            throw new IllegalArgumentException("More than 1 Connection method was set for connecting to App Configuration.");
        }
        if (tokenCredential != null && clientIdIsPresent) {
            throw new IllegalArgumentException("More than 1 Connection method was set for connecting to App Configuration.");
        }
        ConfigurationClientBuilder builder = this.getBuilder();
        if (configStore.getConnectionString() != null) {
            clients.add(this.buildClientConnectionString(configStore.getConnectionString(), builder, 0));
        } else if (configStore.getConnectionStrings().size() > 0) {
            for (String connectionString : configStore.getConnectionStrings()) {
                clients.add(this.buildClientConnectionString(connectionString, builder, configStore.getConnectionStrings().size() - 1));
            }
        } else if (configStore.getEndpoints().size() > 0) {
            for (String endpoint : configStore.getEndpoints()) {
                clients.add(this.buildClientEndpoint(tokenCredential, endpoint, builder, clientIdIsPresent, configStore.getEndpoints().size() - 1));
            }
        } else if (configStore.getEndpoint() != null) {
            clients.add(this.buildClientEndpoint(tokenCredential, configStore.getEndpoint(), builder, clientIdIsPresent, 0));
        }
        return clients;
    }

    ConfigurationClientBuilder getBuilder() {
        return new ConfigurationClientBuilder();
    }

    private AppConfigurationReplicaClient buildClientEndpoint(TokenCredential tokenCredential, String endpoint, ConfigurationClientBuilder builder, boolean clientIdIsPresent, Integer replicaCount) throws IllegalArgumentException {
        if (tokenCredential != null) {
            LOGGER.debug("Connecting to " + endpoint + " using AppConfigurationCredentialProvider.");
            builder.credential(tokenCredential);
        } else if (clientIdIsPresent) {
            LOGGER.debug("Connecting to " + endpoint + " using Client ID from configuration file.");
            ManagedIdentityCredentialBuilder micBuilder = new ManagedIdentityCredentialBuilder().clientId(this.clientId);
            builder.credential((TokenCredential)micBuilder.build());
        } else {
            LOGGER.debug("Connecting to " + endpoint + " using Azure System Assigned Identity or Azure User Assigned Identity.");
            ManagedIdentityCredentialBuilder micBuilder = new ManagedIdentityCredentialBuilder();
            builder.credential((TokenCredential)micBuilder.build());
        }
        builder.endpoint(endpoint);
        return this.modifyAndBuildClient(builder, endpoint, replicaCount);
    }

    private AppConfigurationReplicaClient buildClientConnectionString(String connectionString, ConfigurationClientBuilder builder, Integer replicaCount) throws IllegalArgumentException {
        String endpoint = AppConfigurationReplicaClientsBuilder.getEndpointFromConnectionString(connectionString);
        LOGGER.debug("Connecting to " + endpoint + " using Connecting String.");
        builder.connectionString(connectionString);
        return this.modifyAndBuildClient(builder, endpoint, replicaCount);
    }

    private AppConfigurationReplicaClient modifyAndBuildClient(ConfigurationClientBuilder builder, String endpoint, Integer replicaCount) {
        ExponentialBackoff retryPolicy = new ExponentialBackoff(this.maxRetries, DEFAULT_MIN_RETRY_POLICY, DEFAULT_MAX_RETRY_POLICY);
        builder.addPolicy((HttpPipelinePolicy)new BaseAppConfigurationPolicy(this.isDev, this.isKeyVaultConfigured, replicaCount)).retryPolicy((HttpPipelinePolicy)new RetryPolicy((RetryStrategy)retryPolicy));
        if (this.clientProvider != null) {
            this.clientProvider.setup(builder, endpoint);
        }
        return new AppConfigurationReplicaClient(endpoint, builder.buildClient());
    }

    public void setEnvironment(Environment environment) {
        for (String profile : environment.getActiveProfiles()) {
            if (!"dev".equalsIgnoreCase(profile)) continue;
            this.isDev = true;
            break;
        }
    }
}

