/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.config.implementation;

import com.azure.data.appconfiguration.ConfigurationClient;
import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.FeatureFlagConfigurationSetting;
import com.azure.data.appconfiguration.models.FeatureFlagFilter;
import com.azure.data.appconfiguration.models.SecretReferenceConfigurationSetting;
import com.azure.data.appconfiguration.models.SettingSelector;
import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import com.azure.spring.cloud.config.KeyVaultCredentialProvider;
import com.azure.spring.cloud.config.KeyVaultSecretProvider;
import com.azure.spring.cloud.config.SecretClientBuilderSetup;
import com.azure.spring.cloud.config.feature.management.entity.Feature;
import com.azure.spring.cloud.config.feature.management.entity.FeatureSet;
import com.azure.spring.cloud.config.implementation.AppConfigurationReplicaClient;
import com.azure.spring.cloud.config.implementation.AppConfigurationStatusException;
import com.azure.spring.cloud.config.implementation.JsonConfigurationParser;
import com.azure.spring.cloud.config.properties.AppConfigurationProperties;
import com.azure.spring.cloud.config.properties.AppConfigurationProviderProperties;
import com.azure.spring.cloud.config.properties.AppConfigurationStoreSelects;
import com.azure.spring.cloud.config.properties.ConfigStore;
import com.azure.spring.cloud.config.properties.FeatureFlagStore;
import com.azure.spring.cloud.config.stores.KeyVaultClient;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public final class AppConfigurationPropertySource
extends EnumerablePropertySource<ConfigurationClient> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppConfigurationPropertySource.class);
    private static final String USERS = "users";
    private static final String USERS_CAPS = "Users";
    private static final String AUDIENCE = "Audience";
    private static final String GROUPS = "groups";
    private static final String GROUPS_CAPS = "Groups";
    private static final String TARGETING_FILTER = "targetingFilter";
    private static final String DEFAULT_ROLLOUT_PERCENTAGE = "defaultRolloutPercentage";
    private static final String DEFAULT_ROLLOUT_PERCENTAGE_CAPS = "DefaultRolloutPercentage";
    private static final ObjectMapper CASE_INSENSITIVE_MAPPER = ((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true)).build();
    private static final ObjectMapper FEATURE_MAPPER = ((JsonMapper.Builder)JsonMapper.builder().propertyNamingStrategy(PropertyNamingStrategies.KEBAB_CASE)).build();
    private final AppConfigurationStoreSelects selectedKeys;
    private final List<String> profiles;
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();
    private final AppConfigurationProperties appConfigurationProperties;
    private final Map<String, KeyVaultClient> keyVaultClients;
    private final AppConfigurationReplicaClient replicaClient;
    private final KeyVaultCredentialProvider keyVaultCredentialProvider;
    private final SecretClientBuilderSetup keyVaultClientProvider;
    private final KeyVaultSecretProvider keyVaultSecretProvider;
    private final AppConfigurationProviderProperties appProperties;
    private final FeatureFlagStore featureStore;

    AppConfigurationPropertySource(ConfigStore configStore, AppConfigurationStoreSelects selectedKeys, List<String> profiles, AppConfigurationProperties appConfigurationProperties, AppConfigurationReplicaClient replicaClient, AppConfigurationProviderProperties appProperties, KeyVaultCredentialProvider keyVaultCredentialProvider, SecretClientBuilderSetup keyVaultClientProvider, KeyVaultSecretProvider keyVaultSecretProvider) {
        super(selectedKeys.getKeyFilter() + configStore.getEndpoint() + "/" + selectedKeys.getLabelFilterText(profiles));
        this.featureStore = configStore.getFeatureFlags();
        this.selectedKeys = selectedKeys;
        this.profiles = profiles;
        this.appConfigurationProperties = appConfigurationProperties;
        this.appProperties = appProperties;
        this.keyVaultClients = new HashMap<String, KeyVaultClient>();
        this.replicaClient = replicaClient;
        this.keyVaultCredentialProvider = keyVaultCredentialProvider;
        this.keyVaultClientProvider = keyVaultClientProvider;
        this.keyVaultSecretProvider = keyVaultSecretProvider;
    }

    private static List<Object> convertToListOrEmptyList(Map<String, Object> parameters, String key) {
        List listObjects = (List)CASE_INSENSITIVE_MAPPER.convertValue(parameters.get(key), (TypeReference)new TypeReference<List<Object>>(){});
        return listObjects == null ? Collections.emptyList() : listObjects;
    }

    public String[] getPropertyNames() {
        Set<String> keySet = this.properties.keySet();
        return keySet.toArray(new String[keySet.size()]);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    FeatureSet initProperties(FeatureSet featureSet) throws IOException, AppConfigurationStatusException {
        SettingSelector settingSelector = new SettingSelector();
        List<ConfigurationSetting> features = null;
        if (this.featureStore.getEnabled().booleanValue()) {
            settingSelector.setKeyFilter(this.featureStore.getKeyFilter()).setLabelFilter(this.featureStore.getLabelFilter());
            features = this.replicaClient.listConfigurationSettings(settingSelector);
        }
        List<String> labels = Arrays.asList(this.selectedKeys.getLabelFilter(this.profiles));
        Collections.reverse(labels);
        for (String label : labels) {
            settingSelector = new SettingSelector().setKeyFilter(this.selectedKeys.getKeyFilter() + "*").setLabelFilter(label);
            List<ConfigurationSetting> settings = this.replicaClient.listConfigurationSettings(settingSelector);
            for (ConfigurationSetting setting : settings) {
                String key = setting.getKey().trim().substring(this.selectedKeys.getKeyFilter().length()).replace('/', '.');
                if (setting instanceof SecretReferenceConfigurationSetting) {
                    String entry = this.getKeyVaultEntry((SecretReferenceConfigurationSetting)setting);
                    if (entry == null) continue;
                    this.properties.put(key, entry);
                    continue;
                }
                if (StringUtils.hasText((String)setting.getContentType()) && JsonConfigurationParser.isJsonContentType(setting.getContentType())) {
                    Map<String, Object> jsonSettings = JsonConfigurationParser.parseJsonSetting(setting);
                    for (Map.Entry<String, Object> jsonSetting : jsonSettings.entrySet()) {
                        key = jsonSetting.getKey().trim().substring(this.selectedKeys.getKeyFilter().length());
                        this.properties.put(key, jsonSetting.getValue());
                    }
                    continue;
                }
                this.properties.put(key, setting.getValue());
            }
        }
        return this.addToFeatureSet(featureSet, features);
    }

    private String getKeyVaultEntry(SecretReferenceConfigurationSetting secretReference) {
        String secretValue = null;
        try {
            KeyVaultSecret secret;
            URI uri = null;
            try {
                uri = new URI(secretReference.getSecretId());
            }
            catch (URISyntaxException e) {
                LOGGER.error("Error Processing Key Vault Entry URI.");
                ReflectionUtils.rethrowRuntimeException((Throwable)e);
            }
            if (!this.keyVaultClients.containsKey(uri.getHost())) {
                KeyVaultClient client = new KeyVaultClient(this.appConfigurationProperties, uri, this.keyVaultCredentialProvider, this.keyVaultClientProvider, this.keyVaultSecretProvider);
                this.keyVaultClients.put(uri.getHost(), client);
            }
            if ((secret = this.keyVaultClients.get(uri.getHost()).getSecret(uri, this.appProperties.getMaxRetryTime())) == null) {
                throw new IOException("No Key Vault Secret found for Reference.");
            }
            secretValue = secret.getValue();
        }
        catch (IOException | RuntimeException e) {
            LOGGER.error("Error Retrieving Key Vault Entry");
            ReflectionUtils.rethrowRuntimeException((Throwable)e);
        }
        return secretValue;
    }

    void initFeatures(FeatureSet featureSet) {
        this.properties.put("feature-management.featureManagement", FEATURE_MAPPER.convertValue(featureSet.getFeatureManagement(), LinkedHashMap.class));
    }

    private FeatureSet addToFeatureSet(FeatureSet featureSet, List<ConfigurationSetting> features) throws IOException {
        if (features == null) {
            return featureSet;
        }
        for (ConfigurationSetting setting : features) {
            if (!(setting instanceof FeatureFlagConfigurationSetting)) continue;
            Object feature = this.createFeature((FeatureFlagConfigurationSetting)setting);
            featureSet.addFeature(setting.getKey().trim().substring(".appconfig.featureflag/".length()), feature);
        }
        return featureSet;
    }

    private Object createFeature(FeatureFlagConfigurationSetting item) {
        String key = this.getFeatureSimpleName((ConfigurationSetting)item);
        Feature feature = new Feature(key, item);
        Map<Integer, FeatureFlagFilter> featureEnabledFor = feature.getEnabledFor();
        if (featureEnabledFor.size() == 0 && item.isEnabled()) {
            return true;
        }
        if (!item.isEnabled()) {
            return false;
        }
        for (int filter = 0; filter < feature.getEnabledFor().size(); ++filter) {
            FeatureFlagFilter featureFilterEvaluationContext = featureEnabledFor.get(filter);
            Map parameters = featureFilterEvaluationContext.getParameters();
            if (parameters == null || !TARGETING_FILTER.equals(featureEnabledFor.get(filter).getName())) continue;
            Object audienceObject = parameters.get(AUDIENCE);
            if (audienceObject != null) {
                parameters = (Map)audienceObject;
            }
            List<Object> users = AppConfigurationPropertySource.convertToListOrEmptyList(parameters, USERS_CAPS);
            List<Object> groupRollouts = AppConfigurationPropertySource.convertToListOrEmptyList(parameters, GROUPS_CAPS);
            this.switchKeyValues(parameters, USERS_CAPS, USERS, this.mapValuesByIndex(users));
            this.switchKeyValues(parameters, GROUPS_CAPS, GROUPS, this.mapValuesByIndex(groupRollouts));
            this.switchKeyValues(parameters, DEFAULT_ROLLOUT_PERCENTAGE_CAPS, DEFAULT_ROLLOUT_PERCENTAGE, parameters.get(DEFAULT_ROLLOUT_PERCENTAGE_CAPS));
            featureFilterEvaluationContext.setParameters(parameters);
            featureEnabledFor.put(filter, featureFilterEvaluationContext);
            feature.setEnabledFor(featureEnabledFor);
        }
        return feature;
    }

    private String getFeatureSimpleName(ConfigurationSetting setting) {
        return setting.getKey().trim().substring(".appconfig.featureflag/".length());
    }

    private Map<String, Object> mapValuesByIndex(List<Object> users) {
        return IntStream.range(0, users.size()).boxed().collect(Collectors.toMap(String::valueOf, users::get));
    }

    private void switchKeyValues(Map<String, Object> parameters, String oldKey, String newKey, Object value) {
        parameters.put(newKey, value);
        parameters.remove(oldKey);
    }
}

