/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.config;

import com.azure.spring.cloud.config.AppConfigurationCredentialProvider;
import com.azure.spring.cloud.config.ConfigurationClientBuilderSetup;
import com.azure.spring.cloud.config.KeyVaultCredentialProvider;
import com.azure.spring.cloud.config.KeyVaultSecretProvider;
import com.azure.spring.cloud.config.SecretClientBuilderSetup;
import com.azure.spring.cloud.config.implementation.AppConfigurationPropertySourceLocator;
import com.azure.spring.cloud.config.implementation.AppConfigurationReplicaClientFactory;
import com.azure.spring.cloud.config.implementation.AppConfigurationReplicaClientsBuilder;
import com.azure.spring.cloud.config.properties.AppConfigurationProperties;
import com.azure.spring.cloud.config.properties.AppConfigurationProviderProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={AppConfigurationProperties.class, AppConfigurationProviderProperties.class})
@ConditionalOnClass(value={AppConfigurationPropertySourceLocator.class})
@ConditionalOnProperty(prefix="spring.cloud.azure.appconfiguration", name={"enabled"}, matchIfMissing=true)
public class AppConfigurationBootstrapConfiguration {
    @Autowired
    private transient ApplicationContext context;

    @Bean
    AppConfigurationPropertySourceLocator sourceLocator(AppConfigurationProperties properties, AppConfigurationProviderProperties appProperties, AppConfigurationReplicaClientFactory clientFactory) throws IllegalArgumentException {
        KeyVaultCredentialProvider keyVaultCredentialProvider = (KeyVaultCredentialProvider)this.context.getBeanProvider(KeyVaultCredentialProvider.class).getIfAvailable();
        SecretClientBuilderSetup keyVaultClientProvider = (SecretClientBuilderSetup)this.context.getBeanProvider(SecretClientBuilderSetup.class).getIfAvailable();
        KeyVaultSecretProvider keyVaultSecretProvider = (KeyVaultSecretProvider)this.context.getBeanProvider(KeyVaultSecretProvider.class).getIfAvailable();
        if (keyVaultClientProvider != null && keyVaultSecretProvider != null) {
            throw new IllegalArgumentException("KeyVaultClientProvider and KeyVaultSecretProvider both can't have Beans supplied.");
        }
        return new AppConfigurationPropertySourceLocator(properties, appProperties, clientFactory, keyVaultCredentialProvider, keyVaultClientProvider, keyVaultSecretProvider);
    }

    @Bean
    @ConditionalOnMissingBean
    AppConfigurationReplicaClientFactory replicaClientFactory(AppConfigurationReplicaClientsBuilder clientBuilder, AppConfigurationProperties properties) {
        return new AppConfigurationReplicaClientFactory(clientBuilder, properties);
    }

    @Bean
    @ConditionalOnMissingBean
    AppConfigurationReplicaClientsBuilder replicaClientBuilder(AppConfigurationProperties properties, AppConfigurationProviderProperties appProperties) {
        AppConfigurationReplicaClientsBuilder clientBuilder = new AppConfigurationReplicaClientsBuilder(appProperties.getMaxRetries());
        clientBuilder.setTokenCredentialProvider((AppConfigurationCredentialProvider)this.context.getBeanProvider(AppConfigurationCredentialProvider.class).getIfAvailable());
        clientBuilder.setClientProvider((ConfigurationClientBuilderSetup)this.context.getBeanProvider(ConfigurationClientBuilderSetup.class).getIfAvailable());
        KeyVaultCredentialProvider keyVaultCredentialProvider = (KeyVaultCredentialProvider)this.context.getBeanProvider(KeyVaultCredentialProvider.class).getIfAvailable();
        SecretClientBuilderSetup keyVaultClientProvider = (SecretClientBuilderSetup)this.context.getBeanProvider(SecretClientBuilderSetup.class).getIfAvailable();
        if (keyVaultCredentialProvider != null || keyVaultClientProvider != null) {
            clientBuilder.setKeyVaultConfigured(true);
        }
        if (properties.getManagedIdentity() != null) {
            clientBuilder.setClientId(properties.getManagedIdentity().getClientId());
        }
        return clientBuilder;
    }
}

