/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.config;

import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.spring.cloud.config.BackoffTimeCalculator;
import com.azure.spring.cloud.config.State;
import com.azure.spring.cloud.config.properties.AppConfigurationProviderProperties;
import java.security.SecureRandom;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class StateHolder {
    private static final int MAX_JITTER = 15;
    private static final String FEATURE_ENDPOINT = "_feature";
    private static final Map<String, State> STATE = new ConcurrentHashMap<String, State>();
    private static final Map<String, Boolean> LOAD_STATE = new ConcurrentHashMap<String, Boolean>();
    private static Integer clientRefreshAttempts = 1;
    private static Instant nextForcedRefresh;

    private StateHolder() {
        throw new IllegalStateException("Should not be callable.");
    }

    static State getState(String endpoint) {
        return STATE.get(endpoint);
    }

    static State getStateFeatureFlag(String endpoint) {
        return STATE.get(endpoint + FEATURE_ENDPOINT);
    }

    static void setState(String endpoint, List<ConfigurationSetting> watchKeys, Duration duration) {
        STATE.put(endpoint, new State(watchKeys, Math.toIntExact(duration.getSeconds()), endpoint));
    }

    static void setStateFeatureFlag(String endpoint, List<ConfigurationSetting> watchKeys, Duration duration) {
        StateHolder.setState(endpoint + FEATURE_ENDPOINT, watchKeys, duration);
    }

    static void setState(State state, Duration duration) {
        STATE.put(state.getKey(), new State(state.getWatchKeys(), Math.toIntExact(duration.getSeconds()), state.getKey()));
    }

    static void expireState(String endpoint) {
        long timeLeft;
        State oldState = STATE.get(endpoint);
        SecureRandom random = new SecureRandom();
        long wait = (long)(random.nextDouble() * 15.0);
        if (wait < (timeLeft = (long)((int)((oldState.getNextRefreshCheck().toEpochMilli() - Instant.now().toEpochMilli()) / 1000L)))) {
            STATE.put(endpoint, new State(oldState.getWatchKeys(), (int)wait, oldState.getKey()));
        }
    }

    static boolean getLoadState(String name) {
        return LOAD_STATE.getOrDefault(name, false);
    }

    static boolean getLoadStateFeatureFlag(String name) {
        return StateHolder.getLoadState(name + FEATURE_ENDPOINT);
    }

    static void setLoadState(String name, Boolean loaded) {
        LOAD_STATE.put(name, loaded);
    }

    static void setLoadStateFeatureFlag(String name, Boolean loaded) {
        StateHolder.setLoadState(name + FEATURE_ENDPOINT, loaded);
    }

    public static Instant getNextForcedRefresh() {
        return nextForcedRefresh;
    }

    public static void setNextForcedRefresh(Duration refreshPeriod) {
        nextForcedRefresh = Instant.now().plusSeconds(refreshPeriod.getSeconds());
    }

    static void updateNextRefreshTime(Duration refreshInterval, AppConfigurationProviderProperties properties) {
        if (refreshInterval != null) {
            Instant newForcedRefresh = StateHolder.getNextRefreshCheck(nextForcedRefresh, clientRefreshAttempts, refreshInterval.getSeconds(), properties);
            if (newForcedRefresh.compareTo(nextForcedRefresh) != 0) {
                clientRefreshAttempts = clientRefreshAttempts + 1;
            }
            nextForcedRefresh = newForcedRefresh;
        }
        for (Map.Entry<String, State> entry : STATE.entrySet()) {
            State state = entry.getValue();
            Instant newRefresh = StateHolder.getNextRefreshCheck(state.getNextRefreshCheck(), state.getRefreshAttempt(), Long.valueOf(state.getRefreshInterval()), properties);
            if (newRefresh.compareTo(entry.getValue().getNextRefreshCheck()) != 0) {
                state.incrementRefreshAttempt();
            }
            State updatedState = new State(state, newRefresh, entry.getKey());
            STATE.put(entry.getKey(), updatedState);
        }
    }

    private static Instant getNextRefreshCheck(Instant nextRefreshCheck, Integer attempt, Long interval, AppConfigurationProviderProperties properties) {
        if (!Instant.now().isAfter(nextRefreshCheck)) {
            return nextRefreshCheck;
        }
        int durationPeriod = Math.toIntExact(interval);
        Instant now = Instant.now();
        if ((long)durationPeriod <= properties.getDefaultMinBackoff()) {
            return now.plusSeconds(interval);
        }
        return now.plusNanos(BackoffTimeCalculator.calculateBackoff(attempt, interval, properties.getDefaultMaxBackoff(), properties.getDefaultMinBackoff()));
    }

    static void clearAttempts() {
        clientRefreshAttempts = 1;
    }
}

