/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

public final class MicrosoftGraphCertificateAuthority {
    @JsonProperty(value="certificate")
    private Base64Url certificate;
    @JsonProperty(value="certificateRevocationListUrl")
    private String certificateRevocationListUrl;
    @JsonProperty(value="deltaCertificateRevocationListUrl")
    private String deltaCertificateRevocationListUrl;
    @JsonProperty(value="isRootAuthority")
    private Boolean isRootAuthority;
    @JsonProperty(value="issuer")
    private String issuer;
    @JsonProperty(value="issuerSki")
    private String issuerSki;
    @JsonIgnore
    private Map<String, Object> additionalProperties;

    public byte[] certificate() {
        if (this.certificate == null) {
            return new byte[0];
        }
        return this.certificate.decodedBytes();
    }

    public MicrosoftGraphCertificateAuthority withCertificate(byte[] certificate) {
        this.certificate = certificate == null ? null : Base64Url.encode((byte[])CoreUtils.clone((byte[])certificate));
        return this;
    }

    public String certificateRevocationListUrl() {
        return this.certificateRevocationListUrl;
    }

    public MicrosoftGraphCertificateAuthority withCertificateRevocationListUrl(String certificateRevocationListUrl) {
        this.certificateRevocationListUrl = certificateRevocationListUrl;
        return this;
    }

    public String deltaCertificateRevocationListUrl() {
        return this.deltaCertificateRevocationListUrl;
    }

    public MicrosoftGraphCertificateAuthority withDeltaCertificateRevocationListUrl(String deltaCertificateRevocationListUrl) {
        this.deltaCertificateRevocationListUrl = deltaCertificateRevocationListUrl;
        return this;
    }

    public Boolean isRootAuthority() {
        return this.isRootAuthority;
    }

    public MicrosoftGraphCertificateAuthority withIsRootAuthority(Boolean isRootAuthority) {
        this.isRootAuthority = isRootAuthority;
        return this;
    }

    public String issuer() {
        return this.issuer;
    }

    public MicrosoftGraphCertificateAuthority withIssuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    public String issuerSki() {
        return this.issuerSki;
    }

    public MicrosoftGraphCertificateAuthority withIssuerSki(String issuerSki) {
        this.issuerSki = issuerSki;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public MicrosoftGraphCertificateAuthority withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
    }

    public void validate() {
    }
}

