/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class WorkbookProperties {
    @JsonProperty(value="displayName", required=true)
    private String displayName;
    @JsonProperty(value="serializedData", required=true)
    private String serializedData;
    @JsonProperty(value="version")
    private String version;
    @JsonProperty(value="timeModified", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime timeModified;
    @JsonProperty(value="category", required=true)
    private String category;
    @JsonProperty(value="tags")
    private List<String> tags;
    @JsonProperty(value="userId", access=JsonProperty.Access.WRITE_ONLY)
    private String userId;
    @JsonProperty(value="sourceId")
    private String sourceId;
    @JsonProperty(value="storageUri")
    private String storageUri;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="revision", access=JsonProperty.Access.WRITE_ONLY)
    private String revision;
    private static final ClientLogger LOGGER = new ClientLogger(WorkbookProperties.class);

    public String displayName() {
        return this.displayName;
    }

    public WorkbookProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String serializedData() {
        return this.serializedData;
    }

    public WorkbookProperties withSerializedData(String serializedData) {
        this.serializedData = serializedData;
        return this;
    }

    public String version() {
        return this.version;
    }

    public WorkbookProperties withVersion(String version) {
        this.version = version;
        return this;
    }

    public OffsetDateTime timeModified() {
        return this.timeModified;
    }

    public String category() {
        return this.category;
    }

    public WorkbookProperties withCategory(String category) {
        this.category = category;
        return this;
    }

    public List<String> tags() {
        return this.tags;
    }

    public WorkbookProperties withTags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public String userId() {
        return this.userId;
    }

    public String sourceId() {
        return this.sourceId;
    }

    public WorkbookProperties withSourceId(String sourceId) {
        this.sourceId = sourceId;
        return this;
    }

    public String storageUri() {
        return this.storageUri;
    }

    public WorkbookProperties withStorageUri(String storageUri) {
        this.storageUri = storageUri;
        return this;
    }

    public String description() {
        return this.description;
    }

    public WorkbookProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public String revision() {
        return this.revision;
    }

    public void validate() {
        if (this.displayName() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property displayName in model WorkbookProperties"));
        }
        if (this.serializedData() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property serializedData in model WorkbookProperties"));
        }
        if (this.category() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property category in model WorkbookProperties"));
        }
    }
}

