/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.applicationinsights.models.ApplicationType;
import com.azure.resourcemanager.applicationinsights.models.FlowType;
import com.azure.resourcemanager.applicationinsights.models.IngestionMode;
import com.azure.resourcemanager.applicationinsights.models.PrivateLinkScopedResource;
import com.azure.resourcemanager.applicationinsights.models.PublicNetworkAccessType;
import com.azure.resourcemanager.applicationinsights.models.RequestSource;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class ApplicationInsightsComponentProperties {
    @JsonProperty(value="ApplicationId", access=JsonProperty.Access.WRITE_ONLY)
    private String applicationId;
    @JsonProperty(value="AppId", access=JsonProperty.Access.WRITE_ONLY)
    private String appId;
    @JsonProperty(value="Name", access=JsonProperty.Access.WRITE_ONLY)
    private String name;
    @JsonProperty(value="Application_Type", required=true)
    private ApplicationType applicationType;
    @JsonProperty(value="Flow_Type")
    private FlowType flowType;
    @JsonProperty(value="Request_Source")
    private RequestSource requestSource;
    @JsonProperty(value="InstrumentationKey", access=JsonProperty.Access.WRITE_ONLY)
    private String instrumentationKey;
    @JsonProperty(value="CreationDate", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime creationDate;
    @JsonProperty(value="TenantId", access=JsonProperty.Access.WRITE_ONLY)
    private String tenantId;
    @JsonProperty(value="HockeyAppId")
    private String hockeyAppId;
    @JsonProperty(value="HockeyAppToken", access=JsonProperty.Access.WRITE_ONLY)
    private String hockeyAppToken;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="SamplingPercentage")
    private Double samplingPercentage;
    @JsonProperty(value="ConnectionString", access=JsonProperty.Access.WRITE_ONLY)
    private String connectionString;
    @JsonProperty(value="RetentionInDays")
    private Integer retentionInDays;
    @JsonProperty(value="DisableIpMasking")
    private Boolean disableIpMasking;
    @JsonProperty(value="ImmediatePurgeDataOn30Days")
    private Boolean immediatePurgeDataOn30Days;
    @JsonProperty(value="WorkspaceResourceId")
    private String workspaceResourceId;
    @JsonProperty(value="LaMigrationDate", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime laMigrationDate;
    @JsonProperty(value="PrivateLinkScopedResources", access=JsonProperty.Access.WRITE_ONLY)
    private List<PrivateLinkScopedResource> privateLinkScopedResources;
    @JsonProperty(value="publicNetworkAccessForIngestion")
    private PublicNetworkAccessType publicNetworkAccessForIngestion;
    @JsonProperty(value="publicNetworkAccessForQuery")
    private PublicNetworkAccessType publicNetworkAccessForQuery;
    @JsonProperty(value="IngestionMode")
    private IngestionMode ingestionMode;
    @JsonProperty(value="DisableLocalAuth")
    private Boolean disableLocalAuth;
    @JsonProperty(value="ForceCustomerStorageForProfiler")
    private Boolean forceCustomerStorageForProfiler;
    private static final ClientLogger LOGGER = new ClientLogger(ApplicationInsightsComponentProperties.class);

    public String applicationId() {
        return this.applicationId;
    }

    public String appId() {
        return this.appId;
    }

    public String name() {
        return this.name;
    }

    public ApplicationType applicationType() {
        return this.applicationType;
    }

    public ApplicationInsightsComponentProperties withApplicationType(ApplicationType applicationType) {
        this.applicationType = applicationType;
        return this;
    }

    public FlowType flowType() {
        return this.flowType;
    }

    public ApplicationInsightsComponentProperties withFlowType(FlowType flowType) {
        this.flowType = flowType;
        return this;
    }

    public RequestSource requestSource() {
        return this.requestSource;
    }

    public ApplicationInsightsComponentProperties withRequestSource(RequestSource requestSource) {
        this.requestSource = requestSource;
        return this;
    }

    public String instrumentationKey() {
        return this.instrumentationKey;
    }

    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public String hockeyAppId() {
        return this.hockeyAppId;
    }

    public ApplicationInsightsComponentProperties withHockeyAppId(String hockeyAppId) {
        this.hockeyAppId = hockeyAppId;
        return this;
    }

    public String hockeyAppToken() {
        return this.hockeyAppToken;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public Double samplingPercentage() {
        return this.samplingPercentage;
    }

    public ApplicationInsightsComponentProperties withSamplingPercentage(Double samplingPercentage) {
        this.samplingPercentage = samplingPercentage;
        return this;
    }

    public String connectionString() {
        return this.connectionString;
    }

    public Integer retentionInDays() {
        return this.retentionInDays;
    }

    public ApplicationInsightsComponentProperties withRetentionInDays(Integer retentionInDays) {
        this.retentionInDays = retentionInDays;
        return this;
    }

    public Boolean disableIpMasking() {
        return this.disableIpMasking;
    }

    public ApplicationInsightsComponentProperties withDisableIpMasking(Boolean disableIpMasking) {
        this.disableIpMasking = disableIpMasking;
        return this;
    }

    public Boolean immediatePurgeDataOn30Days() {
        return this.immediatePurgeDataOn30Days;
    }

    public ApplicationInsightsComponentProperties withImmediatePurgeDataOn30Days(Boolean immediatePurgeDataOn30Days) {
        this.immediatePurgeDataOn30Days = immediatePurgeDataOn30Days;
        return this;
    }

    public String workspaceResourceId() {
        return this.workspaceResourceId;
    }

    public ApplicationInsightsComponentProperties withWorkspaceResourceId(String workspaceResourceId) {
        this.workspaceResourceId = workspaceResourceId;
        return this;
    }

    public OffsetDateTime laMigrationDate() {
        return this.laMigrationDate;
    }

    public List<PrivateLinkScopedResource> privateLinkScopedResources() {
        return this.privateLinkScopedResources;
    }

    public PublicNetworkAccessType publicNetworkAccessForIngestion() {
        return this.publicNetworkAccessForIngestion;
    }

    public ApplicationInsightsComponentProperties withPublicNetworkAccessForIngestion(PublicNetworkAccessType publicNetworkAccessForIngestion) {
        this.publicNetworkAccessForIngestion = publicNetworkAccessForIngestion;
        return this;
    }

    public PublicNetworkAccessType publicNetworkAccessForQuery() {
        return this.publicNetworkAccessForQuery;
    }

    public ApplicationInsightsComponentProperties withPublicNetworkAccessForQuery(PublicNetworkAccessType publicNetworkAccessForQuery) {
        this.publicNetworkAccessForQuery = publicNetworkAccessForQuery;
        return this;
    }

    public IngestionMode ingestionMode() {
        return this.ingestionMode;
    }

    public ApplicationInsightsComponentProperties withIngestionMode(IngestionMode ingestionMode) {
        this.ingestionMode = ingestionMode;
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.disableLocalAuth;
    }

    public ApplicationInsightsComponentProperties withDisableLocalAuth(Boolean disableLocalAuth) {
        this.disableLocalAuth = disableLocalAuth;
        return this;
    }

    public Boolean forceCustomerStorageForProfiler() {
        return this.forceCustomerStorageForProfiler;
    }

    public ApplicationInsightsComponentProperties withForceCustomerStorageForProfiler(Boolean forceCustomerStorageForProfiler) {
        this.forceCustomerStorageForProfiler = forceCustomerStorageForProfiler;
        return this;
    }

    public void validate() {
        if (this.applicationType() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property applicationType in model ApplicationInsightsComponentProperties"));
        }
        if (this.privateLinkScopedResources() != null) {
            this.privateLinkScopedResources().forEach(e -> e.validate());
        }
    }
}

