/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.models;

import com.azure.storage.blob.implementation.models.BlobTags;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class FilterBlobItem
implements XmlSerializable<FilterBlobItem> {
    private String name;
    private String containerName;
    private BlobTags tags;
    private String versionId;
    private Boolean isCurrentVersion;

    public String getName() {
        return this.name;
    }

    public FilterBlobItem setName(String name) {
        this.name = name;
        return this;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public FilterBlobItem setContainerName(String containerName) {
        this.containerName = containerName;
        return this;
    }

    public BlobTags getTags() {
        return this.tags;
    }

    public FilterBlobItem setTags(BlobTags tags) {
        this.tags = tags;
        return this;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public FilterBlobItem setVersionId(String versionId) {
        this.versionId = versionId;
        return this;
    }

    public Boolean isCurrentVersion() {
        return this.isCurrentVersion;
    }

    public FilterBlobItem setIsCurrentVersion(Boolean isCurrentVersion) {
        this.isCurrentVersion = isCurrentVersion;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "Blob" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Name", this.name);
        xmlWriter.writeStringElement("ContainerName", this.containerName);
        xmlWriter.writeXml((XmlSerializable)this.tags, "Tags");
        xmlWriter.writeStringElement("VersionId", this.versionId);
        xmlWriter.writeBooleanElement("IsCurrentVersion", this.isCurrentVersion);
        return xmlWriter.writeEndElement();
    }

    public static FilterBlobItem fromXml(XmlReader xmlReader) throws XMLStreamException {
        return FilterBlobItem.fromXml(xmlReader, null);
    }

    public static FilterBlobItem fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = rootElementName == null || rootElementName.isEmpty() ? "Blob" : rootElementName;
        return (FilterBlobItem)xmlReader.readObject(finalRootElementName, reader -> {
            FilterBlobItem deserializedFilterBlobItem = new FilterBlobItem();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Name".equals(elementName.getLocalPart())) {
                    deserializedFilterBlobItem.name = reader.getStringElement();
                    continue;
                }
                if ("ContainerName".equals(elementName.getLocalPart())) {
                    deserializedFilterBlobItem.containerName = reader.getStringElement();
                    continue;
                }
                if ("Tags".equals(elementName.getLocalPart())) {
                    deserializedFilterBlobItem.tags = BlobTags.fromXml(reader, "Tags");
                    continue;
                }
                if ("VersionId".equals(elementName.getLocalPart())) {
                    deserializedFilterBlobItem.versionId = reader.getStringElement();
                    continue;
                }
                if ("IsCurrentVersion".equals(elementName.getLocalPart())) {
                    deserializedFilterBlobItem.isCurrentVersion = (Boolean)reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                reader.skipElement();
            }
            return deserializedFilterBlobItem;
        });
    }
}

