/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobAsyncClient;
import com.azure.storage.blob.BlobClientBuilder;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlockBlobItem;
import com.azure.storage.blob.models.BlockList;
import com.azure.storage.blob.models.BlockListType;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.models.CustomerProvidedKey;
import com.azure.storage.blob.models.ParallelTransferOptions;
import com.azure.storage.blob.options.BlobUploadFromUrlOptions;
import com.azure.storage.blob.options.BlockBlobCommitBlockListOptions;
import com.azure.storage.blob.options.BlockBlobListBlocksOptions;
import com.azure.storage.blob.options.BlockBlobOutputStreamOptions;
import com.azure.storage.blob.options.BlockBlobSimpleUploadOptions;
import com.azure.storage.blob.options.BlockBlobStageBlockFromUrlOptions;
import com.azure.storage.blob.options.BlockBlobStageBlockOptions;
import com.azure.storage.blob.specialized.BlobClientBase;
import com.azure.storage.blob.specialized.BlobOutputStream;
import com.azure.storage.blob.specialized.BlockBlobAsyncClient;
import com.azure.storage.blob.specialized.SpecializedBlobClientBuilder;
import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@ServiceClient(builder=SpecializedBlobClientBuilder.class)
public final class BlockBlobClient
extends BlobClientBase {
    private static final ClientLogger LOGGER = new ClientLogger(BlockBlobClient.class);
    private final BlockBlobAsyncClient client;
    @Deprecated
    public static final int MAX_UPLOAD_BLOB_BYTES = 0x10000000;
    public static final long MAX_UPLOAD_BLOB_BYTES_LONG = 5242880000L;
    @Deprecated
    public static final int MAX_STAGE_BLOCK_BYTES = 0x6400000;
    public static final long MAX_STAGE_BLOCK_BYTES_LONG = 0xFA000000L;
    public static final int MAX_BLOCKS = 50000;

    BlockBlobClient(BlockBlobAsyncClient client) {
        super(client);
        this.client = client;
    }

    @Override
    public BlockBlobClient getEncryptionScopeClient(String encryptionScope) {
        return new BlockBlobClient(this.client.getEncryptionScopeAsyncClient(encryptionScope));
    }

    @Override
    public BlockBlobClient getCustomerProvidedKeyClient(CustomerProvidedKey customerProvidedKey) {
        return new BlockBlobClient(this.client.getCustomerProvidedKeyAsyncClient(customerProvidedKey));
    }

    public BlobOutputStream getBlobOutputStream() {
        return this.getBlobOutputStream(false);
    }

    public BlobOutputStream getBlobOutputStream(boolean overwrite) {
        BlobRequestConditions requestConditions = null;
        if (!overwrite) {
            if (this.exists().booleanValue()) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Blob already exists. Specify overwrite to true to force update the blob."));
            }
            requestConditions = new BlobRequestConditions().setIfNoneMatch("*");
        }
        return this.getBlobOutputStream(requestConditions);
    }

    public BlobOutputStream getBlobOutputStream(BlobRequestConditions requestConditions) {
        return this.getBlobOutputStream(null, null, null, null, requestConditions);
    }

    public BlobOutputStream getBlobOutputStream(ParallelTransferOptions parallelTransferOptions, BlobHttpHeaders headers, Map<String, String> metadata, AccessTier tier, BlobRequestConditions requestConditions) {
        return this.getBlobOutputStream(new BlockBlobOutputStreamOptions().setParallelTransferOptions(parallelTransferOptions).setHeaders(headers).setMetadata(metadata).setTier(tier).setRequestConditions(requestConditions));
    }

    public BlobOutputStream getBlobOutputStream(BlockBlobOutputStreamOptions options) {
        BlobAsyncClient blobClient = this.prepareBuilder().buildAsyncClient();
        return BlobOutputStream.blockBlobOutputStream(blobClient, options, null);
    }

    private BlobClientBuilder prepareBuilder() {
        BlobClientBuilder builder = new BlobClientBuilder().pipeline(this.getHttpPipeline()).endpoint(this.getBlobUrl()).snapshot(this.getSnapshotId()).serviceVersion(this.getServiceVersion());
        CpkInfo cpk = this.getCustomerProvidedKey();
        if (cpk != null) {
            builder.customerProvidedKey(new CustomerProvidedKey(cpk.getEncryptionKey()));
        }
        return builder;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlockBlobItem upload(InputStream data, long length) {
        return this.upload(data, length, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlockBlobItem upload(BinaryData data) {
        return this.upload(data, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlockBlobItem upload(InputStream data, long length, boolean overwrite) {
        BlobRequestConditions blobRequestConditions = new BlobRequestConditions();
        if (!overwrite) {
            blobRequestConditions.setIfNoneMatch("*");
        }
        return (BlockBlobItem)this.uploadWithResponse(data, length, null, null, null, null, blobRequestConditions, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlockBlobItem upload(BinaryData data, boolean overwrite) {
        BlobRequestConditions blobRequestConditions = new BlobRequestConditions();
        if (!overwrite) {
            blobRequestConditions.setIfNoneMatch("*");
        }
        return (BlockBlobItem)this.uploadWithResponse(new BlockBlobSimpleUploadOptions(data).setRequestConditions(blobRequestConditions), null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlockBlobItem> uploadWithResponse(InputStream data, long length, BlobHttpHeaders headers, Map<String, String> metadata, AccessTier tier, byte[] contentMd5, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        return this.uploadWithResponse(new BlockBlobSimpleUploadOptions(data, length).setHeaders(headers).setMetadata(metadata).setTier(tier).setContentMd5(contentMd5).setRequestConditions(requestConditions), timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlockBlobItem> uploadWithResponse(BlockBlobSimpleUploadOptions options, Duration timeout, Context context) {
        StorageImplUtils.assertNotNull((String)"options", (Object)options);
        Mono<Response<BlockBlobItem>> upload = this.client.uploadWithResponse(options, context);
        try {
            return (Response)StorageImplUtils.blockWithOptionalTimeout(upload, (Duration)timeout);
        }
        catch (UncheckedIOException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlockBlobItem uploadFromUrl(String sourceUrl) {
        return this.uploadFromUrl(sourceUrl, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlockBlobItem uploadFromUrl(String sourceUrl, boolean overwrite) {
        BlobRequestConditions blobRequestConditions = new BlobRequestConditions();
        if (!overwrite) {
            blobRequestConditions.setIfNoneMatch("*");
        }
        return (BlockBlobItem)this.uploadFromUrlWithResponse(new BlobUploadFromUrlOptions(sourceUrl).setDestinationRequestConditions(blobRequestConditions), null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlockBlobItem> uploadFromUrlWithResponse(BlobUploadFromUrlOptions options, Duration timeout, Context context) {
        StorageImplUtils.assertNotNull((String)"options", (Object)options);
        Mono<Response<BlockBlobItem>> upload = this.client.uploadFromUrlWithResponse(options, context);
        try {
            return (Response)StorageImplUtils.blockWithOptionalTimeout(upload, (Duration)timeout);
        }
        catch (UncheckedIOException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void stageBlock(String base64BlockId, InputStream data, long length) {
        this.stageBlockWithResponse(base64BlockId, data, length, null, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void stageBlock(String base64BlockId, BinaryData data) {
        this.stageBlockWithResponse(new BlockBlobStageBlockOptions(base64BlockId, data), null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> stageBlockWithResponse(String base64BlockId, InputStream data, long length, byte[] contentMd5, String leaseId, Duration timeout, Context context) {
        StorageImplUtils.assertNotNull((String)"data", (Object)data);
        Flux fbb = Utility.convertStreamToByteBuffer((InputStream)data, (long)length, (int)0x400000, (boolean)true);
        Mono<Response<Void>> response = this.client.stageBlockWithResponse(base64BlockId, (Flux<ByteBuffer>)fbb.subscribeOn(Schedulers.boundedElastic()), length, contentMd5, leaseId, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> stageBlockWithResponse(BlockBlobStageBlockOptions options, Duration timeout, Context context) {
        Objects.requireNonNull(options, "options must not be null");
        Mono<Response<Void>> response = this.client.stageBlockWithResponse(options.getBase64BlockId(), options.getData(), options.getContentMd5(), options.getLeaseId(), context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void stageBlockFromUrl(String base64BlockId, String sourceUrl, BlobRange sourceRange) {
        this.stageBlockFromUrlWithResponse(base64BlockId, sourceUrl, sourceRange, null, null, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> stageBlockFromUrlWithResponse(String base64BlockId, String sourceUrl, BlobRange sourceRange, byte[] sourceContentMd5, String leaseId, BlobRequestConditions sourceRequestConditions, Duration timeout, Context context) {
        return this.stageBlockFromUrlWithResponse(new BlockBlobStageBlockFromUrlOptions(base64BlockId, sourceUrl).setSourceRange(sourceRange).setSourceContentMd5(sourceContentMd5).setLeaseId(leaseId).setSourceRequestConditions(sourceRequestConditions), timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> stageBlockFromUrlWithResponse(BlockBlobStageBlockFromUrlOptions options, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.client.stageBlockFromUrlWithResponse(options, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlockList listBlocks(BlockListType listType) {
        return (BlockList)this.listBlocksWithResponse(listType, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlockList> listBlocksWithResponse(BlockListType listType, String leaseId, Duration timeout, Context context) {
        return this.listBlocksWithResponse(new BlockBlobListBlocksOptions(listType).setLeaseId(leaseId), timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlockList> listBlocksWithResponse(BlockBlobListBlocksOptions options, Duration timeout, Context context) {
        return (Response)StorageImplUtils.blockWithOptionalTimeout(this.client.listBlocksWithResponse(options, context), (Duration)timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlockBlobItem commitBlockList(List<String> base64BlockIds) {
        return this.commitBlockList(base64BlockIds, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlockBlobItem commitBlockList(List<String> base64BlockIds, boolean overwrite) {
        BlobRequestConditions requestConditions = null;
        if (!overwrite) {
            requestConditions = new BlobRequestConditions().setIfNoneMatch("*");
        }
        return (BlockBlobItem)this.commitBlockListWithResponse(base64BlockIds, null, null, null, requestConditions, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlockBlobItem> commitBlockListWithResponse(List<String> base64BlockIds, BlobHttpHeaders headers, Map<String, String> metadata, AccessTier tier, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        return this.commitBlockListWithResponse(new BlockBlobCommitBlockListOptions(base64BlockIds).setHeaders(headers).setMetadata(metadata).setTier(tier).setRequestConditions(requestConditions), timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlockBlobItem> commitBlockListWithResponse(BlockBlobCommitBlockListOptions options, Duration timeout, Context context) {
        Mono<Response<BlockBlobItem>> response = this.client.commitBlockListWithResponse(options, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }
}

