/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.implementation.IdentityClient;
import com.azure.identity.implementation.IdentityClientBuilder;
import com.azure.identity.implementation.IdentityClientOptions;
import com.azure.identity.implementation.IdentitySyncClient;
import com.azure.identity.implementation.models.OidcTokenResponse;
import com.azure.identity.implementation.util.IdentityUtil;
import com.azure.identity.implementation.util.LoggingUtil;
import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import java.io.IOException;
import java.net.URL;
import reactor.core.publisher.Mono;

public class AzurePipelinesCredential
implements TokenCredential {
    private static final ClientLogger LOGGER = new ClientLogger(AzurePipelinesCredential.class);
    private final IdentityClient identityClient;
    private final IdentitySyncClient identitySyncClient;

    AzurePipelinesCredential(String clientId, String tenantId, String requestUrl, String systemAccessToken, IdentityClientOptions identityClientOptions) {
        IdentityClientBuilder builder = new IdentityClientBuilder().tenantId(tenantId).clientId(clientId).identityClientOptions(identityClientOptions).clientAssertionSupplierWithHttpPipeline(httpPipeline -> {
            try {
                URL url = new URL(requestUrl);
                HttpRequest request = new HttpRequest(HttpMethod.POST, url);
                request.setHeader(HttpHeaderName.AUTHORIZATION, "Bearer " + systemAccessToken);
                request.setHeader(HttpHeaderName.CONTENT_TYPE, "application/json");
                request.setHeader(IdentityUtil.X_TFS_FED_AUTH_REDIRECT, "Suppress");
                try (HttpResponse response = httpPipeline.sendSync(request, Context.NONE);){
                    String xMsEdgeRefHeader2;
                    block17: {
                        String responseBody = response.getBodyAsBinaryData().toString();
                        if (response.getStatusCode() != 200) {
                            String xVssHeader = response.getHeaderValue(IdentityUtil.X_VSS_E2EID);
                            String xMsEdgeRefHeader2 = response.getHeaderValue(IdentityUtil.X_MSEDGE_REF);
                            String message = "Failed to get the client assertion token " + responseBody + ".";
                            if (xVssHeader != null) {
                                message = message + " x-vss-e2eid: " + xVssHeader + ".";
                            }
                            if (xMsEdgeRefHeader2 != null) {
                                message = message + " x-msedge-ref: " + xMsEdgeRefHeader2 + ".";
                            }
                            message = message + "For troubleshooting information see https://aka.ms/azsdk/java/identity/azurepipelinescredential/troubleshoot.";
                            throw LOGGER.logExceptionAsError((RuntimeException)((Object)new ClientAuthenticationException(message, response)));
                        }
                        JsonReader reader = JsonProviders.createReader((String)responseBody);
                        try {
                            xMsEdgeRefHeader2 = OidcTokenResponse.fromJson(reader).getOidcToken();
                            if (reader == null) break block17;
                        }
                        catch (Throwable t$) {
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable x2) {
                                    t$.addSuppressed(x2);
                                }
                            }
                            throw t$;
                        }
                        reader.close();
                    }
                    return xMsEdgeRefHeader2;
                }
            }
            catch (IOException e) {
                throw LOGGER.logExceptionAsError((RuntimeException)((Object)new ClientAuthenticationException("Failed to get the client assertion token", null, (Throwable)e)));
            }
        });
        this.identitySyncClient = builder.buildSyncClient();
        this.identityClient = builder.build();
    }

    public Mono<AccessToken> getToken(TokenRequestContext request) {
        return this.identityClient.authenticateWithConfidentialClientCache(request).onErrorResume(t -> Mono.empty()).switchIfEmpty(Mono.defer(() -> this.identityClient.authenticateWithConfidentialClient(request))).doOnNext(token -> LoggingUtil.logTokenSuccess(LOGGER, request)).doOnError(error -> LoggingUtil.logTokenError(LOGGER, this.identityClient.getIdentityClientOptions(), request, error));
    }

    public AccessToken getTokenSync(TokenRequestContext request) {
        AccessToken token2;
        try {
            token2 = this.identitySyncClient.authenticateWithConfidentialClientCache(request);
            if (token2 != null) {
                LoggingUtil.logTokenSuccess(LOGGER, request);
                return token2;
            }
        }
        catch (Exception token2) {
            // empty catch block
        }
        try {
            token2 = this.identitySyncClient.authenticateWithConfidentialClient(request);
            LoggingUtil.logTokenSuccess(LOGGER, request);
            return token2;
        }
        catch (Exception e) {
            LoggingUtil.logTokenError(LOGGER, this.identityClient.getIdentityClientOptions(), request, e);
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
    }
}

