/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources.configuration;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import java.util.Locale;
import java.util.regex.Pattern;

public final class LanguageQualifier
extends ResourceQualifier {
    private static final Pattern sLanguagePattern = Pattern.compile("^[a-zA-Z]{2}$");
    public static final String FAKE_LANG_VALUE = "__";
    public static final String NAME = "Language";
    private String mValue;

    public static LanguageQualifier getQualifier(String segment) {
        if (sLanguagePattern.matcher(segment).matches()) {
            LanguageQualifier qualifier = new LanguageQualifier();
            qualifier.mValue = segment;
            return qualifier;
        }
        return null;
    }

    public static String getFolderSegment(String value) {
        String segment = value.toLowerCase(Locale.US);
        if (sLanguagePattern.matcher(segment).matches()) {
            return segment;
        }
        return null;
    }

    public LanguageQualifier() {
    }

    public LanguageQualifier(String value) {
        this.mValue = value;
    }

    public String getValue() {
        if (this.mValue != null) {
            return this.mValue;
        }
        return "";
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return NAME;
    }

    @Override
    public int since() {
        return 1;
    }

    @Override
    public boolean isValid() {
        return this.mValue != null;
    }

    @Override
    public boolean hasFakeValue() {
        return FAKE_LANG_VALUE.equals(this.mValue);
    }

    @Override
    public boolean checkAndSet(String value, FolderConfiguration config) {
        LanguageQualifier qualifier = LanguageQualifier.getQualifier(value);
        if (qualifier != null) {
            config.setLanguageQualifier(qualifier);
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object qualifier) {
        if (qualifier instanceof LanguageQualifier) {
            if (this.mValue == null) {
                return ((LanguageQualifier)qualifier).mValue == null;
            }
            return this.mValue.equals(((LanguageQualifier)qualifier).mValue);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.mValue != null) {
            return this.mValue.hashCode();
        }
        return 0;
    }

    @Override
    public String getFolderSegment() {
        if (this.mValue != null) {
            return LanguageQualifier.getFolderSegment(this.mValue);
        }
        return "";
    }

    @Override
    public String getShortDisplayValue() {
        if (this.mValue != null) {
            return this.mValue;
        }
        return "";
    }

    @Override
    public String getLongDisplayValue() {
        if (this.mValue != null) {
            return String.format("Language %s", this.mValue);
        }
        return "";
    }
}

