/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import java.io.File;
import java.util.Collections;
import java.util.List;
import lombok.ast.Assert;
import lombok.ast.AstVisitor;
import lombok.ast.BinaryExpression;
import lombok.ast.BooleanLiteral;
import lombok.ast.Expression;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.Node;
import lombok.ast.NullLiteral;

public class AssertDetector
extends Detector
implements Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create((String)"Assert", (String)"Assertions", (String)"Assertions are not checked at runtime. There are ways to request that they be used by Dalvik (`adb shell setprop debug.assert 1`), but the property is ignored in many places and can not be relied upon. Instead, perform conditional checking inside `if (BuildConfig.DEBUG) { }` blocks. That constant is a static final boolean which is true in debug builds and false in release builds, and the Java compiler completely removes all code inside the if-body from the app.\n\nFor example, you can replace `assert speed > 0` with `if (BuildConfig.DEBUG && !(speed > 0)) { throw new AssertionError() }`.\n\n(Note: This lint check does not flag assertions purely asserting nullness or non-nullness; these are typically more intended for tools usage than runtime checks.)", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.WARNING, (Implementation)new Implementation(AssertDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("https://code.google.com/p/android/issues/detail?id=65183");

    public boolean appliesTo(@NonNull Context context, @NonNull File file) {
        return true;
    }

    public List<Class<? extends Node>> getApplicableNodeTypes() {
        return Collections.singletonList(Assert.class);
    }

    public AstVisitor createJavaVisitor(final @NonNull JavaContext context) {
        return new ForwardingAstVisitor(){

            public boolean visitAssert(Assert node) {
                Boolean b;
                if (!context.getMainProject().isAndroidProject()) {
                    return true;
                }
                Expression assertion = node.astAssertion();
                if (assertion instanceof BooleanLiteral ? (b = ((BooleanLiteral)assertion).astValue()) != null && b != false : AssertDetector.isNullCheck(assertion)) {
                    return false;
                }
                String message = "Assertions are unreliable. Use `BuildConfig.DEBUG` conditional checks instead.";
                context.report(ISSUE, (Node)node, context.getLocation((Node)node), message);
                return false;
            }
        };
    }

    private static boolean isNullCheck(Expression expression) {
        if (expression instanceof BinaryExpression) {
            BinaryExpression binExp = (BinaryExpression)expression;
            if (binExp.astLeft() instanceof NullLiteral || binExp.astRight() instanceof NullLiteral) {
                return true;
            }
            return AssertDetector.isNullCheck(binExp.astLeft()) && AssertDetector.isNullCheck(binExp.astRight());
        }
        return false;
    }
}

