/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.timestreaminfluxdb.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.timestreaminfluxdb.model.DbInstanceType;
import com.amazonaws.services.timestreaminfluxdb.model.DbStorageType;
import com.amazonaws.services.timestreaminfluxdb.model.DeploymentType;
import com.amazonaws.services.timestreaminfluxdb.model.LogDeliveryConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateDbInstanceRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String username;
    private String password;
    private String organization;
    private String bucket;
    private String dbInstanceType;
    private List<String> vpcSubnetIds;
    private List<String> vpcSecurityGroupIds;
    private Boolean publiclyAccessible;
    private String dbStorageType;
    private Integer allocatedStorage;
    private String dbParameterGroupIdentifier;
    private String deploymentType;
    private LogDeliveryConfiguration logDeliveryConfiguration;
    private Map<String, String> tags;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateDbInstanceRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public CreateDbInstanceRequest withUsername(String username) {
        this.setUsername(username);
        return this;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public CreateDbInstanceRequest withPassword(String password) {
        this.setPassword(password);
        return this;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getOrganization() {
        return this.organization;
    }

    public CreateDbInstanceRequest withOrganization(String organization) {
        this.setOrganization(organization);
        return this;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getBucket() {
        return this.bucket;
    }

    public CreateDbInstanceRequest withBucket(String bucket) {
        this.setBucket(bucket);
        return this;
    }

    public void setDbInstanceType(String dbInstanceType) {
        this.dbInstanceType = dbInstanceType;
    }

    public String getDbInstanceType() {
        return this.dbInstanceType;
    }

    public CreateDbInstanceRequest withDbInstanceType(String dbInstanceType) {
        this.setDbInstanceType(dbInstanceType);
        return this;
    }

    public CreateDbInstanceRequest withDbInstanceType(DbInstanceType dbInstanceType) {
        this.dbInstanceType = dbInstanceType.toString();
        return this;
    }

    public List<String> getVpcSubnetIds() {
        return this.vpcSubnetIds;
    }

    public void setVpcSubnetIds(Collection<String> vpcSubnetIds) {
        if (vpcSubnetIds == null) {
            this.vpcSubnetIds = null;
            return;
        }
        this.vpcSubnetIds = new ArrayList<String>(vpcSubnetIds);
    }

    public CreateDbInstanceRequest withVpcSubnetIds(String ... vpcSubnetIds) {
        if (this.vpcSubnetIds == null) {
            this.setVpcSubnetIds(new ArrayList<String>(vpcSubnetIds.length));
        }
        for (String ele : vpcSubnetIds) {
            this.vpcSubnetIds.add(ele);
        }
        return this;
    }

    public CreateDbInstanceRequest withVpcSubnetIds(Collection<String> vpcSubnetIds) {
        this.setVpcSubnetIds(vpcSubnetIds);
        return this;
    }

    public List<String> getVpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
        if (vpcSecurityGroupIds == null) {
            this.vpcSecurityGroupIds = null;
            return;
        }
        this.vpcSecurityGroupIds = new ArrayList<String>(vpcSecurityGroupIds);
    }

    public CreateDbInstanceRequest withVpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
        if (this.vpcSecurityGroupIds == null) {
            this.setVpcSecurityGroupIds(new ArrayList<String>(vpcSecurityGroupIds.length));
        }
        for (String ele : vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds.add(ele);
        }
        return this;
    }

    public CreateDbInstanceRequest withVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
        this.setVpcSecurityGroupIds(vpcSecurityGroupIds);
        return this;
    }

    public void setPubliclyAccessible(Boolean publiclyAccessible) {
        this.publiclyAccessible = publiclyAccessible;
    }

    public Boolean getPubliclyAccessible() {
        return this.publiclyAccessible;
    }

    public CreateDbInstanceRequest withPubliclyAccessible(Boolean publiclyAccessible) {
        this.setPubliclyAccessible(publiclyAccessible);
        return this;
    }

    public Boolean isPubliclyAccessible() {
        return this.publiclyAccessible;
    }

    public void setDbStorageType(String dbStorageType) {
        this.dbStorageType = dbStorageType;
    }

    public String getDbStorageType() {
        return this.dbStorageType;
    }

    public CreateDbInstanceRequest withDbStorageType(String dbStorageType) {
        this.setDbStorageType(dbStorageType);
        return this;
    }

    public CreateDbInstanceRequest withDbStorageType(DbStorageType dbStorageType) {
        this.dbStorageType = dbStorageType.toString();
        return this;
    }

    public void setAllocatedStorage(Integer allocatedStorage) {
        this.allocatedStorage = allocatedStorage;
    }

    public Integer getAllocatedStorage() {
        return this.allocatedStorage;
    }

    public CreateDbInstanceRequest withAllocatedStorage(Integer allocatedStorage) {
        this.setAllocatedStorage(allocatedStorage);
        return this;
    }

    public void setDbParameterGroupIdentifier(String dbParameterGroupIdentifier) {
        this.dbParameterGroupIdentifier = dbParameterGroupIdentifier;
    }

    public String getDbParameterGroupIdentifier() {
        return this.dbParameterGroupIdentifier;
    }

    public CreateDbInstanceRequest withDbParameterGroupIdentifier(String dbParameterGroupIdentifier) {
        this.setDbParameterGroupIdentifier(dbParameterGroupIdentifier);
        return this;
    }

    public void setDeploymentType(String deploymentType) {
        this.deploymentType = deploymentType;
    }

    public String getDeploymentType() {
        return this.deploymentType;
    }

    public CreateDbInstanceRequest withDeploymentType(String deploymentType) {
        this.setDeploymentType(deploymentType);
        return this;
    }

    public CreateDbInstanceRequest withDeploymentType(DeploymentType deploymentType) {
        this.deploymentType = deploymentType.toString();
        return this;
    }

    public void setLogDeliveryConfiguration(LogDeliveryConfiguration logDeliveryConfiguration) {
        this.logDeliveryConfiguration = logDeliveryConfiguration;
    }

    public LogDeliveryConfiguration getLogDeliveryConfiguration() {
        return this.logDeliveryConfiguration;
    }

    public CreateDbInstanceRequest withLogDeliveryConfiguration(LogDeliveryConfiguration logDeliveryConfiguration) {
        this.setLogDeliveryConfiguration(logDeliveryConfiguration);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateDbInstanceRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateDbInstanceRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateDbInstanceRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getUsername() != null) {
            sb.append("Username: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getPassword() != null) {
            sb.append("Password: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getOrganization() != null) {
            sb.append("Organization: ").append(this.getOrganization()).append(",");
        }
        if (this.getBucket() != null) {
            sb.append("Bucket: ").append(this.getBucket()).append(",");
        }
        if (this.getDbInstanceType() != null) {
            sb.append("DbInstanceType: ").append(this.getDbInstanceType()).append(",");
        }
        if (this.getVpcSubnetIds() != null) {
            sb.append("VpcSubnetIds: ").append(this.getVpcSubnetIds()).append(",");
        }
        if (this.getVpcSecurityGroupIds() != null) {
            sb.append("VpcSecurityGroupIds: ").append(this.getVpcSecurityGroupIds()).append(",");
        }
        if (this.getPubliclyAccessible() != null) {
            sb.append("PubliclyAccessible: ").append(this.getPubliclyAccessible()).append(",");
        }
        if (this.getDbStorageType() != null) {
            sb.append("DbStorageType: ").append(this.getDbStorageType()).append(",");
        }
        if (this.getAllocatedStorage() != null) {
            sb.append("AllocatedStorage: ").append(this.getAllocatedStorage()).append(",");
        }
        if (this.getDbParameterGroupIdentifier() != null) {
            sb.append("DbParameterGroupIdentifier: ").append(this.getDbParameterGroupIdentifier()).append(",");
        }
        if (this.getDeploymentType() != null) {
            sb.append("DeploymentType: ").append(this.getDeploymentType()).append(",");
        }
        if (this.getLogDeliveryConfiguration() != null) {
            sb.append("LogDeliveryConfiguration: ").append(this.getLogDeliveryConfiguration()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDbInstanceRequest)) {
            return false;
        }
        CreateDbInstanceRequest other = (CreateDbInstanceRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getUsername() == null ^ this.getUsername() == null) {
            return false;
        }
        if (other.getUsername() != null && !other.getUsername().equals(this.getUsername())) {
            return false;
        }
        if (other.getPassword() == null ^ this.getPassword() == null) {
            return false;
        }
        if (other.getPassword() != null && !other.getPassword().equals(this.getPassword())) {
            return false;
        }
        if (other.getOrganization() == null ^ this.getOrganization() == null) {
            return false;
        }
        if (other.getOrganization() != null && !other.getOrganization().equals(this.getOrganization())) {
            return false;
        }
        if (other.getBucket() == null ^ this.getBucket() == null) {
            return false;
        }
        if (other.getBucket() != null && !other.getBucket().equals(this.getBucket())) {
            return false;
        }
        if (other.getDbInstanceType() == null ^ this.getDbInstanceType() == null) {
            return false;
        }
        if (other.getDbInstanceType() != null && !other.getDbInstanceType().equals(this.getDbInstanceType())) {
            return false;
        }
        if (other.getVpcSubnetIds() == null ^ this.getVpcSubnetIds() == null) {
            return false;
        }
        if (other.getVpcSubnetIds() != null && !other.getVpcSubnetIds().equals(this.getVpcSubnetIds())) {
            return false;
        }
        if (other.getVpcSecurityGroupIds() == null ^ this.getVpcSecurityGroupIds() == null) {
            return false;
        }
        if (other.getVpcSecurityGroupIds() != null && !other.getVpcSecurityGroupIds().equals(this.getVpcSecurityGroupIds())) {
            return false;
        }
        if (other.getPubliclyAccessible() == null ^ this.getPubliclyAccessible() == null) {
            return false;
        }
        if (other.getPubliclyAccessible() != null && !other.getPubliclyAccessible().equals(this.getPubliclyAccessible())) {
            return false;
        }
        if (other.getDbStorageType() == null ^ this.getDbStorageType() == null) {
            return false;
        }
        if (other.getDbStorageType() != null && !other.getDbStorageType().equals(this.getDbStorageType())) {
            return false;
        }
        if (other.getAllocatedStorage() == null ^ this.getAllocatedStorage() == null) {
            return false;
        }
        if (other.getAllocatedStorage() != null && !other.getAllocatedStorage().equals(this.getAllocatedStorage())) {
            return false;
        }
        if (other.getDbParameterGroupIdentifier() == null ^ this.getDbParameterGroupIdentifier() == null) {
            return false;
        }
        if (other.getDbParameterGroupIdentifier() != null && !other.getDbParameterGroupIdentifier().equals(this.getDbParameterGroupIdentifier())) {
            return false;
        }
        if (other.getDeploymentType() == null ^ this.getDeploymentType() == null) {
            return false;
        }
        if (other.getDeploymentType() != null && !other.getDeploymentType().equals(this.getDeploymentType())) {
            return false;
        }
        if (other.getLogDeliveryConfiguration() == null ^ this.getLogDeliveryConfiguration() == null) {
            return false;
        }
        if (other.getLogDeliveryConfiguration() != null && !other.getLogDeliveryConfiguration().equals(this.getLogDeliveryConfiguration())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getUsername() == null ? 0 : this.getUsername().hashCode());
        hashCode = 31 * hashCode + (this.getPassword() == null ? 0 : this.getPassword().hashCode());
        hashCode = 31 * hashCode + (this.getOrganization() == null ? 0 : this.getOrganization().hashCode());
        hashCode = 31 * hashCode + (this.getBucket() == null ? 0 : this.getBucket().hashCode());
        hashCode = 31 * hashCode + (this.getDbInstanceType() == null ? 0 : this.getDbInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getVpcSubnetIds() == null ? 0 : this.getVpcSubnetIds().hashCode());
        hashCode = 31 * hashCode + (this.getVpcSecurityGroupIds() == null ? 0 : this.getVpcSecurityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.getPubliclyAccessible() == null ? 0 : this.getPubliclyAccessible().hashCode());
        hashCode = 31 * hashCode + (this.getDbStorageType() == null ? 0 : this.getDbStorageType().hashCode());
        hashCode = 31 * hashCode + (this.getAllocatedStorage() == null ? 0 : this.getAllocatedStorage().hashCode());
        hashCode = 31 * hashCode + (this.getDbParameterGroupIdentifier() == null ? 0 : this.getDbParameterGroupIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getDeploymentType() == null ? 0 : this.getDeploymentType().hashCode());
        hashCode = 31 * hashCode + (this.getLogDeliveryConfiguration() == null ? 0 : this.getLogDeliveryConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateDbInstanceRequest clone() {
        return (CreateDbInstanceRequest)super.clone();
    }
}

