/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.textract.model.Query;
import com.amazonaws.services.textract.model.transform.QueriesConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class QueriesConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Query> queries;

    public List<Query> getQueries() {
        return this.queries;
    }

    public void setQueries(Collection<Query> queries) {
        if (queries == null) {
            this.queries = null;
            return;
        }
        this.queries = new ArrayList<Query>(queries);
    }

    public QueriesConfig withQueries(Query ... queries) {
        if (this.queries == null) {
            this.setQueries(new ArrayList<Query>(queries.length));
        }
        for (Query ele : queries) {
            this.queries.add(ele);
        }
        return this;
    }

    public QueriesConfig withQueries(Collection<Query> queries) {
        this.setQueries(queries);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getQueries() != null) {
            sb.append("Queries: ").append(this.getQueries());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueriesConfig)) {
            return false;
        }
        QueriesConfig other = (QueriesConfig)obj;
        if (other.getQueries() == null ^ this.getQueries() == null) {
            return false;
        }
        return other.getQueries() == null || other.getQueries().equals(this.getQueries());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getQueries() == null ? 0 : this.getQueries().hashCode());
        return hashCode;
    }

    public QueriesConfig clone() {
        try {
            return (QueriesConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        QueriesConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

