/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmcontacts.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ssmcontacts.model.WeeklySetting;

@SdkInternalApi
public class WeeklySettingMarshaller {
    private static final MarshallingInfo<String> DAYOFWEEK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DayOfWeek").build();
    private static final MarshallingInfo<StructuredPojo> HANDOFFTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HandOffTime").build();
    private static final WeeklySettingMarshaller instance = new WeeklySettingMarshaller();

    public static WeeklySettingMarshaller getInstance() {
        return instance;
    }

    public void marshall(WeeklySetting weeklySetting, ProtocolMarshaller protocolMarshaller) {
        if (weeklySetting == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)weeklySetting.getDayOfWeek(), DAYOFWEEK_BINDING);
            protocolMarshaller.marshall((Object)weeklySetting.getHandOffTime(), HANDOFFTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

