/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securitylake.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.securitylake.model.SubscriberResource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListSubscribersResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<SubscriberResource> subscribers;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListSubscribersResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<SubscriberResource> getSubscribers() {
        return this.subscribers;
    }

    public void setSubscribers(Collection<SubscriberResource> subscribers) {
        if (subscribers == null) {
            this.subscribers = null;
            return;
        }
        this.subscribers = new ArrayList<SubscriberResource>(subscribers);
    }

    public ListSubscribersResult withSubscribers(SubscriberResource ... subscribers) {
        if (this.subscribers == null) {
            this.setSubscribers(new ArrayList<SubscriberResource>(subscribers.length));
        }
        for (SubscriberResource ele : subscribers) {
            this.subscribers.add(ele);
        }
        return this;
    }

    public ListSubscribersResult withSubscribers(Collection<SubscriberResource> subscribers) {
        this.setSubscribers(subscribers);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getSubscribers() != null) {
            sb.append("Subscribers: ").append(this.getSubscribers());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSubscribersResult)) {
            return false;
        }
        ListSubscribersResult other = (ListSubscribersResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getSubscribers() == null ^ this.getSubscribers() == null) {
            return false;
        }
        return other.getSubscribers() == null || other.getSubscribers().equals(this.getSubscribers());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getSubscribers() == null ? 0 : this.getSubscribers().hashCode());
        return hashCode;
    }

    public ListSubscribersResult clone() {
        try {
            return (ListSubscribersResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

