/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.omics.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.omics.model.ReadSetS3Access;
import com.amazonaws.services.omics.model.transform.FileInformationMarshaller;
import java.io.Serializable;

public class FileInformation
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer totalParts;
    private Long partSize;
    private Long contentLength;
    private ReadSetS3Access s3Access;

    public void setTotalParts(Integer totalParts) {
        this.totalParts = totalParts;
    }

    public Integer getTotalParts() {
        return this.totalParts;
    }

    public FileInformation withTotalParts(Integer totalParts) {
        this.setTotalParts(totalParts);
        return this;
    }

    public void setPartSize(Long partSize) {
        this.partSize = partSize;
    }

    public Long getPartSize() {
        return this.partSize;
    }

    public FileInformation withPartSize(Long partSize) {
        this.setPartSize(partSize);
        return this;
    }

    public void setContentLength(Long contentLength) {
        this.contentLength = contentLength;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public FileInformation withContentLength(Long contentLength) {
        this.setContentLength(contentLength);
        return this;
    }

    public void setS3Access(ReadSetS3Access s3Access) {
        this.s3Access = s3Access;
    }

    public ReadSetS3Access getS3Access() {
        return this.s3Access;
    }

    public FileInformation withS3Access(ReadSetS3Access s3Access) {
        this.setS3Access(s3Access);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTotalParts() != null) {
            sb.append("TotalParts: ").append(this.getTotalParts()).append(",");
        }
        if (this.getPartSize() != null) {
            sb.append("PartSize: ").append(this.getPartSize()).append(",");
        }
        if (this.getContentLength() != null) {
            sb.append("ContentLength: ").append(this.getContentLength()).append(",");
        }
        if (this.getS3Access() != null) {
            sb.append("S3Access: ").append(this.getS3Access());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileInformation)) {
            return false;
        }
        FileInformation other = (FileInformation)obj;
        if (other.getTotalParts() == null ^ this.getTotalParts() == null) {
            return false;
        }
        if (other.getTotalParts() != null && !other.getTotalParts().equals(this.getTotalParts())) {
            return false;
        }
        if (other.getPartSize() == null ^ this.getPartSize() == null) {
            return false;
        }
        if (other.getPartSize() != null && !other.getPartSize().equals(this.getPartSize())) {
            return false;
        }
        if (other.getContentLength() == null ^ this.getContentLength() == null) {
            return false;
        }
        if (other.getContentLength() != null && !other.getContentLength().equals(this.getContentLength())) {
            return false;
        }
        if (other.getS3Access() == null ^ this.getS3Access() == null) {
            return false;
        }
        return other.getS3Access() == null || other.getS3Access().equals(this.getS3Access());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTotalParts() == null ? 0 : this.getTotalParts().hashCode());
        hashCode = 31 * hashCode + (this.getPartSize() == null ? 0 : this.getPartSize().hashCode());
        hashCode = 31 * hashCode + (this.getContentLength() == null ? 0 : this.getContentLength().hashCode());
        hashCode = 31 * hashCode + (this.getS3Access() == null ? 0 : this.getS3Access().hashCode());
        return hashCode;
    }

    public FileInformation clone() {
        try {
            return (FileInformation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FileInformationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

