/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.neptunedata.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.neptunedata.model.transform.NodeStructureMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NodeStructure
implements Serializable,
Cloneable,
StructuredPojo {
    private Long count;
    private List<String> nodeProperties;
    private List<String> distinctOutgoingEdgeLabels;

    public void setCount(Long count) {
        this.count = count;
    }

    public Long getCount() {
        return this.count;
    }

    public NodeStructure withCount(Long count) {
        this.setCount(count);
        return this;
    }

    public List<String> getNodeProperties() {
        return this.nodeProperties;
    }

    public void setNodeProperties(Collection<String> nodeProperties) {
        if (nodeProperties == null) {
            this.nodeProperties = null;
            return;
        }
        this.nodeProperties = new ArrayList<String>(nodeProperties);
    }

    public NodeStructure withNodeProperties(String ... nodeProperties) {
        if (this.nodeProperties == null) {
            this.setNodeProperties(new ArrayList<String>(nodeProperties.length));
        }
        for (String ele : nodeProperties) {
            this.nodeProperties.add(ele);
        }
        return this;
    }

    public NodeStructure withNodeProperties(Collection<String> nodeProperties) {
        this.setNodeProperties(nodeProperties);
        return this;
    }

    public List<String> getDistinctOutgoingEdgeLabels() {
        return this.distinctOutgoingEdgeLabels;
    }

    public void setDistinctOutgoingEdgeLabels(Collection<String> distinctOutgoingEdgeLabels) {
        if (distinctOutgoingEdgeLabels == null) {
            this.distinctOutgoingEdgeLabels = null;
            return;
        }
        this.distinctOutgoingEdgeLabels = new ArrayList<String>(distinctOutgoingEdgeLabels);
    }

    public NodeStructure withDistinctOutgoingEdgeLabels(String ... distinctOutgoingEdgeLabels) {
        if (this.distinctOutgoingEdgeLabels == null) {
            this.setDistinctOutgoingEdgeLabels(new ArrayList<String>(distinctOutgoingEdgeLabels.length));
        }
        for (String ele : distinctOutgoingEdgeLabels) {
            this.distinctOutgoingEdgeLabels.add(ele);
        }
        return this;
    }

    public NodeStructure withDistinctOutgoingEdgeLabels(Collection<String> distinctOutgoingEdgeLabels) {
        this.setDistinctOutgoingEdgeLabels(distinctOutgoingEdgeLabels);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCount() != null) {
            sb.append("Count: ").append(this.getCount()).append(",");
        }
        if (this.getNodeProperties() != null) {
            sb.append("NodeProperties: ").append(this.getNodeProperties()).append(",");
        }
        if (this.getDistinctOutgoingEdgeLabels() != null) {
            sb.append("DistinctOutgoingEdgeLabels: ").append(this.getDistinctOutgoingEdgeLabels());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeStructure)) {
            return false;
        }
        NodeStructure other = (NodeStructure)obj;
        if (other.getCount() == null ^ this.getCount() == null) {
            return false;
        }
        if (other.getCount() != null && !other.getCount().equals(this.getCount())) {
            return false;
        }
        if (other.getNodeProperties() == null ^ this.getNodeProperties() == null) {
            return false;
        }
        if (other.getNodeProperties() != null && !other.getNodeProperties().equals(this.getNodeProperties())) {
            return false;
        }
        if (other.getDistinctOutgoingEdgeLabels() == null ^ this.getDistinctOutgoingEdgeLabels() == null) {
            return false;
        }
        return other.getDistinctOutgoingEdgeLabels() == null || other.getDistinctOutgoingEdgeLabels().equals(this.getDistinctOutgoingEdgeLabels());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCount() == null ? 0 : this.getCount().hashCode());
        hashCode = 31 * hashCode + (this.getNodeProperties() == null ? 0 : this.getNodeProperties().hashCode());
        hashCode = 31 * hashCode + (this.getDistinctOutgoingEdgeLabels() == null ? 0 : this.getDistinctOutgoingEdgeLabels().hashCode());
        return hashCode;
    }

    public NodeStructure clone() {
        try {
            return (NodeStructure)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NodeStructureMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

