/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.licensemanager;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.licensemanager.AWSLicenseManagerAsync;
import com.amazonaws.services.licensemanager.AWSLicenseManagerAsyncClientBuilder;
import com.amazonaws.services.licensemanager.AWSLicenseManagerClient;
import com.amazonaws.services.licensemanager.model.CreateLicenseConfigurationRequest;
import com.amazonaws.services.licensemanager.model.CreateLicenseConfigurationResult;
import com.amazonaws.services.licensemanager.model.DeleteLicenseConfigurationRequest;
import com.amazonaws.services.licensemanager.model.DeleteLicenseConfigurationResult;
import com.amazonaws.services.licensemanager.model.GetLicenseConfigurationRequest;
import com.amazonaws.services.licensemanager.model.GetLicenseConfigurationResult;
import com.amazonaws.services.licensemanager.model.GetServiceSettingsRequest;
import com.amazonaws.services.licensemanager.model.GetServiceSettingsResult;
import com.amazonaws.services.licensemanager.model.ListAssociationsForLicenseConfigurationRequest;
import com.amazonaws.services.licensemanager.model.ListAssociationsForLicenseConfigurationResult;
import com.amazonaws.services.licensemanager.model.ListFailuresForLicenseConfigurationOperationsRequest;
import com.amazonaws.services.licensemanager.model.ListFailuresForLicenseConfigurationOperationsResult;
import com.amazonaws.services.licensemanager.model.ListLicenseConfigurationsRequest;
import com.amazonaws.services.licensemanager.model.ListLicenseConfigurationsResult;
import com.amazonaws.services.licensemanager.model.ListLicenseSpecificationsForResourceRequest;
import com.amazonaws.services.licensemanager.model.ListLicenseSpecificationsForResourceResult;
import com.amazonaws.services.licensemanager.model.ListResourceInventoryRequest;
import com.amazonaws.services.licensemanager.model.ListResourceInventoryResult;
import com.amazonaws.services.licensemanager.model.ListTagsForResourceRequest;
import com.amazonaws.services.licensemanager.model.ListTagsForResourceResult;
import com.amazonaws.services.licensemanager.model.ListUsageForLicenseConfigurationRequest;
import com.amazonaws.services.licensemanager.model.ListUsageForLicenseConfigurationResult;
import com.amazonaws.services.licensemanager.model.TagResourceRequest;
import com.amazonaws.services.licensemanager.model.TagResourceResult;
import com.amazonaws.services.licensemanager.model.UntagResourceRequest;
import com.amazonaws.services.licensemanager.model.UntagResourceResult;
import com.amazonaws.services.licensemanager.model.UpdateLicenseConfigurationRequest;
import com.amazonaws.services.licensemanager.model.UpdateLicenseConfigurationResult;
import com.amazonaws.services.licensemanager.model.UpdateLicenseSpecificationsForResourceRequest;
import com.amazonaws.services.licensemanager.model.UpdateLicenseSpecificationsForResourceResult;
import com.amazonaws.services.licensemanager.model.UpdateServiceSettingsRequest;
import com.amazonaws.services.licensemanager.model.UpdateServiceSettingsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSLicenseManagerAsyncClient
extends AWSLicenseManagerClient
implements AWSLicenseManagerAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSLicenseManagerAsyncClientBuilder asyncBuilder() {
        return AWSLicenseManagerAsyncClientBuilder.standard();
    }

    AWSLicenseManagerAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateLicenseConfigurationResult> createLicenseConfigurationAsync(CreateLicenseConfigurationRequest request) {
        return this.createLicenseConfigurationAsync(request, null);
    }

    @Override
    public Future<CreateLicenseConfigurationResult> createLicenseConfigurationAsync(CreateLicenseConfigurationRequest request, final AsyncHandler<CreateLicenseConfigurationRequest, CreateLicenseConfigurationResult> asyncHandler) {
        final CreateLicenseConfigurationRequest finalRequest = (CreateLicenseConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateLicenseConfigurationResult>(){

            @Override
            public CreateLicenseConfigurationResult call() throws Exception {
                CreateLicenseConfigurationResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeCreateLicenseConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteLicenseConfigurationResult> deleteLicenseConfigurationAsync(DeleteLicenseConfigurationRequest request) {
        return this.deleteLicenseConfigurationAsync(request, null);
    }

    @Override
    public Future<DeleteLicenseConfigurationResult> deleteLicenseConfigurationAsync(DeleteLicenseConfigurationRequest request, final AsyncHandler<DeleteLicenseConfigurationRequest, DeleteLicenseConfigurationResult> asyncHandler) {
        final DeleteLicenseConfigurationRequest finalRequest = (DeleteLicenseConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteLicenseConfigurationResult>(){

            @Override
            public DeleteLicenseConfigurationResult call() throws Exception {
                DeleteLicenseConfigurationResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeDeleteLicenseConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetLicenseConfigurationResult> getLicenseConfigurationAsync(GetLicenseConfigurationRequest request) {
        return this.getLicenseConfigurationAsync(request, null);
    }

    @Override
    public Future<GetLicenseConfigurationResult> getLicenseConfigurationAsync(GetLicenseConfigurationRequest request, final AsyncHandler<GetLicenseConfigurationRequest, GetLicenseConfigurationResult> asyncHandler) {
        final GetLicenseConfigurationRequest finalRequest = (GetLicenseConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetLicenseConfigurationResult>(){

            @Override
            public GetLicenseConfigurationResult call() throws Exception {
                GetLicenseConfigurationResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeGetLicenseConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetServiceSettingsResult> getServiceSettingsAsync(GetServiceSettingsRequest request) {
        return this.getServiceSettingsAsync(request, null);
    }

    @Override
    public Future<GetServiceSettingsResult> getServiceSettingsAsync(GetServiceSettingsRequest request, final AsyncHandler<GetServiceSettingsRequest, GetServiceSettingsResult> asyncHandler) {
        final GetServiceSettingsRequest finalRequest = (GetServiceSettingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetServiceSettingsResult>(){

            @Override
            public GetServiceSettingsResult call() throws Exception {
                GetServiceSettingsResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeGetServiceSettings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAssociationsForLicenseConfigurationResult> listAssociationsForLicenseConfigurationAsync(ListAssociationsForLicenseConfigurationRequest request) {
        return this.listAssociationsForLicenseConfigurationAsync(request, null);
    }

    @Override
    public Future<ListAssociationsForLicenseConfigurationResult> listAssociationsForLicenseConfigurationAsync(ListAssociationsForLicenseConfigurationRequest request, final AsyncHandler<ListAssociationsForLicenseConfigurationRequest, ListAssociationsForLicenseConfigurationResult> asyncHandler) {
        final ListAssociationsForLicenseConfigurationRequest finalRequest = (ListAssociationsForLicenseConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAssociationsForLicenseConfigurationResult>(){

            @Override
            public ListAssociationsForLicenseConfigurationResult call() throws Exception {
                ListAssociationsForLicenseConfigurationResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeListAssociationsForLicenseConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListFailuresForLicenseConfigurationOperationsResult> listFailuresForLicenseConfigurationOperationsAsync(ListFailuresForLicenseConfigurationOperationsRequest request) {
        return this.listFailuresForLicenseConfigurationOperationsAsync(request, null);
    }

    @Override
    public Future<ListFailuresForLicenseConfigurationOperationsResult> listFailuresForLicenseConfigurationOperationsAsync(ListFailuresForLicenseConfigurationOperationsRequest request, final AsyncHandler<ListFailuresForLicenseConfigurationOperationsRequest, ListFailuresForLicenseConfigurationOperationsResult> asyncHandler) {
        final ListFailuresForLicenseConfigurationOperationsRequest finalRequest = (ListFailuresForLicenseConfigurationOperationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListFailuresForLicenseConfigurationOperationsResult>(){

            @Override
            public ListFailuresForLicenseConfigurationOperationsResult call() throws Exception {
                ListFailuresForLicenseConfigurationOperationsResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeListFailuresForLicenseConfigurationOperations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListLicenseConfigurationsResult> listLicenseConfigurationsAsync(ListLicenseConfigurationsRequest request) {
        return this.listLicenseConfigurationsAsync(request, null);
    }

    @Override
    public Future<ListLicenseConfigurationsResult> listLicenseConfigurationsAsync(ListLicenseConfigurationsRequest request, final AsyncHandler<ListLicenseConfigurationsRequest, ListLicenseConfigurationsResult> asyncHandler) {
        final ListLicenseConfigurationsRequest finalRequest = (ListLicenseConfigurationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListLicenseConfigurationsResult>(){

            @Override
            public ListLicenseConfigurationsResult call() throws Exception {
                ListLicenseConfigurationsResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeListLicenseConfigurations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListLicenseSpecificationsForResourceResult> listLicenseSpecificationsForResourceAsync(ListLicenseSpecificationsForResourceRequest request) {
        return this.listLicenseSpecificationsForResourceAsync(request, null);
    }

    @Override
    public Future<ListLicenseSpecificationsForResourceResult> listLicenseSpecificationsForResourceAsync(ListLicenseSpecificationsForResourceRequest request, final AsyncHandler<ListLicenseSpecificationsForResourceRequest, ListLicenseSpecificationsForResourceResult> asyncHandler) {
        final ListLicenseSpecificationsForResourceRequest finalRequest = (ListLicenseSpecificationsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListLicenseSpecificationsForResourceResult>(){

            @Override
            public ListLicenseSpecificationsForResourceResult call() throws Exception {
                ListLicenseSpecificationsForResourceResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeListLicenseSpecificationsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListResourceInventoryResult> listResourceInventoryAsync(ListResourceInventoryRequest request) {
        return this.listResourceInventoryAsync(request, null);
    }

    @Override
    public Future<ListResourceInventoryResult> listResourceInventoryAsync(ListResourceInventoryRequest request, final AsyncHandler<ListResourceInventoryRequest, ListResourceInventoryResult> asyncHandler) {
        final ListResourceInventoryRequest finalRequest = (ListResourceInventoryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListResourceInventoryResult>(){

            @Override
            public ListResourceInventoryResult call() throws Exception {
                ListResourceInventoryResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeListResourceInventory(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListUsageForLicenseConfigurationResult> listUsageForLicenseConfigurationAsync(ListUsageForLicenseConfigurationRequest request) {
        return this.listUsageForLicenseConfigurationAsync(request, null);
    }

    @Override
    public Future<ListUsageForLicenseConfigurationResult> listUsageForLicenseConfigurationAsync(ListUsageForLicenseConfigurationRequest request, final AsyncHandler<ListUsageForLicenseConfigurationRequest, ListUsageForLicenseConfigurationResult> asyncHandler) {
        final ListUsageForLicenseConfigurationRequest finalRequest = (ListUsageForLicenseConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListUsageForLicenseConfigurationResult>(){

            @Override
            public ListUsageForLicenseConfigurationResult call() throws Exception {
                ListUsageForLicenseConfigurationResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeListUsageForLicenseConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateLicenseConfigurationResult> updateLicenseConfigurationAsync(UpdateLicenseConfigurationRequest request) {
        return this.updateLicenseConfigurationAsync(request, null);
    }

    @Override
    public Future<UpdateLicenseConfigurationResult> updateLicenseConfigurationAsync(UpdateLicenseConfigurationRequest request, final AsyncHandler<UpdateLicenseConfigurationRequest, UpdateLicenseConfigurationResult> asyncHandler) {
        final UpdateLicenseConfigurationRequest finalRequest = (UpdateLicenseConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateLicenseConfigurationResult>(){

            @Override
            public UpdateLicenseConfigurationResult call() throws Exception {
                UpdateLicenseConfigurationResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeUpdateLicenseConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateLicenseSpecificationsForResourceResult> updateLicenseSpecificationsForResourceAsync(UpdateLicenseSpecificationsForResourceRequest request) {
        return this.updateLicenseSpecificationsForResourceAsync(request, null);
    }

    @Override
    public Future<UpdateLicenseSpecificationsForResourceResult> updateLicenseSpecificationsForResourceAsync(UpdateLicenseSpecificationsForResourceRequest request, final AsyncHandler<UpdateLicenseSpecificationsForResourceRequest, UpdateLicenseSpecificationsForResourceResult> asyncHandler) {
        final UpdateLicenseSpecificationsForResourceRequest finalRequest = (UpdateLicenseSpecificationsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateLicenseSpecificationsForResourceResult>(){

            @Override
            public UpdateLicenseSpecificationsForResourceResult call() throws Exception {
                UpdateLicenseSpecificationsForResourceResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeUpdateLicenseSpecificationsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateServiceSettingsResult> updateServiceSettingsAsync(UpdateServiceSettingsRequest request) {
        return this.updateServiceSettingsAsync(request, null);
    }

    @Override
    public Future<UpdateServiceSettingsResult> updateServiceSettingsAsync(UpdateServiceSettingsRequest request, final AsyncHandler<UpdateServiceSettingsRequest, UpdateServiceSettingsResult> asyncHandler) {
        final UpdateServiceSettingsRequest finalRequest = (UpdateServiceSettingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateServiceSettingsResult>(){

            @Override
            public UpdateServiceSettingsResult call() throws Exception {
                UpdateServiceSettingsResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeUpdateServiceSettings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

