/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexmodelsv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lexmodelsv2.model.AnalyticsModality;
import com.amazonaws.services.lexmodelsv2.model.ConversationEndState;
import com.amazonaws.services.lexmodelsv2.model.InvokedIntentSample;
import com.amazonaws.services.lexmodelsv2.model.transform.SessionSpecificationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class SessionSpecification
implements Serializable,
Cloneable,
StructuredPojo {
    private String botAliasId;
    private String botVersion;
    private String localeId;
    private String channel;
    private String sessionId;
    private Date conversationStartTime;
    private Date conversationEndTime;
    private Long conversationDurationSeconds;
    private String conversationEndState;
    private String mode;
    private Long numberOfTurns;
    private List<InvokedIntentSample> invokedIntentSamples;
    private String originatingRequestId;

    public void setBotAliasId(String botAliasId) {
        this.botAliasId = botAliasId;
    }

    public String getBotAliasId() {
        return this.botAliasId;
    }

    public SessionSpecification withBotAliasId(String botAliasId) {
        this.setBotAliasId(botAliasId);
        return this;
    }

    public void setBotVersion(String botVersion) {
        this.botVersion = botVersion;
    }

    public String getBotVersion() {
        return this.botVersion;
    }

    public SessionSpecification withBotVersion(String botVersion) {
        this.setBotVersion(botVersion);
        return this;
    }

    public void setLocaleId(String localeId) {
        this.localeId = localeId;
    }

    public String getLocaleId() {
        return this.localeId;
    }

    public SessionSpecification withLocaleId(String localeId) {
        this.setLocaleId(localeId);
        return this;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getChannel() {
        return this.channel;
    }

    public SessionSpecification withChannel(String channel) {
        this.setChannel(channel);
        return this;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public SessionSpecification withSessionId(String sessionId) {
        this.setSessionId(sessionId);
        return this;
    }

    public void setConversationStartTime(Date conversationStartTime) {
        this.conversationStartTime = conversationStartTime;
    }

    public Date getConversationStartTime() {
        return this.conversationStartTime;
    }

    public SessionSpecification withConversationStartTime(Date conversationStartTime) {
        this.setConversationStartTime(conversationStartTime);
        return this;
    }

    public void setConversationEndTime(Date conversationEndTime) {
        this.conversationEndTime = conversationEndTime;
    }

    public Date getConversationEndTime() {
        return this.conversationEndTime;
    }

    public SessionSpecification withConversationEndTime(Date conversationEndTime) {
        this.setConversationEndTime(conversationEndTime);
        return this;
    }

    public void setConversationDurationSeconds(Long conversationDurationSeconds) {
        this.conversationDurationSeconds = conversationDurationSeconds;
    }

    public Long getConversationDurationSeconds() {
        return this.conversationDurationSeconds;
    }

    public SessionSpecification withConversationDurationSeconds(Long conversationDurationSeconds) {
        this.setConversationDurationSeconds(conversationDurationSeconds);
        return this;
    }

    public void setConversationEndState(String conversationEndState) {
        this.conversationEndState = conversationEndState;
    }

    public String getConversationEndState() {
        return this.conversationEndState;
    }

    public SessionSpecification withConversationEndState(String conversationEndState) {
        this.setConversationEndState(conversationEndState);
        return this;
    }

    public SessionSpecification withConversationEndState(ConversationEndState conversationEndState) {
        this.conversationEndState = conversationEndState.toString();
        return this;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getMode() {
        return this.mode;
    }

    public SessionSpecification withMode(String mode) {
        this.setMode(mode);
        return this;
    }

    public SessionSpecification withMode(AnalyticsModality mode) {
        this.mode = mode.toString();
        return this;
    }

    public void setNumberOfTurns(Long numberOfTurns) {
        this.numberOfTurns = numberOfTurns;
    }

    public Long getNumberOfTurns() {
        return this.numberOfTurns;
    }

    public SessionSpecification withNumberOfTurns(Long numberOfTurns) {
        this.setNumberOfTurns(numberOfTurns);
        return this;
    }

    public List<InvokedIntentSample> getInvokedIntentSamples() {
        return this.invokedIntentSamples;
    }

    public void setInvokedIntentSamples(Collection<InvokedIntentSample> invokedIntentSamples) {
        if (invokedIntentSamples == null) {
            this.invokedIntentSamples = null;
            return;
        }
        this.invokedIntentSamples = new ArrayList<InvokedIntentSample>(invokedIntentSamples);
    }

    public SessionSpecification withInvokedIntentSamples(InvokedIntentSample ... invokedIntentSamples) {
        if (this.invokedIntentSamples == null) {
            this.setInvokedIntentSamples(new ArrayList<InvokedIntentSample>(invokedIntentSamples.length));
        }
        for (InvokedIntentSample ele : invokedIntentSamples) {
            this.invokedIntentSamples.add(ele);
        }
        return this;
    }

    public SessionSpecification withInvokedIntentSamples(Collection<InvokedIntentSample> invokedIntentSamples) {
        this.setInvokedIntentSamples(invokedIntentSamples);
        return this;
    }

    public void setOriginatingRequestId(String originatingRequestId) {
        this.originatingRequestId = originatingRequestId;
    }

    public String getOriginatingRequestId() {
        return this.originatingRequestId;
    }

    public SessionSpecification withOriginatingRequestId(String originatingRequestId) {
        this.setOriginatingRequestId(originatingRequestId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBotAliasId() != null) {
            sb.append("BotAliasId: ").append(this.getBotAliasId()).append(",");
        }
        if (this.getBotVersion() != null) {
            sb.append("BotVersion: ").append(this.getBotVersion()).append(",");
        }
        if (this.getLocaleId() != null) {
            sb.append("LocaleId: ").append(this.getLocaleId()).append(",");
        }
        if (this.getChannel() != null) {
            sb.append("Channel: ").append(this.getChannel()).append(",");
        }
        if (this.getSessionId() != null) {
            sb.append("SessionId: ").append(this.getSessionId()).append(",");
        }
        if (this.getConversationStartTime() != null) {
            sb.append("ConversationStartTime: ").append(this.getConversationStartTime()).append(",");
        }
        if (this.getConversationEndTime() != null) {
            sb.append("ConversationEndTime: ").append(this.getConversationEndTime()).append(",");
        }
        if (this.getConversationDurationSeconds() != null) {
            sb.append("ConversationDurationSeconds: ").append(this.getConversationDurationSeconds()).append(",");
        }
        if (this.getConversationEndState() != null) {
            sb.append("ConversationEndState: ").append(this.getConversationEndState()).append(",");
        }
        if (this.getMode() != null) {
            sb.append("Mode: ").append(this.getMode()).append(",");
        }
        if (this.getNumberOfTurns() != null) {
            sb.append("NumberOfTurns: ").append(this.getNumberOfTurns()).append(",");
        }
        if (this.getInvokedIntentSamples() != null) {
            sb.append("InvokedIntentSamples: ").append(this.getInvokedIntentSamples()).append(",");
        }
        if (this.getOriginatingRequestId() != null) {
            sb.append("OriginatingRequestId: ").append(this.getOriginatingRequestId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionSpecification)) {
            return false;
        }
        SessionSpecification other = (SessionSpecification)obj;
        if (other.getBotAliasId() == null ^ this.getBotAliasId() == null) {
            return false;
        }
        if (other.getBotAliasId() != null && !other.getBotAliasId().equals(this.getBotAliasId())) {
            return false;
        }
        if (other.getBotVersion() == null ^ this.getBotVersion() == null) {
            return false;
        }
        if (other.getBotVersion() != null && !other.getBotVersion().equals(this.getBotVersion())) {
            return false;
        }
        if (other.getLocaleId() == null ^ this.getLocaleId() == null) {
            return false;
        }
        if (other.getLocaleId() != null && !other.getLocaleId().equals(this.getLocaleId())) {
            return false;
        }
        if (other.getChannel() == null ^ this.getChannel() == null) {
            return false;
        }
        if (other.getChannel() != null && !other.getChannel().equals(this.getChannel())) {
            return false;
        }
        if (other.getSessionId() == null ^ this.getSessionId() == null) {
            return false;
        }
        if (other.getSessionId() != null && !other.getSessionId().equals(this.getSessionId())) {
            return false;
        }
        if (other.getConversationStartTime() == null ^ this.getConversationStartTime() == null) {
            return false;
        }
        if (other.getConversationStartTime() != null && !other.getConversationStartTime().equals(this.getConversationStartTime())) {
            return false;
        }
        if (other.getConversationEndTime() == null ^ this.getConversationEndTime() == null) {
            return false;
        }
        if (other.getConversationEndTime() != null && !other.getConversationEndTime().equals(this.getConversationEndTime())) {
            return false;
        }
        if (other.getConversationDurationSeconds() == null ^ this.getConversationDurationSeconds() == null) {
            return false;
        }
        if (other.getConversationDurationSeconds() != null && !other.getConversationDurationSeconds().equals(this.getConversationDurationSeconds())) {
            return false;
        }
        if (other.getConversationEndState() == null ^ this.getConversationEndState() == null) {
            return false;
        }
        if (other.getConversationEndState() != null && !other.getConversationEndState().equals(this.getConversationEndState())) {
            return false;
        }
        if (other.getMode() == null ^ this.getMode() == null) {
            return false;
        }
        if (other.getMode() != null && !other.getMode().equals(this.getMode())) {
            return false;
        }
        if (other.getNumberOfTurns() == null ^ this.getNumberOfTurns() == null) {
            return false;
        }
        if (other.getNumberOfTurns() != null && !other.getNumberOfTurns().equals(this.getNumberOfTurns())) {
            return false;
        }
        if (other.getInvokedIntentSamples() == null ^ this.getInvokedIntentSamples() == null) {
            return false;
        }
        if (other.getInvokedIntentSamples() != null && !other.getInvokedIntentSamples().equals(this.getInvokedIntentSamples())) {
            return false;
        }
        if (other.getOriginatingRequestId() == null ^ this.getOriginatingRequestId() == null) {
            return false;
        }
        return other.getOriginatingRequestId() == null || other.getOriginatingRequestId().equals(this.getOriginatingRequestId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBotAliasId() == null ? 0 : this.getBotAliasId().hashCode());
        hashCode = 31 * hashCode + (this.getBotVersion() == null ? 0 : this.getBotVersion().hashCode());
        hashCode = 31 * hashCode + (this.getLocaleId() == null ? 0 : this.getLocaleId().hashCode());
        hashCode = 31 * hashCode + (this.getChannel() == null ? 0 : this.getChannel().hashCode());
        hashCode = 31 * hashCode + (this.getSessionId() == null ? 0 : this.getSessionId().hashCode());
        hashCode = 31 * hashCode + (this.getConversationStartTime() == null ? 0 : this.getConversationStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getConversationEndTime() == null ? 0 : this.getConversationEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getConversationDurationSeconds() == null ? 0 : this.getConversationDurationSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getConversationEndState() == null ? 0 : this.getConversationEndState().hashCode());
        hashCode = 31 * hashCode + (this.getMode() == null ? 0 : this.getMode().hashCode());
        hashCode = 31 * hashCode + (this.getNumberOfTurns() == null ? 0 : this.getNumberOfTurns().hashCode());
        hashCode = 31 * hashCode + (this.getInvokedIntentSamples() == null ? 0 : this.getInvokedIntentSamples().hashCode());
        hashCode = 31 * hashCode + (this.getOriginatingRequestId() == null ? 0 : this.getOriginatingRequestId().hashCode());
        return hashCode;
    }

    public SessionSpecification clone() {
        try {
            return (SessionSpecification)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SessionSpecificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

