/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lakeformation.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lakeformation.model.DataLakePrincipal;
import com.amazonaws.services.lakeformation.model.DetailsMap;
import com.amazonaws.services.lakeformation.model.Permission;
import com.amazonaws.services.lakeformation.model.Resource;
import com.amazonaws.services.lakeformation.model.transform.PrincipalResourcePermissionsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class PrincipalResourcePermissions
implements Serializable,
Cloneable,
StructuredPojo {
    private DataLakePrincipal principal;
    private Resource resource;
    private List<String> permissions;
    private List<String> permissionsWithGrantOption;
    private DetailsMap additionalDetails;
    private Date lastUpdated;
    private String lastUpdatedBy;

    public void setPrincipal(DataLakePrincipal principal) {
        this.principal = principal;
    }

    public DataLakePrincipal getPrincipal() {
        return this.principal;
    }

    public PrincipalResourcePermissions withPrincipal(DataLakePrincipal principal) {
        this.setPrincipal(principal);
        return this;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public Resource getResource() {
        return this.resource;
    }

    public PrincipalResourcePermissions withResource(Resource resource) {
        this.setResource(resource);
        return this;
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Collection<String> permissions) {
        if (permissions == null) {
            this.permissions = null;
            return;
        }
        this.permissions = new ArrayList<String>(permissions);
    }

    public PrincipalResourcePermissions withPermissions(String ... permissions) {
        if (this.permissions == null) {
            this.setPermissions(new ArrayList<String>(permissions.length));
        }
        for (String ele : permissions) {
            this.permissions.add(ele);
        }
        return this;
    }

    public PrincipalResourcePermissions withPermissions(Collection<String> permissions) {
        this.setPermissions(permissions);
        return this;
    }

    public PrincipalResourcePermissions withPermissions(Permission ... permissions) {
        ArrayList<String> permissionsCopy = new ArrayList<String>(permissions.length);
        for (Permission value : permissions) {
            permissionsCopy.add(value.toString());
        }
        if (this.getPermissions() == null) {
            this.setPermissions(permissionsCopy);
        } else {
            this.getPermissions().addAll(permissionsCopy);
        }
        return this;
    }

    public List<String> getPermissionsWithGrantOption() {
        return this.permissionsWithGrantOption;
    }

    public void setPermissionsWithGrantOption(Collection<String> permissionsWithGrantOption) {
        if (permissionsWithGrantOption == null) {
            this.permissionsWithGrantOption = null;
            return;
        }
        this.permissionsWithGrantOption = new ArrayList<String>(permissionsWithGrantOption);
    }

    public PrincipalResourcePermissions withPermissionsWithGrantOption(String ... permissionsWithGrantOption) {
        if (this.permissionsWithGrantOption == null) {
            this.setPermissionsWithGrantOption(new ArrayList<String>(permissionsWithGrantOption.length));
        }
        for (String ele : permissionsWithGrantOption) {
            this.permissionsWithGrantOption.add(ele);
        }
        return this;
    }

    public PrincipalResourcePermissions withPermissionsWithGrantOption(Collection<String> permissionsWithGrantOption) {
        this.setPermissionsWithGrantOption(permissionsWithGrantOption);
        return this;
    }

    public PrincipalResourcePermissions withPermissionsWithGrantOption(Permission ... permissionsWithGrantOption) {
        ArrayList<String> permissionsWithGrantOptionCopy = new ArrayList<String>(permissionsWithGrantOption.length);
        for (Permission value : permissionsWithGrantOption) {
            permissionsWithGrantOptionCopy.add(value.toString());
        }
        if (this.getPermissionsWithGrantOption() == null) {
            this.setPermissionsWithGrantOption(permissionsWithGrantOptionCopy);
        } else {
            this.getPermissionsWithGrantOption().addAll(permissionsWithGrantOptionCopy);
        }
        return this;
    }

    public void setAdditionalDetails(DetailsMap additionalDetails) {
        this.additionalDetails = additionalDetails;
    }

    public DetailsMap getAdditionalDetails() {
        return this.additionalDetails;
    }

    public PrincipalResourcePermissions withAdditionalDetails(DetailsMap additionalDetails) {
        this.setAdditionalDetails(additionalDetails);
        return this;
    }

    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public PrincipalResourcePermissions withLastUpdated(Date lastUpdated) {
        this.setLastUpdated(lastUpdated);
        return this;
    }

    public void setLastUpdatedBy(String lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public String getLastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public PrincipalResourcePermissions withLastUpdatedBy(String lastUpdatedBy) {
        this.setLastUpdatedBy(lastUpdatedBy);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPrincipal() != null) {
            sb.append("Principal: ").append(this.getPrincipal()).append(",");
        }
        if (this.getResource() != null) {
            sb.append("Resource: ").append(this.getResource()).append(",");
        }
        if (this.getPermissions() != null) {
            sb.append("Permissions: ").append(this.getPermissions()).append(",");
        }
        if (this.getPermissionsWithGrantOption() != null) {
            sb.append("PermissionsWithGrantOption: ").append(this.getPermissionsWithGrantOption()).append(",");
        }
        if (this.getAdditionalDetails() != null) {
            sb.append("AdditionalDetails: ").append(this.getAdditionalDetails()).append(",");
        }
        if (this.getLastUpdated() != null) {
            sb.append("LastUpdated: ").append(this.getLastUpdated()).append(",");
        }
        if (this.getLastUpdatedBy() != null) {
            sb.append("LastUpdatedBy: ").append(this.getLastUpdatedBy());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrincipalResourcePermissions)) {
            return false;
        }
        PrincipalResourcePermissions other = (PrincipalResourcePermissions)obj;
        if (other.getPrincipal() == null ^ this.getPrincipal() == null) {
            return false;
        }
        if (other.getPrincipal() != null && !other.getPrincipal().equals(this.getPrincipal())) {
            return false;
        }
        if (other.getResource() == null ^ this.getResource() == null) {
            return false;
        }
        if (other.getResource() != null && !other.getResource().equals(this.getResource())) {
            return false;
        }
        if (other.getPermissions() == null ^ this.getPermissions() == null) {
            return false;
        }
        if (other.getPermissions() != null && !other.getPermissions().equals(this.getPermissions())) {
            return false;
        }
        if (other.getPermissionsWithGrantOption() == null ^ this.getPermissionsWithGrantOption() == null) {
            return false;
        }
        if (other.getPermissionsWithGrantOption() != null && !other.getPermissionsWithGrantOption().equals(this.getPermissionsWithGrantOption())) {
            return false;
        }
        if (other.getAdditionalDetails() == null ^ this.getAdditionalDetails() == null) {
            return false;
        }
        if (other.getAdditionalDetails() != null && !other.getAdditionalDetails().equals(this.getAdditionalDetails())) {
            return false;
        }
        if (other.getLastUpdated() == null ^ this.getLastUpdated() == null) {
            return false;
        }
        if (other.getLastUpdated() != null && !other.getLastUpdated().equals(this.getLastUpdated())) {
            return false;
        }
        if (other.getLastUpdatedBy() == null ^ this.getLastUpdatedBy() == null) {
            return false;
        }
        return other.getLastUpdatedBy() == null || other.getLastUpdatedBy().equals(this.getLastUpdatedBy());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPrincipal() == null ? 0 : this.getPrincipal().hashCode());
        hashCode = 31 * hashCode + (this.getResource() == null ? 0 : this.getResource().hashCode());
        hashCode = 31 * hashCode + (this.getPermissions() == null ? 0 : this.getPermissions().hashCode());
        hashCode = 31 * hashCode + (this.getPermissionsWithGrantOption() == null ? 0 : this.getPermissionsWithGrantOption().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalDetails() == null ? 0 : this.getAdditionalDetails().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdated() == null ? 0 : this.getLastUpdated().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdatedBy() == null ? 0 : this.getLastUpdatedBy().hashCode());
        return hashCode;
    }

    public PrincipalResourcePermissions clone() {
        try {
            return (PrincipalResourcePermissions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PrincipalResourcePermissionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

