/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalyticsv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kinesisanalyticsv2.model.ApplicationCodeConfiguration;
import com.amazonaws.services.kinesisanalyticsv2.model.ApplicationSnapshotConfiguration;
import com.amazonaws.services.kinesisanalyticsv2.model.ApplicationSystemRollbackConfiguration;
import com.amazonaws.services.kinesisanalyticsv2.model.EnvironmentProperties;
import com.amazonaws.services.kinesisanalyticsv2.model.FlinkApplicationConfiguration;
import com.amazonaws.services.kinesisanalyticsv2.model.SqlApplicationConfiguration;
import com.amazonaws.services.kinesisanalyticsv2.model.VpcConfiguration;
import com.amazonaws.services.kinesisanalyticsv2.model.ZeppelinApplicationConfiguration;
import com.amazonaws.services.kinesisanalyticsv2.model.transform.ApplicationConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ApplicationConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private SqlApplicationConfiguration sqlApplicationConfiguration;
    private FlinkApplicationConfiguration flinkApplicationConfiguration;
    private EnvironmentProperties environmentProperties;
    private ApplicationCodeConfiguration applicationCodeConfiguration;
    private ApplicationSnapshotConfiguration applicationSnapshotConfiguration;
    private ApplicationSystemRollbackConfiguration applicationSystemRollbackConfiguration;
    private List<VpcConfiguration> vpcConfigurations;
    private ZeppelinApplicationConfiguration zeppelinApplicationConfiguration;

    public void setSqlApplicationConfiguration(SqlApplicationConfiguration sqlApplicationConfiguration) {
        this.sqlApplicationConfiguration = sqlApplicationConfiguration;
    }

    public SqlApplicationConfiguration getSqlApplicationConfiguration() {
        return this.sqlApplicationConfiguration;
    }

    public ApplicationConfiguration withSqlApplicationConfiguration(SqlApplicationConfiguration sqlApplicationConfiguration) {
        this.setSqlApplicationConfiguration(sqlApplicationConfiguration);
        return this;
    }

    public void setFlinkApplicationConfiguration(FlinkApplicationConfiguration flinkApplicationConfiguration) {
        this.flinkApplicationConfiguration = flinkApplicationConfiguration;
    }

    public FlinkApplicationConfiguration getFlinkApplicationConfiguration() {
        return this.flinkApplicationConfiguration;
    }

    public ApplicationConfiguration withFlinkApplicationConfiguration(FlinkApplicationConfiguration flinkApplicationConfiguration) {
        this.setFlinkApplicationConfiguration(flinkApplicationConfiguration);
        return this;
    }

    public void setEnvironmentProperties(EnvironmentProperties environmentProperties) {
        this.environmentProperties = environmentProperties;
    }

    public EnvironmentProperties getEnvironmentProperties() {
        return this.environmentProperties;
    }

    public ApplicationConfiguration withEnvironmentProperties(EnvironmentProperties environmentProperties) {
        this.setEnvironmentProperties(environmentProperties);
        return this;
    }

    public void setApplicationCodeConfiguration(ApplicationCodeConfiguration applicationCodeConfiguration) {
        this.applicationCodeConfiguration = applicationCodeConfiguration;
    }

    public ApplicationCodeConfiguration getApplicationCodeConfiguration() {
        return this.applicationCodeConfiguration;
    }

    public ApplicationConfiguration withApplicationCodeConfiguration(ApplicationCodeConfiguration applicationCodeConfiguration) {
        this.setApplicationCodeConfiguration(applicationCodeConfiguration);
        return this;
    }

    public void setApplicationSnapshotConfiguration(ApplicationSnapshotConfiguration applicationSnapshotConfiguration) {
        this.applicationSnapshotConfiguration = applicationSnapshotConfiguration;
    }

    public ApplicationSnapshotConfiguration getApplicationSnapshotConfiguration() {
        return this.applicationSnapshotConfiguration;
    }

    public ApplicationConfiguration withApplicationSnapshotConfiguration(ApplicationSnapshotConfiguration applicationSnapshotConfiguration) {
        this.setApplicationSnapshotConfiguration(applicationSnapshotConfiguration);
        return this;
    }

    public void setApplicationSystemRollbackConfiguration(ApplicationSystemRollbackConfiguration applicationSystemRollbackConfiguration) {
        this.applicationSystemRollbackConfiguration = applicationSystemRollbackConfiguration;
    }

    public ApplicationSystemRollbackConfiguration getApplicationSystemRollbackConfiguration() {
        return this.applicationSystemRollbackConfiguration;
    }

    public ApplicationConfiguration withApplicationSystemRollbackConfiguration(ApplicationSystemRollbackConfiguration applicationSystemRollbackConfiguration) {
        this.setApplicationSystemRollbackConfiguration(applicationSystemRollbackConfiguration);
        return this;
    }

    public List<VpcConfiguration> getVpcConfigurations() {
        return this.vpcConfigurations;
    }

    public void setVpcConfigurations(Collection<VpcConfiguration> vpcConfigurations) {
        if (vpcConfigurations == null) {
            this.vpcConfigurations = null;
            return;
        }
        this.vpcConfigurations = new ArrayList<VpcConfiguration>(vpcConfigurations);
    }

    public ApplicationConfiguration withVpcConfigurations(VpcConfiguration ... vpcConfigurations) {
        if (this.vpcConfigurations == null) {
            this.setVpcConfigurations(new ArrayList<VpcConfiguration>(vpcConfigurations.length));
        }
        for (VpcConfiguration ele : vpcConfigurations) {
            this.vpcConfigurations.add(ele);
        }
        return this;
    }

    public ApplicationConfiguration withVpcConfigurations(Collection<VpcConfiguration> vpcConfigurations) {
        this.setVpcConfigurations(vpcConfigurations);
        return this;
    }

    public void setZeppelinApplicationConfiguration(ZeppelinApplicationConfiguration zeppelinApplicationConfiguration) {
        this.zeppelinApplicationConfiguration = zeppelinApplicationConfiguration;
    }

    public ZeppelinApplicationConfiguration getZeppelinApplicationConfiguration() {
        return this.zeppelinApplicationConfiguration;
    }

    public ApplicationConfiguration withZeppelinApplicationConfiguration(ZeppelinApplicationConfiguration zeppelinApplicationConfiguration) {
        this.setZeppelinApplicationConfiguration(zeppelinApplicationConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSqlApplicationConfiguration() != null) {
            sb.append("SqlApplicationConfiguration: ").append(this.getSqlApplicationConfiguration()).append(",");
        }
        if (this.getFlinkApplicationConfiguration() != null) {
            sb.append("FlinkApplicationConfiguration: ").append(this.getFlinkApplicationConfiguration()).append(",");
        }
        if (this.getEnvironmentProperties() != null) {
            sb.append("EnvironmentProperties: ").append(this.getEnvironmentProperties()).append(",");
        }
        if (this.getApplicationCodeConfiguration() != null) {
            sb.append("ApplicationCodeConfiguration: ").append(this.getApplicationCodeConfiguration()).append(",");
        }
        if (this.getApplicationSnapshotConfiguration() != null) {
            sb.append("ApplicationSnapshotConfiguration: ").append(this.getApplicationSnapshotConfiguration()).append(",");
        }
        if (this.getApplicationSystemRollbackConfiguration() != null) {
            sb.append("ApplicationSystemRollbackConfiguration: ").append(this.getApplicationSystemRollbackConfiguration()).append(",");
        }
        if (this.getVpcConfigurations() != null) {
            sb.append("VpcConfigurations: ").append(this.getVpcConfigurations()).append(",");
        }
        if (this.getZeppelinApplicationConfiguration() != null) {
            sb.append("ZeppelinApplicationConfiguration: ").append(this.getZeppelinApplicationConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationConfiguration)) {
            return false;
        }
        ApplicationConfiguration other = (ApplicationConfiguration)obj;
        if (other.getSqlApplicationConfiguration() == null ^ this.getSqlApplicationConfiguration() == null) {
            return false;
        }
        if (other.getSqlApplicationConfiguration() != null && !other.getSqlApplicationConfiguration().equals(this.getSqlApplicationConfiguration())) {
            return false;
        }
        if (other.getFlinkApplicationConfiguration() == null ^ this.getFlinkApplicationConfiguration() == null) {
            return false;
        }
        if (other.getFlinkApplicationConfiguration() != null && !other.getFlinkApplicationConfiguration().equals(this.getFlinkApplicationConfiguration())) {
            return false;
        }
        if (other.getEnvironmentProperties() == null ^ this.getEnvironmentProperties() == null) {
            return false;
        }
        if (other.getEnvironmentProperties() != null && !other.getEnvironmentProperties().equals(this.getEnvironmentProperties())) {
            return false;
        }
        if (other.getApplicationCodeConfiguration() == null ^ this.getApplicationCodeConfiguration() == null) {
            return false;
        }
        if (other.getApplicationCodeConfiguration() != null && !other.getApplicationCodeConfiguration().equals(this.getApplicationCodeConfiguration())) {
            return false;
        }
        if (other.getApplicationSnapshotConfiguration() == null ^ this.getApplicationSnapshotConfiguration() == null) {
            return false;
        }
        if (other.getApplicationSnapshotConfiguration() != null && !other.getApplicationSnapshotConfiguration().equals(this.getApplicationSnapshotConfiguration())) {
            return false;
        }
        if (other.getApplicationSystemRollbackConfiguration() == null ^ this.getApplicationSystemRollbackConfiguration() == null) {
            return false;
        }
        if (other.getApplicationSystemRollbackConfiguration() != null && !other.getApplicationSystemRollbackConfiguration().equals(this.getApplicationSystemRollbackConfiguration())) {
            return false;
        }
        if (other.getVpcConfigurations() == null ^ this.getVpcConfigurations() == null) {
            return false;
        }
        if (other.getVpcConfigurations() != null && !other.getVpcConfigurations().equals(this.getVpcConfigurations())) {
            return false;
        }
        if (other.getZeppelinApplicationConfiguration() == null ^ this.getZeppelinApplicationConfiguration() == null) {
            return false;
        }
        return other.getZeppelinApplicationConfiguration() == null || other.getZeppelinApplicationConfiguration().equals(this.getZeppelinApplicationConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSqlApplicationConfiguration() == null ? 0 : this.getSqlApplicationConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getFlinkApplicationConfiguration() == null ? 0 : this.getFlinkApplicationConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironmentProperties() == null ? 0 : this.getEnvironmentProperties().hashCode());
        hashCode = 31 * hashCode + (this.getApplicationCodeConfiguration() == null ? 0 : this.getApplicationCodeConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getApplicationSnapshotConfiguration() == null ? 0 : this.getApplicationSnapshotConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getApplicationSystemRollbackConfiguration() == null ? 0 : this.getApplicationSystemRollbackConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getVpcConfigurations() == null ? 0 : this.getVpcConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getZeppelinApplicationConfiguration() == null ? 0 : this.getZeppelinApplicationConfiguration().hashCode());
        return hashCode;
    }

    public ApplicationConfiguration clone() {
        try {
            return (ApplicationConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ApplicationConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

