/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ivsrealtime.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.ivsrealtime.model.ParticipantToken;
import java.util.Date;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class ParticipantTokenMarshaller {
    private static final MarshallingInfo<String> PARTICIPANTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("participantId").build();
    private static final MarshallingInfo<String> TOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("token").build();
    private static final MarshallingInfo<String> USERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("userId").build();
    private static final MarshallingInfo<Map> ATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attributes").build();
    private static final MarshallingInfo<Integer> DURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("duration").build();
    private static final MarshallingInfo<List> CAPABILITIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("capabilities").build();
    private static final MarshallingInfo<Date> EXPIRATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("expirationTime").timestampFormat("iso8601").build();
    private static final ParticipantTokenMarshaller instance = new ParticipantTokenMarshaller();

    public static ParticipantTokenMarshaller getInstance() {
        return instance;
    }

    public void marshall(ParticipantToken participantToken, ProtocolMarshaller protocolMarshaller) {
        if (participantToken == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)participantToken.getParticipantId(), PARTICIPANTID_BINDING);
            protocolMarshaller.marshall((Object)participantToken.getToken(), TOKEN_BINDING);
            protocolMarshaller.marshall((Object)participantToken.getUserId(), USERID_BINDING);
            protocolMarshaller.marshall(participantToken.getAttributes(), ATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)participantToken.getDuration(), DURATION_BINDING);
            protocolMarshaller.marshall(participantToken.getCapabilities(), CAPABILITIES_BINDING);
            protocolMarshaller.marshall((Object)participantToken.getExpirationTime(), EXPIRATIONTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

