/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.identitystore.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/ListUsers" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListUsersRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The globally unique identifier for the identity store, such as <code>d-1234567890</code>. In this example,
     * <code>d-</code> is a fixed prefix, and <code>1234567890</code> is a randomly generated string that contains
     * numbers and lower case letters. This value is generated at the time that a new identity store is created.
     * </p>
     */
    private String identityStoreId;
    /**
     * <p>
     * The maximum number of results to be returned per request. This parameter is used in the <code>ListUsers</code>
     * and <code>ListGroups</code> requests to specify how many results to return in one page. The length limit is 50
     * characters.
     * </p>
     */
    private Integer maxResults;
    /**
     * <p>
     * The pagination token used for the <code>ListUsers</code> and <code>ListGroups</code> API operations. This value
     * is generated by the identity store service. It is returned in the API response if the total results are more than
     * the size of one page. This token is also returned when it is used in the API request to search for the next page.
     * </p>
     */
    private String nextToken;
    /**
     * <p>
     * A list of <code>Filter</code> objects, which is used in the <code>ListUsers</code> and <code>ListGroups</code>
     * requests.
     * </p>
     */
    @Deprecated
    private java.util.List<Filter> filters;

    /**
     * <p>
     * The globally unique identifier for the identity store, such as <code>d-1234567890</code>. In this example,
     * <code>d-</code> is a fixed prefix, and <code>1234567890</code> is a randomly generated string that contains
     * numbers and lower case letters. This value is generated at the time that a new identity store is created.
     * </p>
     * 
     * @param identityStoreId
     *        The globally unique identifier for the identity store, such as <code>d-1234567890</code>. In this example,
     *        <code>d-</code> is a fixed prefix, and <code>1234567890</code> is a randomly generated string that
     *        contains numbers and lower case letters. This value is generated at the time that a new identity store is
     *        created.
     */

    public void setIdentityStoreId(String identityStoreId) {
        this.identityStoreId = identityStoreId;
    }

    /**
     * <p>
     * The globally unique identifier for the identity store, such as <code>d-1234567890</code>. In this example,
     * <code>d-</code> is a fixed prefix, and <code>1234567890</code> is a randomly generated string that contains
     * numbers and lower case letters. This value is generated at the time that a new identity store is created.
     * </p>
     * 
     * @return The globally unique identifier for the identity store, such as <code>d-1234567890</code>. In this
     *         example, <code>d-</code> is a fixed prefix, and <code>1234567890</code> is a randomly generated string
     *         that contains numbers and lower case letters. This value is generated at the time that a new identity
     *         store is created.
     */

    public String getIdentityStoreId() {
        return this.identityStoreId;
    }

    /**
     * <p>
     * The globally unique identifier for the identity store, such as <code>d-1234567890</code>. In this example,
     * <code>d-</code> is a fixed prefix, and <code>1234567890</code> is a randomly generated string that contains
     * numbers and lower case letters. This value is generated at the time that a new identity store is created.
     * </p>
     * 
     * @param identityStoreId
     *        The globally unique identifier for the identity store, such as <code>d-1234567890</code>. In this example,
     *        <code>d-</code> is a fixed prefix, and <code>1234567890</code> is a randomly generated string that
     *        contains numbers and lower case letters. This value is generated at the time that a new identity store is
     *        created.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListUsersRequest withIdentityStoreId(String identityStoreId) {
        setIdentityStoreId(identityStoreId);
        return this;
    }

    /**
     * <p>
     * The maximum number of results to be returned per request. This parameter is used in the <code>ListUsers</code>
     * and <code>ListGroups</code> requests to specify how many results to return in one page. The length limit is 50
     * characters.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of results to be returned per request. This parameter is used in the
     *        <code>ListUsers</code> and <code>ListGroups</code> requests to specify how many results to return in one
     *        page. The length limit is 50 characters.
     */

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    /**
     * <p>
     * The maximum number of results to be returned per request. This parameter is used in the <code>ListUsers</code>
     * and <code>ListGroups</code> requests to specify how many results to return in one page. The length limit is 50
     * characters.
     * </p>
     * 
     * @return The maximum number of results to be returned per request. This parameter is used in the
     *         <code>ListUsers</code> and <code>ListGroups</code> requests to specify how many results to return in one
     *         page. The length limit is 50 characters.
     */

    public Integer getMaxResults() {
        return this.maxResults;
    }

    /**
     * <p>
     * The maximum number of results to be returned per request. This parameter is used in the <code>ListUsers</code>
     * and <code>ListGroups</code> requests to specify how many results to return in one page. The length limit is 50
     * characters.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of results to be returned per request. This parameter is used in the
     *        <code>ListUsers</code> and <code>ListGroups</code> requests to specify how many results to return in one
     *        page. The length limit is 50 characters.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListUsersRequest withMaxResults(Integer maxResults) {
        setMaxResults(maxResults);
        return this;
    }

    /**
     * <p>
     * The pagination token used for the <code>ListUsers</code> and <code>ListGroups</code> API operations. This value
     * is generated by the identity store service. It is returned in the API response if the total results are more than
     * the size of one page. This token is also returned when it is used in the API request to search for the next page.
     * </p>
     * 
     * @param nextToken
     *        The pagination token used for the <code>ListUsers</code> and <code>ListGroups</code> API operations. This
     *        value is generated by the identity store service. It is returned in the API response if the total results
     *        are more than the size of one page. This token is also returned when it is used in the API request to
     *        search for the next page.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * The pagination token used for the <code>ListUsers</code> and <code>ListGroups</code> API operations. This value
     * is generated by the identity store service. It is returned in the API response if the total results are more than
     * the size of one page. This token is also returned when it is used in the API request to search for the next page.
     * </p>
     * 
     * @return The pagination token used for the <code>ListUsers</code> and <code>ListGroups</code> API operations. This
     *         value is generated by the identity store service. It is returned in the API response if the total results
     *         are more than the size of one page. This token is also returned when it is used in the API request to
     *         search for the next page.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * The pagination token used for the <code>ListUsers</code> and <code>ListGroups</code> API operations. This value
     * is generated by the identity store service. It is returned in the API response if the total results are more than
     * the size of one page. This token is also returned when it is used in the API request to search for the next page.
     * </p>
     * 
     * @param nextToken
     *        The pagination token used for the <code>ListUsers</code> and <code>ListGroups</code> API operations. This
     *        value is generated by the identity store service. It is returned in the API response if the total results
     *        are more than the size of one page. This token is also returned when it is used in the API request to
     *        search for the next page.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListUsersRequest withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * <p>
     * A list of <code>Filter</code> objects, which is used in the <code>ListUsers</code> and <code>ListGroups</code>
     * requests.
     * </p>
     * 
     * @return A list of <code>Filter</code> objects, which is used in the <code>ListUsers</code> and
     *         <code>ListGroups</code> requests.
     */
    @Deprecated
    public java.util.List<Filter> getFilters() {
        return filters;
    }

    /**
     * <p>
     * A list of <code>Filter</code> objects, which is used in the <code>ListUsers</code> and <code>ListGroups</code>
     * requests.
     * </p>
     * 
     * @param filters
     *        A list of <code>Filter</code> objects, which is used in the <code>ListUsers</code> and
     *        <code>ListGroups</code> requests.
     */
    @Deprecated
    public void setFilters(java.util.Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }

        this.filters = new java.util.ArrayList<Filter>(filters);
    }

    /**
     * <p>
     * A list of <code>Filter</code> objects, which is used in the <code>ListUsers</code> and <code>ListGroups</code>
     * requests.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setFilters(java.util.Collection)} or {@link #withFilters(java.util.Collection)} if you want to override
     * the existing values.
     * </p>
     * 
     * @param filters
     *        A list of <code>Filter</code> objects, which is used in the <code>ListUsers</code> and
     *        <code>ListGroups</code> requests.
     * @return Returns a reference to this object so that method calls can be chained together.
     */
    @Deprecated
    public ListUsersRequest withFilters(Filter... filters) {
        if (this.filters == null) {
            setFilters(new java.util.ArrayList<Filter>(filters.length));
        }
        for (Filter ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of <code>Filter</code> objects, which is used in the <code>ListUsers</code> and <code>ListGroups</code>
     * requests.
     * </p>
     * 
     * @param filters
     *        A list of <code>Filter</code> objects, which is used in the <code>ListUsers</code> and
     *        <code>ListGroups</code> requests.
     * @return Returns a reference to this object so that method calls can be chained together.
     */
    @Deprecated
    public ListUsersRequest withFilters(java.util.Collection<Filter> filters) {
        setFilters(filters);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getIdentityStoreId() != null)
            sb.append("IdentityStoreId: ").append(getIdentityStoreId()).append(",");
        if (getMaxResults() != null)
            sb.append("MaxResults: ").append(getMaxResults()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken()).append(",");
        if (getFilters() != null)
            sb.append("Filters: ").append(getFilters());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListUsersRequest == false)
            return false;
        ListUsersRequest other = (ListUsersRequest) obj;
        if (other.getIdentityStoreId() == null ^ this.getIdentityStoreId() == null)
            return false;
        if (other.getIdentityStoreId() != null && other.getIdentityStoreId().equals(this.getIdentityStoreId()) == false)
            return false;
        if (other.getMaxResults() == null ^ this.getMaxResults() == null)
            return false;
        if (other.getMaxResults() != null && other.getMaxResults().equals(this.getMaxResults()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        if (other.getFilters() == null ^ this.getFilters() == null)
            return false;
        if (other.getFilters() != null && other.getFilters().equals(this.getFilters()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getIdentityStoreId() == null) ? 0 : getIdentityStoreId().hashCode());
        hashCode = prime * hashCode + ((getMaxResults() == null) ? 0 : getMaxResults().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        hashCode = prime * hashCode + ((getFilters() == null) ? 0 : getFilters().hashCode());
        return hashCode;
    }

    @Override
    public ListUsersRequest clone() {
        return (ListUsersRequest) super.clone();
    }

}
