/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.identitystore.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/ListGroupMemberships" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListGroupMembershipsResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * A list of <code>GroupMembership</code> objects in the group.
     * </p>
     */
    private java.util.List<GroupMembership> groupMemberships;
    /**
     * <p>
     * The pagination token used for the <code>ListUsers</code>, <code>ListGroups</code>, and
     * <code>ListGroupMemberships</code> API operations. This value is generated by the identity store service. It is
     * returned in the API response if the total results are more than the size of one page. This token is also returned
     * when it is used in the API request to search for the next page.
     * </p>
     */
    private String nextToken;

    /**
     * <p>
     * A list of <code>GroupMembership</code> objects in the group.
     * </p>
     * 
     * @return A list of <code>GroupMembership</code> objects in the group.
     */

    public java.util.List<GroupMembership> getGroupMemberships() {
        return groupMemberships;
    }

    /**
     * <p>
     * A list of <code>GroupMembership</code> objects in the group.
     * </p>
     * 
     * @param groupMemberships
     *        A list of <code>GroupMembership</code> objects in the group.
     */

    public void setGroupMemberships(java.util.Collection<GroupMembership> groupMemberships) {
        if (groupMemberships == null) {
            this.groupMemberships = null;
            return;
        }

        this.groupMemberships = new java.util.ArrayList<GroupMembership>(groupMemberships);
    }

    /**
     * <p>
     * A list of <code>GroupMembership</code> objects in the group.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setGroupMemberships(java.util.Collection)} or {@link #withGroupMemberships(java.util.Collection)} if you
     * want to override the existing values.
     * </p>
     * 
     * @param groupMemberships
     *        A list of <code>GroupMembership</code> objects in the group.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListGroupMembershipsResult withGroupMemberships(GroupMembership... groupMemberships) {
        if (this.groupMemberships == null) {
            setGroupMemberships(new java.util.ArrayList<GroupMembership>(groupMemberships.length));
        }
        for (GroupMembership ele : groupMemberships) {
            this.groupMemberships.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of <code>GroupMembership</code> objects in the group.
     * </p>
     * 
     * @param groupMemberships
     *        A list of <code>GroupMembership</code> objects in the group.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListGroupMembershipsResult withGroupMemberships(java.util.Collection<GroupMembership> groupMemberships) {
        setGroupMemberships(groupMemberships);
        return this;
    }

    /**
     * <p>
     * The pagination token used for the <code>ListUsers</code>, <code>ListGroups</code>, and
     * <code>ListGroupMemberships</code> API operations. This value is generated by the identity store service. It is
     * returned in the API response if the total results are more than the size of one page. This token is also returned
     * when it is used in the API request to search for the next page.
     * </p>
     * 
     * @param nextToken
     *        The pagination token used for the <code>ListUsers</code>, <code>ListGroups</code>, and
     *        <code>ListGroupMemberships</code> API operations. This value is generated by the identity store service.
     *        It is returned in the API response if the total results are more than the size of one page. This token is
     *        also returned when it is used in the API request to search for the next page.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * The pagination token used for the <code>ListUsers</code>, <code>ListGroups</code>, and
     * <code>ListGroupMemberships</code> API operations. This value is generated by the identity store service. It is
     * returned in the API response if the total results are more than the size of one page. This token is also returned
     * when it is used in the API request to search for the next page.
     * </p>
     * 
     * @return The pagination token used for the <code>ListUsers</code>, <code>ListGroups</code>, and
     *         <code>ListGroupMemberships</code> API operations. This value is generated by the identity store service.
     *         It is returned in the API response if the total results are more than the size of one page. This token is
     *         also returned when it is used in the API request to search for the next page.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * The pagination token used for the <code>ListUsers</code>, <code>ListGroups</code>, and
     * <code>ListGroupMemberships</code> API operations. This value is generated by the identity store service. It is
     * returned in the API response if the total results are more than the size of one page. This token is also returned
     * when it is used in the API request to search for the next page.
     * </p>
     * 
     * @param nextToken
     *        The pagination token used for the <code>ListUsers</code>, <code>ListGroups</code>, and
     *        <code>ListGroupMemberships</code> API operations. This value is generated by the identity store service.
     *        It is returned in the API response if the total results are more than the size of one page. This token is
     *        also returned when it is used in the API request to search for the next page.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListGroupMembershipsResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getGroupMemberships() != null)
            sb.append("GroupMemberships: ").append(getGroupMemberships()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListGroupMembershipsResult == false)
            return false;
        ListGroupMembershipsResult other = (ListGroupMembershipsResult) obj;
        if (other.getGroupMemberships() == null ^ this.getGroupMemberships() == null)
            return false;
        if (other.getGroupMemberships() != null && other.getGroupMemberships().equals(this.getGroupMemberships()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getGroupMemberships() == null) ? 0 : getGroupMemberships().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListGroupMembershipsResult clone() {
        try {
            return (ListGroupMembershipsResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
