/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.services.elasticbeanstalk.model.PlatformSummary;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class PlatformSummaryStaxUnmarshaller
implements Unmarshaller<PlatformSummary, StaxUnmarshallerContext> {
    private static PlatformSummaryStaxUnmarshaller instance;

    public PlatformSummary unmarshall(StaxUnmarshallerContext context) throws Exception {
        PlatformSummary platformSummary = new PlatformSummary();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return platformSummary;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("PlatformArn", targetDepth)) {
                    platformSummary.setPlatformArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PlatformOwner", targetDepth)) {
                    platformSummary.setPlatformOwner(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PlatformStatus", targetDepth)) {
                    platformSummary.setPlatformStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PlatformCategory", targetDepth)) {
                    platformSummary.setPlatformCategory(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("OperatingSystemName", targetDepth)) {
                    platformSummary.setOperatingSystemName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("OperatingSystemVersion", targetDepth)) {
                    platformSummary.setOperatingSystemVersion(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SupportedTierList", targetDepth)) {
                    platformSummary.withSupportedTierList(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("SupportedTierList/member", targetDepth)) {
                    platformSummary.withSupportedTierList(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SupportedAddonList", targetDepth)) {
                    platformSummary.withSupportedAddonList(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("SupportedAddonList/member", targetDepth)) {
                    platformSummary.withSupportedAddonList(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PlatformLifecycleState", targetDepth)) {
                    platformSummary.setPlatformLifecycleState(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PlatformVersion", targetDepth)) {
                    platformSummary.setPlatformVersion(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PlatformBranchName", targetDepth)) {
                    platformSummary.setPlatformBranchName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("PlatformBranchLifecycleState", targetDepth)) continue;
                platformSummary.setPlatformBranchLifecycleState(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return platformSummary;
    }

    public static PlatformSummaryStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new PlatformSummaryStaxUnmarshaller();
        }
        return instance;
    }
}

