/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datazone.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.datazone.model.NotificationResource;
import com.amazonaws.services.datazone.model.NotificationRole;
import com.amazonaws.services.datazone.model.transform.TopicMarshaller;
import java.io.Serializable;

public class Topic
implements Serializable,
Cloneable,
StructuredPojo {
    private NotificationResource resource;
    private String role;
    private String subject;

    public void setResource(NotificationResource resource) {
        this.resource = resource;
    }

    public NotificationResource getResource() {
        return this.resource;
    }

    public Topic withResource(NotificationResource resource) {
        this.setResource(resource);
        return this;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getRole() {
        return this.role;
    }

    public Topic withRole(String role) {
        this.setRole(role);
        return this;
    }

    public Topic withRole(NotificationRole role) {
        this.role = role.toString();
        return this;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getSubject() {
        return this.subject;
    }

    public Topic withSubject(String subject) {
        this.setSubject(subject);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResource() != null) {
            sb.append("Resource: ").append(this.getResource()).append(",");
        }
        if (this.getRole() != null) {
            sb.append("Role: ").append(this.getRole()).append(",");
        }
        if (this.getSubject() != null) {
            sb.append("Subject: ").append(this.getSubject());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Topic)) {
            return false;
        }
        Topic other = (Topic)obj;
        if (other.getResource() == null ^ this.getResource() == null) {
            return false;
        }
        if (other.getResource() != null && !other.getResource().equals(this.getResource())) {
            return false;
        }
        if (other.getRole() == null ^ this.getRole() == null) {
            return false;
        }
        if (other.getRole() != null && !other.getRole().equals(this.getRole())) {
            return false;
        }
        if (other.getSubject() == null ^ this.getSubject() == null) {
            return false;
        }
        return other.getSubject() == null || other.getSubject().equals(this.getSubject());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResource() == null ? 0 : this.getResource().hashCode());
        hashCode = 31 * hashCode + (this.getRole() == null ? 0 : this.getRole().hashCode());
        hashCode = 31 * hashCode + (this.getSubject() == null ? 0 : this.getSubject().hashCode());
        return hashCode;
    }

    public Topic clone() {
        try {
            return (Topic)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TopicMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

