/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.computeoptimizer.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Describes the projected metrics of an Amazon RDS recommendation option.
 * </p>
 * <p>
 * To determine the performance difference between your current Amazon RDS and the recommended option, compare the
 * metric data of your service against its projected metric data.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/RDSDatabaseProjectedMetric"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class RDSDatabaseProjectedMetric implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The name of the projected metric.
     * </p>
     */
    private String name;
    /**
     * <p>
     * The timestamps of the projected metric.
     * </p>
     */
    private java.util.List<java.util.Date> timestamps;
    /**
     * <p>
     * The values for the projected metric.
     * </p>
     */
    private java.util.List<Double> values;

    /**
     * <p>
     * The name of the projected metric.
     * </p>
     * 
     * @param name
     *        The name of the projected metric.
     * @see RDSDBMetricName
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * The name of the projected metric.
     * </p>
     * 
     * @return The name of the projected metric.
     * @see RDSDBMetricName
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * The name of the projected metric.
     * </p>
     * 
     * @param name
     *        The name of the projected metric.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see RDSDBMetricName
     */

    public RDSDatabaseProjectedMetric withName(String name) {
        setName(name);
        return this;
    }

    /**
     * <p>
     * The name of the projected metric.
     * </p>
     * 
     * @param name
     *        The name of the projected metric.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see RDSDBMetricName
     */

    public RDSDatabaseProjectedMetric withName(RDSDBMetricName name) {
        this.name = name.toString();
        return this;
    }

    /**
     * <p>
     * The timestamps of the projected metric.
     * </p>
     * 
     * @return The timestamps of the projected metric.
     */

    public java.util.List<java.util.Date> getTimestamps() {
        return timestamps;
    }

    /**
     * <p>
     * The timestamps of the projected metric.
     * </p>
     * 
     * @param timestamps
     *        The timestamps of the projected metric.
     */

    public void setTimestamps(java.util.Collection<java.util.Date> timestamps) {
        if (timestamps == null) {
            this.timestamps = null;
            return;
        }

        this.timestamps = new java.util.ArrayList<java.util.Date>(timestamps);
    }

    /**
     * <p>
     * The timestamps of the projected metric.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setTimestamps(java.util.Collection)} or {@link #withTimestamps(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param timestamps
     *        The timestamps of the projected metric.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RDSDatabaseProjectedMetric withTimestamps(java.util.Date... timestamps) {
        if (this.timestamps == null) {
            setTimestamps(new java.util.ArrayList<java.util.Date>(timestamps.length));
        }
        for (java.util.Date ele : timestamps) {
            this.timestamps.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The timestamps of the projected metric.
     * </p>
     * 
     * @param timestamps
     *        The timestamps of the projected metric.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RDSDatabaseProjectedMetric withTimestamps(java.util.Collection<java.util.Date> timestamps) {
        setTimestamps(timestamps);
        return this;
    }

    /**
     * <p>
     * The values for the projected metric.
     * </p>
     * 
     * @return The values for the projected metric.
     */

    public java.util.List<Double> getValues() {
        return values;
    }

    /**
     * <p>
     * The values for the projected metric.
     * </p>
     * 
     * @param values
     *        The values for the projected metric.
     */

    public void setValues(java.util.Collection<Double> values) {
        if (values == null) {
            this.values = null;
            return;
        }

        this.values = new java.util.ArrayList<Double>(values);
    }

    /**
     * <p>
     * The values for the projected metric.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setValues(java.util.Collection)} or {@link #withValues(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param values
     *        The values for the projected metric.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RDSDatabaseProjectedMetric withValues(Double... values) {
        if (this.values == null) {
            setValues(new java.util.ArrayList<Double>(values.length));
        }
        for (Double ele : values) {
            this.values.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The values for the projected metric.
     * </p>
     * 
     * @param values
     *        The values for the projected metric.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RDSDatabaseProjectedMetric withValues(java.util.Collection<Double> values) {
        setValues(values);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getName() != null)
            sb.append("Name: ").append(getName()).append(",");
        if (getTimestamps() != null)
            sb.append("Timestamps: ").append(getTimestamps()).append(",");
        if (getValues() != null)
            sb.append("Values: ").append(getValues());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof RDSDatabaseProjectedMetric == false)
            return false;
        RDSDatabaseProjectedMetric other = (RDSDatabaseProjectedMetric) obj;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getTimestamps() == null ^ this.getTimestamps() == null)
            return false;
        if (other.getTimestamps() != null && other.getTimestamps().equals(this.getTimestamps()) == false)
            return false;
        if (other.getValues() == null ^ this.getValues() == null)
            return false;
        if (other.getValues() != null && other.getValues().equals(this.getValues()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime * hashCode + ((getTimestamps() == null) ? 0 : getTimestamps().hashCode());
        hashCode = prime * hashCode + ((getValues() == null) ? 0 : getValues().hashCode());
        return hashCode;
    }

    @Override
    public RDSDatabaseProjectedMetric clone() {
        try {
            return (RDSDatabaseProjectedMetric) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.computeoptimizer.model.transform.RDSDatabaseProjectedMetricMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
