/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.cloudwatchrum.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/rum-2018-05-10/PutRumMetricsDestination" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class PutRumMetricsDestinationRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The name of the CloudWatch RUM app monitor that will send the metrics.
     * </p>
     */
    private String appMonitorName;
    /**
     * <p>
     * Defines the destination to send the metrics to. Valid values are <code>CloudWatch</code> and
     * <code>Evidently</code>. If you specify <code>Evidently</code>, you must also specify the ARN of the
     * CloudWatchEvidently experiment that is to be the destination and an IAM role that has permission to write to the
     * experiment.
     * </p>
     */
    private String destination;
    /**
     * <p>
     * Use this parameter only if <code>Destination</code> is <code>Evidently</code>. This parameter specifies the ARN
     * of the Evidently experiment that will receive the extended metrics.
     * </p>
     */
    private String destinationArn;
    /**
     * <p>
     * This parameter is required if <code>Destination</code> is <code>Evidently</code>. If <code>Destination</code> is
     * <code>CloudWatch</code>, don't use this parameter.
     * </p>
     * <p>
     * This parameter specifies the ARN of an IAM role that RUM will assume to write to the Evidently experiment that
     * you are sending metrics to. This role must have permission to write to that experiment.
     * </p>
     * <p>
     * If you specify this parameter, you must be signed on to a role that has <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">PassRole</a> permissions
     * attached to it, to allow the role to be passed. The <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/auth-and-access-control-cw.html#managed-policies-cloudwatch-RUM"
     * > CloudWatchAmazonCloudWatchRUMFullAccess</a> policy doesn't include <code>PassRole</code> permissions.
     * </p>
     */
    private String iamRoleArn;

    /**
     * <p>
     * The name of the CloudWatch RUM app monitor that will send the metrics.
     * </p>
     * 
     * @param appMonitorName
     *        The name of the CloudWatch RUM app monitor that will send the metrics.
     */

    public void setAppMonitorName(String appMonitorName) {
        this.appMonitorName = appMonitorName;
    }

    /**
     * <p>
     * The name of the CloudWatch RUM app monitor that will send the metrics.
     * </p>
     * 
     * @return The name of the CloudWatch RUM app monitor that will send the metrics.
     */

    public String getAppMonitorName() {
        return this.appMonitorName;
    }

    /**
     * <p>
     * The name of the CloudWatch RUM app monitor that will send the metrics.
     * </p>
     * 
     * @param appMonitorName
     *        The name of the CloudWatch RUM app monitor that will send the metrics.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PutRumMetricsDestinationRequest withAppMonitorName(String appMonitorName) {
        setAppMonitorName(appMonitorName);
        return this;
    }

    /**
     * <p>
     * Defines the destination to send the metrics to. Valid values are <code>CloudWatch</code> and
     * <code>Evidently</code>. If you specify <code>Evidently</code>, you must also specify the ARN of the
     * CloudWatchEvidently experiment that is to be the destination and an IAM role that has permission to write to the
     * experiment.
     * </p>
     * 
     * @param destination
     *        Defines the destination to send the metrics to. Valid values are <code>CloudWatch</code> and
     *        <code>Evidently</code>. If you specify <code>Evidently</code>, you must also specify the ARN of the
     *        CloudWatchEvidently experiment that is to be the destination and an IAM role that has permission to write
     *        to the experiment.
     * @see MetricDestination
     */

    public void setDestination(String destination) {
        this.destination = destination;
    }

    /**
     * <p>
     * Defines the destination to send the metrics to. Valid values are <code>CloudWatch</code> and
     * <code>Evidently</code>. If you specify <code>Evidently</code>, you must also specify the ARN of the
     * CloudWatchEvidently experiment that is to be the destination and an IAM role that has permission to write to the
     * experiment.
     * </p>
     * 
     * @return Defines the destination to send the metrics to. Valid values are <code>CloudWatch</code> and
     *         <code>Evidently</code>. If you specify <code>Evidently</code>, you must also specify the ARN of the
     *         CloudWatchEvidently experiment that is to be the destination and an IAM role that has permission to write
     *         to the experiment.
     * @see MetricDestination
     */

    public String getDestination() {
        return this.destination;
    }

    /**
     * <p>
     * Defines the destination to send the metrics to. Valid values are <code>CloudWatch</code> and
     * <code>Evidently</code>. If you specify <code>Evidently</code>, you must also specify the ARN of the
     * CloudWatchEvidently experiment that is to be the destination and an IAM role that has permission to write to the
     * experiment.
     * </p>
     * 
     * @param destination
     *        Defines the destination to send the metrics to. Valid values are <code>CloudWatch</code> and
     *        <code>Evidently</code>. If you specify <code>Evidently</code>, you must also specify the ARN of the
     *        CloudWatchEvidently experiment that is to be the destination and an IAM role that has permission to write
     *        to the experiment.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see MetricDestination
     */

    public PutRumMetricsDestinationRequest withDestination(String destination) {
        setDestination(destination);
        return this;
    }

    /**
     * <p>
     * Defines the destination to send the metrics to. Valid values are <code>CloudWatch</code> and
     * <code>Evidently</code>. If you specify <code>Evidently</code>, you must also specify the ARN of the
     * CloudWatchEvidently experiment that is to be the destination and an IAM role that has permission to write to the
     * experiment.
     * </p>
     * 
     * @param destination
     *        Defines the destination to send the metrics to. Valid values are <code>CloudWatch</code> and
     *        <code>Evidently</code>. If you specify <code>Evidently</code>, you must also specify the ARN of the
     *        CloudWatchEvidently experiment that is to be the destination and an IAM role that has permission to write
     *        to the experiment.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see MetricDestination
     */

    public PutRumMetricsDestinationRequest withDestination(MetricDestination destination) {
        this.destination = destination.toString();
        return this;
    }

    /**
     * <p>
     * Use this parameter only if <code>Destination</code> is <code>Evidently</code>. This parameter specifies the ARN
     * of the Evidently experiment that will receive the extended metrics.
     * </p>
     * 
     * @param destinationArn
     *        Use this parameter only if <code>Destination</code> is <code>Evidently</code>. This parameter specifies
     *        the ARN of the Evidently experiment that will receive the extended metrics.
     */

    public void setDestinationArn(String destinationArn) {
        this.destinationArn = destinationArn;
    }

    /**
     * <p>
     * Use this parameter only if <code>Destination</code> is <code>Evidently</code>. This parameter specifies the ARN
     * of the Evidently experiment that will receive the extended metrics.
     * </p>
     * 
     * @return Use this parameter only if <code>Destination</code> is <code>Evidently</code>. This parameter specifies
     *         the ARN of the Evidently experiment that will receive the extended metrics.
     */

    public String getDestinationArn() {
        return this.destinationArn;
    }

    /**
     * <p>
     * Use this parameter only if <code>Destination</code> is <code>Evidently</code>. This parameter specifies the ARN
     * of the Evidently experiment that will receive the extended metrics.
     * </p>
     * 
     * @param destinationArn
     *        Use this parameter only if <code>Destination</code> is <code>Evidently</code>. This parameter specifies
     *        the ARN of the Evidently experiment that will receive the extended metrics.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PutRumMetricsDestinationRequest withDestinationArn(String destinationArn) {
        setDestinationArn(destinationArn);
        return this;
    }

    /**
     * <p>
     * This parameter is required if <code>Destination</code> is <code>Evidently</code>. If <code>Destination</code> is
     * <code>CloudWatch</code>, don't use this parameter.
     * </p>
     * <p>
     * This parameter specifies the ARN of an IAM role that RUM will assume to write to the Evidently experiment that
     * you are sending metrics to. This role must have permission to write to that experiment.
     * </p>
     * <p>
     * If you specify this parameter, you must be signed on to a role that has <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">PassRole</a> permissions
     * attached to it, to allow the role to be passed. The <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/auth-and-access-control-cw.html#managed-policies-cloudwatch-RUM"
     * > CloudWatchAmazonCloudWatchRUMFullAccess</a> policy doesn't include <code>PassRole</code> permissions.
     * </p>
     * 
     * @param iamRoleArn
     *        This parameter is required if <code>Destination</code> is <code>Evidently</code>. If
     *        <code>Destination</code> is <code>CloudWatch</code>, don't use this parameter.</p>
     *        <p>
     *        This parameter specifies the ARN of an IAM role that RUM will assume to write to the Evidently experiment
     *        that you are sending metrics to. This role must have permission to write to that experiment.
     *        </p>
     *        <p>
     *        If you specify this parameter, you must be signed on to a role that has <a
     *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">PassRole</a>
     *        permissions attached to it, to allow the role to be passed. The <a href=
     *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/auth-and-access-control-cw.html#managed-policies-cloudwatch-RUM"
     *        > CloudWatchAmazonCloudWatchRUMFullAccess</a> policy doesn't include <code>PassRole</code> permissions.
     */

    public void setIamRoleArn(String iamRoleArn) {
        this.iamRoleArn = iamRoleArn;
    }

    /**
     * <p>
     * This parameter is required if <code>Destination</code> is <code>Evidently</code>. If <code>Destination</code> is
     * <code>CloudWatch</code>, don't use this parameter.
     * </p>
     * <p>
     * This parameter specifies the ARN of an IAM role that RUM will assume to write to the Evidently experiment that
     * you are sending metrics to. This role must have permission to write to that experiment.
     * </p>
     * <p>
     * If you specify this parameter, you must be signed on to a role that has <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">PassRole</a> permissions
     * attached to it, to allow the role to be passed. The <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/auth-and-access-control-cw.html#managed-policies-cloudwatch-RUM"
     * > CloudWatchAmazonCloudWatchRUMFullAccess</a> policy doesn't include <code>PassRole</code> permissions.
     * </p>
     * 
     * @return This parameter is required if <code>Destination</code> is <code>Evidently</code>. If
     *         <code>Destination</code> is <code>CloudWatch</code>, don't use this parameter.</p>
     *         <p>
     *         This parameter specifies the ARN of an IAM role that RUM will assume to write to the Evidently experiment
     *         that you are sending metrics to. This role must have permission to write to that experiment.
     *         </p>
     *         <p>
     *         If you specify this parameter, you must be signed on to a role that has <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">PassRole</a>
     *         permissions attached to it, to allow the role to be passed. The <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/auth-and-access-control-cw.html#managed-policies-cloudwatch-RUM"
     *         > CloudWatchAmazonCloudWatchRUMFullAccess</a> policy doesn't include <code>PassRole</code> permissions.
     */

    public String getIamRoleArn() {
        return this.iamRoleArn;
    }

    /**
     * <p>
     * This parameter is required if <code>Destination</code> is <code>Evidently</code>. If <code>Destination</code> is
     * <code>CloudWatch</code>, don't use this parameter.
     * </p>
     * <p>
     * This parameter specifies the ARN of an IAM role that RUM will assume to write to the Evidently experiment that
     * you are sending metrics to. This role must have permission to write to that experiment.
     * </p>
     * <p>
     * If you specify this parameter, you must be signed on to a role that has <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">PassRole</a> permissions
     * attached to it, to allow the role to be passed. The <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/auth-and-access-control-cw.html#managed-policies-cloudwatch-RUM"
     * > CloudWatchAmazonCloudWatchRUMFullAccess</a> policy doesn't include <code>PassRole</code> permissions.
     * </p>
     * 
     * @param iamRoleArn
     *        This parameter is required if <code>Destination</code> is <code>Evidently</code>. If
     *        <code>Destination</code> is <code>CloudWatch</code>, don't use this parameter.</p>
     *        <p>
     *        This parameter specifies the ARN of an IAM role that RUM will assume to write to the Evidently experiment
     *        that you are sending metrics to. This role must have permission to write to that experiment.
     *        </p>
     *        <p>
     *        If you specify this parameter, you must be signed on to a role that has <a
     *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">PassRole</a>
     *        permissions attached to it, to allow the role to be passed. The <a href=
     *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/auth-and-access-control-cw.html#managed-policies-cloudwatch-RUM"
     *        > CloudWatchAmazonCloudWatchRUMFullAccess</a> policy doesn't include <code>PassRole</code> permissions.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PutRumMetricsDestinationRequest withIamRoleArn(String iamRoleArn) {
        setIamRoleArn(iamRoleArn);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAppMonitorName() != null)
            sb.append("AppMonitorName: ").append(getAppMonitorName()).append(",");
        if (getDestination() != null)
            sb.append("Destination: ").append(getDestination()).append(",");
        if (getDestinationArn() != null)
            sb.append("DestinationArn: ").append(getDestinationArn()).append(",");
        if (getIamRoleArn() != null)
            sb.append("IamRoleArn: ").append(getIamRoleArn());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof PutRumMetricsDestinationRequest == false)
            return false;
        PutRumMetricsDestinationRequest other = (PutRumMetricsDestinationRequest) obj;
        if (other.getAppMonitorName() == null ^ this.getAppMonitorName() == null)
            return false;
        if (other.getAppMonitorName() != null && other.getAppMonitorName().equals(this.getAppMonitorName()) == false)
            return false;
        if (other.getDestination() == null ^ this.getDestination() == null)
            return false;
        if (other.getDestination() != null && other.getDestination().equals(this.getDestination()) == false)
            return false;
        if (other.getDestinationArn() == null ^ this.getDestinationArn() == null)
            return false;
        if (other.getDestinationArn() != null && other.getDestinationArn().equals(this.getDestinationArn()) == false)
            return false;
        if (other.getIamRoleArn() == null ^ this.getIamRoleArn() == null)
            return false;
        if (other.getIamRoleArn() != null && other.getIamRoleArn().equals(this.getIamRoleArn()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAppMonitorName() == null) ? 0 : getAppMonitorName().hashCode());
        hashCode = prime * hashCode + ((getDestination() == null) ? 0 : getDestination().hashCode());
        hashCode = prime * hashCode + ((getDestinationArn() == null) ? 0 : getDestinationArn().hashCode());
        hashCode = prime * hashCode + ((getIamRoleArn() == null) ? 0 : getIamRoleArn().hashCode());
        return hashCode;
    }

    @Override
    public PutRumMetricsDestinationRequest clone() {
        return (PutRumMetricsDestinationRequest) super.clone();
    }

}
