/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockagent.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bedrockagent.model.transform.S3DataSourceConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class S3DataSourceConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String bucketArn;
    private String bucketOwnerAccountId;
    private List<String> inclusionPrefixes;

    public void setBucketArn(String bucketArn) {
        this.bucketArn = bucketArn;
    }

    public String getBucketArn() {
        return this.bucketArn;
    }

    public S3DataSourceConfiguration withBucketArn(String bucketArn) {
        this.setBucketArn(bucketArn);
        return this;
    }

    public void setBucketOwnerAccountId(String bucketOwnerAccountId) {
        this.bucketOwnerAccountId = bucketOwnerAccountId;
    }

    public String getBucketOwnerAccountId() {
        return this.bucketOwnerAccountId;
    }

    public S3DataSourceConfiguration withBucketOwnerAccountId(String bucketOwnerAccountId) {
        this.setBucketOwnerAccountId(bucketOwnerAccountId);
        return this;
    }

    public List<String> getInclusionPrefixes() {
        return this.inclusionPrefixes;
    }

    public void setInclusionPrefixes(Collection<String> inclusionPrefixes) {
        if (inclusionPrefixes == null) {
            this.inclusionPrefixes = null;
            return;
        }
        this.inclusionPrefixes = new ArrayList<String>(inclusionPrefixes);
    }

    public S3DataSourceConfiguration withInclusionPrefixes(String ... inclusionPrefixes) {
        if (this.inclusionPrefixes == null) {
            this.setInclusionPrefixes(new ArrayList<String>(inclusionPrefixes.length));
        }
        for (String ele : inclusionPrefixes) {
            this.inclusionPrefixes.add(ele);
        }
        return this;
    }

    public S3DataSourceConfiguration withInclusionPrefixes(Collection<String> inclusionPrefixes) {
        this.setInclusionPrefixes(inclusionPrefixes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBucketArn() != null) {
            sb.append("BucketArn: ").append(this.getBucketArn()).append(",");
        }
        if (this.getBucketOwnerAccountId() != null) {
            sb.append("BucketOwnerAccountId: ").append(this.getBucketOwnerAccountId()).append(",");
        }
        if (this.getInclusionPrefixes() != null) {
            sb.append("InclusionPrefixes: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DataSourceConfiguration)) {
            return false;
        }
        S3DataSourceConfiguration other = (S3DataSourceConfiguration)obj;
        if (other.getBucketArn() == null ^ this.getBucketArn() == null) {
            return false;
        }
        if (other.getBucketArn() != null && !other.getBucketArn().equals(this.getBucketArn())) {
            return false;
        }
        if (other.getBucketOwnerAccountId() == null ^ this.getBucketOwnerAccountId() == null) {
            return false;
        }
        if (other.getBucketOwnerAccountId() != null && !other.getBucketOwnerAccountId().equals(this.getBucketOwnerAccountId())) {
            return false;
        }
        if (other.getInclusionPrefixes() == null ^ this.getInclusionPrefixes() == null) {
            return false;
        }
        return other.getInclusionPrefixes() == null || other.getInclusionPrefixes().equals(this.getInclusionPrefixes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBucketArn() == null ? 0 : this.getBucketArn().hashCode());
        hashCode = 31 * hashCode + (this.getBucketOwnerAccountId() == null ? 0 : this.getBucketOwnerAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getInclusionPrefixes() == null ? 0 : this.getInclusionPrefixes().hashCode());
        return hashCode;
    }

    public S3DataSourceConfiguration clone() {
        try {
            return (S3DataSourceConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3DataSourceConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

