/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.bcmdataexports.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/bcm-data-exports-2023-11-26/UpdateExport" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class UpdateExportRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The name and query details for the export.
     * </p>
     */
    private Export export;
    /**
     * <p>
     * The Amazon Resource Name (ARN) for this export.
     * </p>
     */
    private String exportArn;

    /**
     * <p>
     * The name and query details for the export.
     * </p>
     * 
     * @param export
     *        The name and query details for the export.
     */

    public void setExport(Export export) {
        this.export = export;
    }

    /**
     * <p>
     * The name and query details for the export.
     * </p>
     * 
     * @return The name and query details for the export.
     */

    public Export getExport() {
        return this.export;
    }

    /**
     * <p>
     * The name and query details for the export.
     * </p>
     * 
     * @param export
     *        The name and query details for the export.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateExportRequest withExport(Export export) {
        setExport(export);
        return this;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for this export.
     * </p>
     * 
     * @param exportArn
     *        The Amazon Resource Name (ARN) for this export.
     */

    public void setExportArn(String exportArn) {
        this.exportArn = exportArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for this export.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for this export.
     */

    public String getExportArn() {
        return this.exportArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for this export.
     * </p>
     * 
     * @param exportArn
     *        The Amazon Resource Name (ARN) for this export.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateExportRequest withExportArn(String exportArn) {
        setExportArn(exportArn);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getExport() != null)
            sb.append("Export: ").append(getExport()).append(",");
        if (getExportArn() != null)
            sb.append("ExportArn: ").append(getExportArn());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof UpdateExportRequest == false)
            return false;
        UpdateExportRequest other = (UpdateExportRequest) obj;
        if (other.getExport() == null ^ this.getExport() == null)
            return false;
        if (other.getExport() != null && other.getExport().equals(this.getExport()) == false)
            return false;
        if (other.getExportArn() == null ^ this.getExportArn() == null)
            return false;
        if (other.getExportArn() != null && other.getExportArn().equals(this.getExportArn()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getExport() == null) ? 0 : getExport().hashCode());
        hashCode = prime * hashCode + ((getExportArn() == null) ? 0 : getExportArn().hashCode());
        return hashCode;
    }

    @Override
    public UpdateExportRequest clone() {
        return (UpdateExportRequest) super.clone();
    }

}
