/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.arczonalshift;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.arczonalshift.AWSARCZonalShift;
import com.amazonaws.services.arczonalshift.AWSARCZonalShiftClientBuilder;
import com.amazonaws.services.arczonalshift.model.AWSARCZonalShiftException;
import com.amazonaws.services.arczonalshift.model.CancelZonalShiftRequest;
import com.amazonaws.services.arczonalshift.model.CancelZonalShiftResult;
import com.amazonaws.services.arczonalshift.model.CreatePracticeRunConfigurationRequest;
import com.amazonaws.services.arczonalshift.model.CreatePracticeRunConfigurationResult;
import com.amazonaws.services.arczonalshift.model.DeletePracticeRunConfigurationRequest;
import com.amazonaws.services.arczonalshift.model.DeletePracticeRunConfigurationResult;
import com.amazonaws.services.arczonalshift.model.GetAutoshiftObserverNotificationStatusRequest;
import com.amazonaws.services.arczonalshift.model.GetAutoshiftObserverNotificationStatusResult;
import com.amazonaws.services.arczonalshift.model.GetManagedResourceRequest;
import com.amazonaws.services.arczonalshift.model.GetManagedResourceResult;
import com.amazonaws.services.arczonalshift.model.ListAutoshiftsRequest;
import com.amazonaws.services.arczonalshift.model.ListAutoshiftsResult;
import com.amazonaws.services.arczonalshift.model.ListManagedResourcesRequest;
import com.amazonaws.services.arczonalshift.model.ListManagedResourcesResult;
import com.amazonaws.services.arczonalshift.model.ListZonalShiftsRequest;
import com.amazonaws.services.arczonalshift.model.ListZonalShiftsResult;
import com.amazonaws.services.arczonalshift.model.StartZonalShiftRequest;
import com.amazonaws.services.arczonalshift.model.StartZonalShiftResult;
import com.amazonaws.services.arczonalshift.model.UpdateAutoshiftObserverNotificationStatusRequest;
import com.amazonaws.services.arczonalshift.model.UpdateAutoshiftObserverNotificationStatusResult;
import com.amazonaws.services.arczonalshift.model.UpdatePracticeRunConfigurationRequest;
import com.amazonaws.services.arczonalshift.model.UpdatePracticeRunConfigurationResult;
import com.amazonaws.services.arczonalshift.model.UpdateZonalAutoshiftConfigurationRequest;
import com.amazonaws.services.arczonalshift.model.UpdateZonalAutoshiftConfigurationResult;
import com.amazonaws.services.arczonalshift.model.UpdateZonalShiftRequest;
import com.amazonaws.services.arczonalshift.model.UpdateZonalShiftResult;
import com.amazonaws.services.arczonalshift.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.arczonalshift.model.transform.CancelZonalShiftRequestProtocolMarshaller;
import com.amazonaws.services.arczonalshift.model.transform.CancelZonalShiftResultJsonUnmarshaller;
import com.amazonaws.services.arczonalshift.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.arczonalshift.model.transform.CreatePracticeRunConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.arczonalshift.model.transform.CreatePracticeRunConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.arczonalshift.model.transform.DeletePracticeRunConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.arczonalshift.model.transform.DeletePracticeRunConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.arczonalshift.model.transform.GetAutoshiftObserverNotificationStatusRequestProtocolMarshaller;
import com.amazonaws.services.arczonalshift.model.transform.GetAutoshiftObserverNotificationStatusResultJsonUnmarshaller;
import com.amazonaws.services.arczonalshift.model.transform.GetManagedResourceRequestProtocolMarshaller;
import com.amazonaws.services.arczonalshift.model.transform.GetManagedResourceResultJsonUnmarshaller;
import com.amazonaws.services.arczonalshift.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.arczonalshift.model.transform.ListAutoshiftsRequestProtocolMarshaller;
import com.amazonaws.services.arczonalshift.model.transform.ListAutoshiftsResultJsonUnmarshaller;
import com.amazonaws.services.arczonalshift.model.transform.ListManagedResourcesRequestProtocolMarshaller;
import com.amazonaws.services.arczonalshift.model.transform.ListManagedResourcesResultJsonUnmarshaller;
import com.amazonaws.services.arczonalshift.model.transform.ListZonalShiftsRequestProtocolMarshaller;
import com.amazonaws.services.arczonalshift.model.transform.ListZonalShiftsResultJsonUnmarshaller;
import com.amazonaws.services.arczonalshift.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.arczonalshift.model.transform.StartZonalShiftRequestProtocolMarshaller;
import com.amazonaws.services.arczonalshift.model.transform.StartZonalShiftResultJsonUnmarshaller;
import com.amazonaws.services.arczonalshift.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.arczonalshift.model.transform.UpdateAutoshiftObserverNotificationStatusRequestProtocolMarshaller;
import com.amazonaws.services.arczonalshift.model.transform.UpdateAutoshiftObserverNotificationStatusResultJsonUnmarshaller;
import com.amazonaws.services.arczonalshift.model.transform.UpdatePracticeRunConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.arczonalshift.model.transform.UpdatePracticeRunConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.arczonalshift.model.transform.UpdateZonalAutoshiftConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.arczonalshift.model.transform.UpdateZonalAutoshiftConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.arczonalshift.model.transform.UpdateZonalShiftRequestProtocolMarshaller;
import com.amazonaws.services.arczonalshift.model.transform.UpdateZonalShiftResultJsonUnmarshaller;
import com.amazonaws.services.arczonalshift.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSARCZonalShiftClient
extends AmazonWebServiceClient
implements AWSARCZonalShift {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSARCZonalShift.class);
    private static final String DEFAULT_SIGNING_NAME = "arc-zonal-shift";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSARCZonalShiftException.class));

    public static AWSARCZonalShiftClientBuilder builder() {
        return AWSARCZonalShiftClientBuilder.standard();
    }

    AWSARCZonalShiftClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSARCZonalShiftClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("arc-zonal-shift.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/arczonalshift/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/arczonalshift/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CancelZonalShiftResult cancelZonalShift(CancelZonalShiftRequest request) {
        request = (CancelZonalShiftRequest)this.beforeClientExecution(request);
        return this.executeCancelZonalShift(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CancelZonalShiftResult executeCancelZonalShift(CancelZonalShiftRequest cancelZonalShiftRequest) {
        ExecutionContext executionContext = this.createExecutionContext(cancelZonalShiftRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CancelZonalShiftRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CancelZonalShiftRequestProtocolMarshaller(protocolFactory).marshall((CancelZonalShiftRequest)super.beforeMarshalling((AmazonWebServiceRequest)cancelZonalShiftRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ARC Zonal Shift");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CancelZonalShift");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CancelZonalShiftResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CancelZonalShiftResult cancelZonalShiftResult = (CancelZonalShiftResult)response.getAwsResponse();
            return cancelZonalShiftResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreatePracticeRunConfigurationResult createPracticeRunConfiguration(CreatePracticeRunConfigurationRequest request) {
        request = (CreatePracticeRunConfigurationRequest)this.beforeClientExecution(request);
        return this.executeCreatePracticeRunConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreatePracticeRunConfigurationResult executeCreatePracticeRunConfiguration(CreatePracticeRunConfigurationRequest createPracticeRunConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createPracticeRunConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreatePracticeRunConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreatePracticeRunConfigurationRequestProtocolMarshaller(protocolFactory).marshall((CreatePracticeRunConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)createPracticeRunConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ARC Zonal Shift");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreatePracticeRunConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreatePracticeRunConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreatePracticeRunConfigurationResult createPracticeRunConfigurationResult = (CreatePracticeRunConfigurationResult)response.getAwsResponse();
            return createPracticeRunConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeletePracticeRunConfigurationResult deletePracticeRunConfiguration(DeletePracticeRunConfigurationRequest request) {
        request = (DeletePracticeRunConfigurationRequest)this.beforeClientExecution(request);
        return this.executeDeletePracticeRunConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeletePracticeRunConfigurationResult executeDeletePracticeRunConfiguration(DeletePracticeRunConfigurationRequest deletePracticeRunConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deletePracticeRunConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeletePracticeRunConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeletePracticeRunConfigurationRequestProtocolMarshaller(protocolFactory).marshall((DeletePracticeRunConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)deletePracticeRunConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ARC Zonal Shift");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeletePracticeRunConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeletePracticeRunConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeletePracticeRunConfigurationResult deletePracticeRunConfigurationResult = (DeletePracticeRunConfigurationResult)response.getAwsResponse();
            return deletePracticeRunConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetAutoshiftObserverNotificationStatusResult getAutoshiftObserverNotificationStatus(GetAutoshiftObserverNotificationStatusRequest request) {
        request = (GetAutoshiftObserverNotificationStatusRequest)this.beforeClientExecution(request);
        return this.executeGetAutoshiftObserverNotificationStatus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetAutoshiftObserverNotificationStatusResult executeGetAutoshiftObserverNotificationStatus(GetAutoshiftObserverNotificationStatusRequest getAutoshiftObserverNotificationStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAutoshiftObserverNotificationStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAutoshiftObserverNotificationStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAutoshiftObserverNotificationStatusRequestProtocolMarshaller(protocolFactory).marshall((GetAutoshiftObserverNotificationStatusRequest)super.beforeMarshalling((AmazonWebServiceRequest)getAutoshiftObserverNotificationStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ARC Zonal Shift");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetAutoshiftObserverNotificationStatus");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetAutoshiftObserverNotificationStatusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetAutoshiftObserverNotificationStatusResult getAutoshiftObserverNotificationStatusResult = (GetAutoshiftObserverNotificationStatusResult)response.getAwsResponse();
            return getAutoshiftObserverNotificationStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetManagedResourceResult getManagedResource(GetManagedResourceRequest request) {
        request = (GetManagedResourceRequest)this.beforeClientExecution(request);
        return this.executeGetManagedResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetManagedResourceResult executeGetManagedResource(GetManagedResourceRequest getManagedResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getManagedResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetManagedResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetManagedResourceRequestProtocolMarshaller(protocolFactory).marshall((GetManagedResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)getManagedResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ARC Zonal Shift");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetManagedResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetManagedResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetManagedResourceResult getManagedResourceResult = (GetManagedResourceResult)response.getAwsResponse();
            return getManagedResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAutoshiftsResult listAutoshifts(ListAutoshiftsRequest request) {
        request = (ListAutoshiftsRequest)this.beforeClientExecution(request);
        return this.executeListAutoshifts(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAutoshiftsResult executeListAutoshifts(ListAutoshiftsRequest listAutoshiftsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAutoshiftsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAutoshiftsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAutoshiftsRequestProtocolMarshaller(protocolFactory).marshall((ListAutoshiftsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAutoshiftsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ARC Zonal Shift");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListAutoshifts");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAutoshiftsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAutoshiftsResult listAutoshiftsResult = (ListAutoshiftsResult)response.getAwsResponse();
            return listAutoshiftsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListManagedResourcesResult listManagedResources(ListManagedResourcesRequest request) {
        request = (ListManagedResourcesRequest)this.beforeClientExecution(request);
        return this.executeListManagedResources(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListManagedResourcesResult executeListManagedResources(ListManagedResourcesRequest listManagedResourcesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listManagedResourcesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListManagedResourcesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListManagedResourcesRequestProtocolMarshaller(protocolFactory).marshall((ListManagedResourcesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listManagedResourcesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ARC Zonal Shift");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListManagedResources");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListManagedResourcesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListManagedResourcesResult listManagedResourcesResult = (ListManagedResourcesResult)response.getAwsResponse();
            return listManagedResourcesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListZonalShiftsResult listZonalShifts(ListZonalShiftsRequest request) {
        request = (ListZonalShiftsRequest)this.beforeClientExecution(request);
        return this.executeListZonalShifts(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListZonalShiftsResult executeListZonalShifts(ListZonalShiftsRequest listZonalShiftsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listZonalShiftsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListZonalShiftsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListZonalShiftsRequestProtocolMarshaller(protocolFactory).marshall((ListZonalShiftsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listZonalShiftsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ARC Zonal Shift");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListZonalShifts");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListZonalShiftsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListZonalShiftsResult listZonalShiftsResult = (ListZonalShiftsResult)response.getAwsResponse();
            return listZonalShiftsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartZonalShiftResult startZonalShift(StartZonalShiftRequest request) {
        request = (StartZonalShiftRequest)this.beforeClientExecution(request);
        return this.executeStartZonalShift(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartZonalShiftResult executeStartZonalShift(StartZonalShiftRequest startZonalShiftRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startZonalShiftRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartZonalShiftRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartZonalShiftRequestProtocolMarshaller(protocolFactory).marshall((StartZonalShiftRequest)super.beforeMarshalling((AmazonWebServiceRequest)startZonalShiftRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ARC Zonal Shift");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartZonalShift");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartZonalShiftResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartZonalShiftResult startZonalShiftResult = (StartZonalShiftResult)response.getAwsResponse();
            return startZonalShiftResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateAutoshiftObserverNotificationStatusResult updateAutoshiftObserverNotificationStatus(UpdateAutoshiftObserverNotificationStatusRequest request) {
        request = (UpdateAutoshiftObserverNotificationStatusRequest)this.beforeClientExecution(request);
        return this.executeUpdateAutoshiftObserverNotificationStatus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateAutoshiftObserverNotificationStatusResult executeUpdateAutoshiftObserverNotificationStatus(UpdateAutoshiftObserverNotificationStatusRequest updateAutoshiftObserverNotificationStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateAutoshiftObserverNotificationStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateAutoshiftObserverNotificationStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateAutoshiftObserverNotificationStatusRequestProtocolMarshaller(protocolFactory).marshall((UpdateAutoshiftObserverNotificationStatusRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateAutoshiftObserverNotificationStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ARC Zonal Shift");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateAutoshiftObserverNotificationStatus");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateAutoshiftObserverNotificationStatusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateAutoshiftObserverNotificationStatusResult updateAutoshiftObserverNotificationStatusResult = (UpdateAutoshiftObserverNotificationStatusResult)response.getAwsResponse();
            return updateAutoshiftObserverNotificationStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdatePracticeRunConfigurationResult updatePracticeRunConfiguration(UpdatePracticeRunConfigurationRequest request) {
        request = (UpdatePracticeRunConfigurationRequest)this.beforeClientExecution(request);
        return this.executeUpdatePracticeRunConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdatePracticeRunConfigurationResult executeUpdatePracticeRunConfiguration(UpdatePracticeRunConfigurationRequest updatePracticeRunConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updatePracticeRunConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdatePracticeRunConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdatePracticeRunConfigurationRequestProtocolMarshaller(protocolFactory).marshall((UpdatePracticeRunConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)updatePracticeRunConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ARC Zonal Shift");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdatePracticeRunConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdatePracticeRunConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdatePracticeRunConfigurationResult updatePracticeRunConfigurationResult = (UpdatePracticeRunConfigurationResult)response.getAwsResponse();
            return updatePracticeRunConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateZonalAutoshiftConfigurationResult updateZonalAutoshiftConfiguration(UpdateZonalAutoshiftConfigurationRequest request) {
        request = (UpdateZonalAutoshiftConfigurationRequest)this.beforeClientExecution(request);
        return this.executeUpdateZonalAutoshiftConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateZonalAutoshiftConfigurationResult executeUpdateZonalAutoshiftConfiguration(UpdateZonalAutoshiftConfigurationRequest updateZonalAutoshiftConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateZonalAutoshiftConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateZonalAutoshiftConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateZonalAutoshiftConfigurationRequestProtocolMarshaller(protocolFactory).marshall((UpdateZonalAutoshiftConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateZonalAutoshiftConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ARC Zonal Shift");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateZonalAutoshiftConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateZonalAutoshiftConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateZonalAutoshiftConfigurationResult updateZonalAutoshiftConfigurationResult = (UpdateZonalAutoshiftConfigurationResult)response.getAwsResponse();
            return updateZonalAutoshiftConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateZonalShiftResult updateZonalShift(UpdateZonalShiftRequest request) {
        request = (UpdateZonalShiftRequest)this.beforeClientExecution(request);
        return this.executeUpdateZonalShift(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateZonalShiftResult executeUpdateZonalShift(UpdateZonalShiftRequest updateZonalShiftRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateZonalShiftRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateZonalShiftRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateZonalShiftRequestProtocolMarshaller(protocolFactory).marshall((UpdateZonalShiftRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateZonalShiftRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ARC Zonal Shift");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateZonalShift");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateZonalShiftResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateZonalShiftResult updateZonalShiftResult = (UpdateZonalShiftResult)response.getAwsResponse();
            return updateZonalShiftResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

