/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.apptest;

import javax.annotation.Generated;

import com.amazonaws.services.apptest.model.*;

/**
 * Abstract implementation of {@code AWSAppTestAsync}. Convenient method forms pass through to the corresponding
 * overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSAppTestAsync extends AbstractAWSAppTest implements AWSAppTestAsync {

    protected AbstractAWSAppTestAsync() {
    }

    @Override
    public java.util.concurrent.Future<CreateTestCaseResult> createTestCaseAsync(CreateTestCaseRequest request) {

        return createTestCaseAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateTestCaseResult> createTestCaseAsync(CreateTestCaseRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateTestCaseRequest, CreateTestCaseResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateTestConfigurationResult> createTestConfigurationAsync(CreateTestConfigurationRequest request) {

        return createTestConfigurationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateTestConfigurationResult> createTestConfigurationAsync(CreateTestConfigurationRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateTestConfigurationRequest, CreateTestConfigurationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateTestSuiteResult> createTestSuiteAsync(CreateTestSuiteRequest request) {

        return createTestSuiteAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateTestSuiteResult> createTestSuiteAsync(CreateTestSuiteRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateTestSuiteRequest, CreateTestSuiteResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteTestCaseResult> deleteTestCaseAsync(DeleteTestCaseRequest request) {

        return deleteTestCaseAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteTestCaseResult> deleteTestCaseAsync(DeleteTestCaseRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteTestCaseRequest, DeleteTestCaseResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteTestConfigurationResult> deleteTestConfigurationAsync(DeleteTestConfigurationRequest request) {

        return deleteTestConfigurationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteTestConfigurationResult> deleteTestConfigurationAsync(DeleteTestConfigurationRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteTestConfigurationRequest, DeleteTestConfigurationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteTestRunResult> deleteTestRunAsync(DeleteTestRunRequest request) {

        return deleteTestRunAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteTestRunResult> deleteTestRunAsync(DeleteTestRunRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteTestRunRequest, DeleteTestRunResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteTestSuiteResult> deleteTestSuiteAsync(DeleteTestSuiteRequest request) {

        return deleteTestSuiteAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteTestSuiteResult> deleteTestSuiteAsync(DeleteTestSuiteRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteTestSuiteRequest, DeleteTestSuiteResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetTestCaseResult> getTestCaseAsync(GetTestCaseRequest request) {

        return getTestCaseAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetTestCaseResult> getTestCaseAsync(GetTestCaseRequest request,
            com.amazonaws.handlers.AsyncHandler<GetTestCaseRequest, GetTestCaseResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetTestConfigurationResult> getTestConfigurationAsync(GetTestConfigurationRequest request) {

        return getTestConfigurationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetTestConfigurationResult> getTestConfigurationAsync(GetTestConfigurationRequest request,
            com.amazonaws.handlers.AsyncHandler<GetTestConfigurationRequest, GetTestConfigurationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetTestRunStepResult> getTestRunStepAsync(GetTestRunStepRequest request) {

        return getTestRunStepAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetTestRunStepResult> getTestRunStepAsync(GetTestRunStepRequest request,
            com.amazonaws.handlers.AsyncHandler<GetTestRunStepRequest, GetTestRunStepResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetTestSuiteResult> getTestSuiteAsync(GetTestSuiteRequest request) {

        return getTestSuiteAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetTestSuiteResult> getTestSuiteAsync(GetTestSuiteRequest request,
            com.amazonaws.handlers.AsyncHandler<GetTestSuiteRequest, GetTestSuiteResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {

        return listTagsForResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTestCasesResult> listTestCasesAsync(ListTestCasesRequest request) {

        return listTestCasesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTestCasesResult> listTestCasesAsync(ListTestCasesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTestCasesRequest, ListTestCasesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTestConfigurationsResult> listTestConfigurationsAsync(ListTestConfigurationsRequest request) {

        return listTestConfigurationsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTestConfigurationsResult> listTestConfigurationsAsync(ListTestConfigurationsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTestConfigurationsRequest, ListTestConfigurationsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTestRunStepsResult> listTestRunStepsAsync(ListTestRunStepsRequest request) {

        return listTestRunStepsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTestRunStepsResult> listTestRunStepsAsync(ListTestRunStepsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTestRunStepsRequest, ListTestRunStepsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTestRunTestCasesResult> listTestRunTestCasesAsync(ListTestRunTestCasesRequest request) {

        return listTestRunTestCasesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTestRunTestCasesResult> listTestRunTestCasesAsync(ListTestRunTestCasesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTestRunTestCasesRequest, ListTestRunTestCasesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTestRunsResult> listTestRunsAsync(ListTestRunsRequest request) {

        return listTestRunsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTestRunsResult> listTestRunsAsync(ListTestRunsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTestRunsRequest, ListTestRunsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTestSuitesResult> listTestSuitesAsync(ListTestSuitesRequest request) {

        return listTestSuitesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTestSuitesResult> listTestSuitesAsync(ListTestSuitesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTestSuitesRequest, ListTestSuitesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StartTestRunResult> startTestRunAsync(StartTestRunRequest request) {

        return startTestRunAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StartTestRunResult> startTestRunAsync(StartTestRunRequest request,
            com.amazonaws.handlers.AsyncHandler<StartTestRunRequest, StartTestRunResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {

        return tagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {

        return untagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateTestCaseResult> updateTestCaseAsync(UpdateTestCaseRequest request) {

        return updateTestCaseAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateTestCaseResult> updateTestCaseAsync(UpdateTestCaseRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateTestCaseRequest, UpdateTestCaseResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateTestConfigurationResult> updateTestConfigurationAsync(UpdateTestConfigurationRequest request) {

        return updateTestConfigurationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateTestConfigurationResult> updateTestConfigurationAsync(UpdateTestConfigurationRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateTestConfigurationRequest, UpdateTestConfigurationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateTestSuiteResult> updateTestSuiteAsync(UpdateTestSuiteRequest request) {

        return updateTestSuiteAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateTestSuiteResult> updateTestSuiteAsync(UpdateTestSuiteRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateTestSuiteRequest, UpdateTestSuiteResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
