/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationsignals.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.applicationsignals.model.MetricReference;
import com.amazonaws.services.applicationsignals.model.transform.ServiceDependentMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServiceDependent
implements Serializable,
Cloneable,
StructuredPojo {
    private String operationName;
    private Map<String, String> dependentKeyAttributes;
    private String dependentOperationName;
    private List<MetricReference> metricReferences;

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public ServiceDependent withOperationName(String operationName) {
        this.setOperationName(operationName);
        return this;
    }

    public Map<String, String> getDependentKeyAttributes() {
        return this.dependentKeyAttributes;
    }

    public void setDependentKeyAttributes(Map<String, String> dependentKeyAttributes) {
        this.dependentKeyAttributes = dependentKeyAttributes;
    }

    public ServiceDependent withDependentKeyAttributes(Map<String, String> dependentKeyAttributes) {
        this.setDependentKeyAttributes(dependentKeyAttributes);
        return this;
    }

    public ServiceDependent addDependentKeyAttributesEntry(String key, String value) {
        if (null == this.dependentKeyAttributes) {
            this.dependentKeyAttributes = new HashMap<String, String>();
        }
        if (this.dependentKeyAttributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.dependentKeyAttributes.put(key, value);
        return this;
    }

    public ServiceDependent clearDependentKeyAttributesEntries() {
        this.dependentKeyAttributes = null;
        return this;
    }

    public void setDependentOperationName(String dependentOperationName) {
        this.dependentOperationName = dependentOperationName;
    }

    public String getDependentOperationName() {
        return this.dependentOperationName;
    }

    public ServiceDependent withDependentOperationName(String dependentOperationName) {
        this.setDependentOperationName(dependentOperationName);
        return this;
    }

    public List<MetricReference> getMetricReferences() {
        return this.metricReferences;
    }

    public void setMetricReferences(Collection<MetricReference> metricReferences) {
        if (metricReferences == null) {
            this.metricReferences = null;
            return;
        }
        this.metricReferences = new ArrayList<MetricReference>(metricReferences);
    }

    public ServiceDependent withMetricReferences(MetricReference ... metricReferences) {
        if (this.metricReferences == null) {
            this.setMetricReferences(new ArrayList<MetricReference>(metricReferences.length));
        }
        for (MetricReference ele : metricReferences) {
            this.metricReferences.add(ele);
        }
        return this;
    }

    public ServiceDependent withMetricReferences(Collection<MetricReference> metricReferences) {
        this.setMetricReferences(metricReferences);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOperationName() != null) {
            sb.append("OperationName: ").append(this.getOperationName()).append(",");
        }
        if (this.getDependentKeyAttributes() != null) {
            sb.append("DependentKeyAttributes: ").append(this.getDependentKeyAttributes()).append(",");
        }
        if (this.getDependentOperationName() != null) {
            sb.append("DependentOperationName: ").append(this.getDependentOperationName()).append(",");
        }
        if (this.getMetricReferences() != null) {
            sb.append("MetricReferences: ").append(this.getMetricReferences());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceDependent)) {
            return false;
        }
        ServiceDependent other = (ServiceDependent)obj;
        if (other.getOperationName() == null ^ this.getOperationName() == null) {
            return false;
        }
        if (other.getOperationName() != null && !other.getOperationName().equals(this.getOperationName())) {
            return false;
        }
        if (other.getDependentKeyAttributes() == null ^ this.getDependentKeyAttributes() == null) {
            return false;
        }
        if (other.getDependentKeyAttributes() != null && !other.getDependentKeyAttributes().equals(this.getDependentKeyAttributes())) {
            return false;
        }
        if (other.getDependentOperationName() == null ^ this.getDependentOperationName() == null) {
            return false;
        }
        if (other.getDependentOperationName() != null && !other.getDependentOperationName().equals(this.getDependentOperationName())) {
            return false;
        }
        if (other.getMetricReferences() == null ^ this.getMetricReferences() == null) {
            return false;
        }
        return other.getMetricReferences() == null || other.getMetricReferences().equals(this.getMetricReferences());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOperationName() == null ? 0 : this.getOperationName().hashCode());
        hashCode = 31 * hashCode + (this.getDependentKeyAttributes() == null ? 0 : this.getDependentKeyAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getDependentOperationName() == null ? 0 : this.getDependentOperationName().hashCode());
        hashCode = 31 * hashCode + (this.getMetricReferences() == null ? 0 : this.getMetricReferences().hashCode());
        return hashCode;
    }

    public ServiceDependent clone() {
        try {
            return (ServiceDependent)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ServiceDependentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

