/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.preference.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Paint;
import android.os.Build;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.view.View;
import android.view.Window;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

public class MethodsCompat {
    private static final Method getMeasuredState = MethodsCompat.getMethod(View.class, "getMeasuredState");
    private static final Field mMeasuredWidth;
    private static final Field mMeasuredHeight;

    public static final int getMeasuredState(View view) {
        if (getMeasuredState == null) {
            int MEASURED_STATE_MASK = -16777216;
            int MEASURED_HEIGHT_STATE_SHIFT = 16;
            return MethodsCompat.getIntFieldValue(view, mMeasuredWidth) & 0xFF000000 | MethodsCompat.getIntFieldValue(view, mMeasuredHeight) >> 16 & 0xFFFFFF00;
        }
        return MethodsCompat.callMethod(getMeasuredState, view);
    }

    static final Field getField(Class clazz, String fieldName) {
        Field field = null;
        try {
            field = clazz.getDeclaredField(fieldName);
            if (field != null && !field.isAccessible()) {
                field.setAccessible(true);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return field;
    }

    static final int getIntFieldValue(Object obj, Field field) {
        try {
            return field.getInt(obj);
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return 0;
    }

    static int callMethod(Method method, Object obj) {
        if (method != null && obj != null) {
            try {
                Object ret = method.invoke(obj, null);
                if (ret != null && ret instanceof Integer) {
                    ((Integer)ret).intValue();
                }
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return 0;
    }

    static final Method getMethod(Class clazz, String methodName) {
        Method method = null;
        try {
            method = clazz.getMethod(methodName, null);
            if (method != null && !method.isAccessible()) {
                method.setAccessible(true);
            }
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return method;
    }

    public byte[] copyOfRange(byte[] from, int start, int end) {
        int length = end - start;
        byte[] result = new byte[length];
        System.arraycopy(from, start, result, 0, length);
        return result;
    }

    public static boolean[] copyOfRange(boolean[] original, int start, int end) {
        if (start > end) {
            throw new IllegalArgumentException();
        }
        int originalLength = original.length;
        if (start < 0 || start > originalLength) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int resultLength = end - start;
        int copyLength = Math.min(resultLength, originalLength - start);
        boolean[] result = new boolean[resultLength];
        System.arraycopy(original, start, result, 0, copyLength);
        return result;
    }

    @TargetApi(value=11)
    public static Set<String> getValue(SharedPreferences sp, String key, Set<String> defValue) {
        block5: {
            try {
                if (Build.VERSION.SDK_INT < 11) {
                    String regularEx = "|";
                    String setString = sp.getString(key, null);
                    if (setString != null) {
                        String[] values = setString.split("|");
                        HashSet<String> set = new HashSet<String>(values.length);
                        for (String value : values) {
                            if (TextUtils.isEmpty((CharSequence)value)) continue;
                            set.add(value);
                        }
                        return set;
                    }
                    break block5;
                }
                return sp.getStringSet(key, defValue);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return defValue;
    }

    @TargetApi(value=11)
    public static void putStringSet(SharedPreferences.Editor edit, String key, Set<String> values) {
        try {
            if (Build.VERSION.SDK_INT < 11) {
                String regularEx = "|";
                String str = "";
                if (values != null && !values.isEmpty()) {
                    Object[] objects;
                    for (Object obj : objects = values.toArray()) {
                        str = str + obj.toString();
                        str = str + "|";
                    }
                    edit.putString(key, str);
                }
            } else {
                edit.putStringSet(key, values).commit();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void apply(SharedPreferences.Editor editor) {
        try {
            Method sApplyMethod = SharedPreferences.Editor.class.getMethod("apply", new Class[0]);
            sApplyMethod.invoke((Object)editor, new Object[0]);
            return;
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        editor.commit();
    }

    @TargetApi(value=5)
    public static void overridePendingTransition(Activity activity, int enter_anim, int exit_anim) {
        activity.overridePendingTransition(enter_anim, exit_anim);
    }

    @TargetApi(value=7)
    public static Bitmap getThumbnail(ContentResolver cr, long origId, int kind, BitmapFactory.Options options) {
        return MediaStore.Images.Thumbnails.getThumbnail((ContentResolver)cr, (long)origId, (int)kind, (BitmapFactory.Options)options);
    }

    @TargetApi(value=8)
    public static File getExternalCacheDir(Context context) {
        return context.getExternalCacheDir();
    }

    @TargetApi(value=11)
    public static void recreate(Activity activity) {
        if (Build.VERSION.SDK_INT >= 11) {
            activity.recreate();
        }
    }

    @TargetApi(value=11)
    public static void setLayerType(View view, int layerType, Paint paint) {
        if (Build.VERSION.SDK_INT >= 11) {
            view.setLayerType(layerType, paint);
        }
    }

    @TargetApi(value=14)
    public static void setUiOptions(Window window, int uiOptions) {
        if (Build.VERSION.SDK_INT >= 14) {
            window.setUiOptions(uiOptions);
        }
    }

    static {
        if (getMeasuredState == null) {
            mMeasuredWidth = MethodsCompat.getField(View.class, "mMeasuredWidth");
            mMeasuredHeight = MethodsCompat.getField(View.class, "mMeasuredHeight");
        } else {
            mMeasuredWidth = null;
            mMeasuredHeight = null;
        }
    }
}

