/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.preference;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.v4.preference.Switch;
import android.support.v4.preference.TwoStatePreference;
import android.support.v4.preferencefragment.R;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Checkable;
import android.widget.CompoundButton;

public class SwitchPreference
extends TwoStatePreference {
    private CharSequence mSwitchOn;
    private CharSequence mSwitchOff;
    private final Listener mListener = new Listener();

    public SwitchPreference(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SwitchPreference, defStyle, 0);
        this.setSummaryOn(a.getString(0));
        this.setSummaryOff(a.getString(1));
        this.setSwitchTextOn(a.getString(3));
        this.setSwitchTextOff(a.getString(4));
        this.setDisableDependentsState(a.getBoolean(2, false));
        a.recycle();
    }

    public SwitchPreference(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.switchPreferenceStyle);
    }

    public SwitchPreference(Context context) {
        this(context, null);
    }

    @Override
    @TargetApi(value=14)
    protected void onBindView(View view) {
        super.onBindView(view);
        View checkableView = view.findViewById(R.id.switchWidget);
        if (checkableView != null && checkableView instanceof Checkable) {
            ((Checkable)checkableView).setChecked(this.mChecked);
            if (Build.VERSION.SDK_INT < 14) {
                if (checkableView instanceof Switch) {
                    Switch switchView = (Switch)checkableView;
                    switchView.setTextOn(this.mSwitchOn);
                    switchView.setTextOff(this.mSwitchOff);
                    switchView.setOnCheckedChangeListener(this.mListener);
                }
            } else if (checkableView instanceof android.widget.Switch) {
                android.widget.Switch switchView = (android.widget.Switch)checkableView;
                switchView.setTextOn(this.mSwitchOn);
                switchView.setTextOff(this.mSwitchOff);
                switchView.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this.mListener);
            }
        }
        this.syncSummaryView(view);
    }

    public void setSwitchTextOn(CharSequence onText) {
        this.mSwitchOn = onText;
        this.notifyChanged();
    }

    public void setSwitchTextOff(CharSequence offText) {
        this.mSwitchOff = offText;
        this.notifyChanged();
    }

    public void setSwitchTextOn(int resId) {
        this.setSwitchTextOn(this.getContext().getString(resId));
    }

    public void setSwitchTextOff(int resId) {
        this.setSwitchTextOff(this.getContext().getString(resId));
    }

    public CharSequence getSwitchTextOn() {
        return this.mSwitchOn;
    }

    public CharSequence getSwitchTextOff() {
        return this.mSwitchOff;
    }

    private class Listener
    implements CompoundButton.OnCheckedChangeListener {
        private Listener() {
        }

        public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
            if (!SwitchPreference.this.callChangeListener(isChecked)) {
                buttonView.setChecked(!isChecked);
                return;
            }
            SwitchPreference.this.setChecked(isChecked);
        }
    }
}

