/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.simexp;

import umontreal.ssj.simevents.Simulator;
import umontreal.ssj.simexp.SimExp;

public abstract class RepSim
extends SimExp {
    private int minReps;
    private int maxReps;
    private int targetReps;
    private int doneReps;

    public RepSim(int minReps) {
        this(minReps, Integer.MAX_VALUE);
    }

    public RepSim(int minReps, int maxReps) {
        this(Simulator.getDefaultSimulator(), minReps, maxReps);
    }

    public RepSim(Simulator sim, int minReps) {
        this(sim, minReps, Integer.MAX_VALUE);
    }

    public RepSim(Simulator sim, int minReps, int maxReps) {
        super(sim);
        if (minReps <= 0) {
            throw new IllegalArgumentException("minReps <= 0");
        }
        if (minReps > maxReps) {
            throw new IllegalArgumentException("minReps > maxReps");
        }
        this.minReps = minReps;
        this.maxReps = maxReps;
        this.targetReps = minReps;
    }

    public int getMinReplications() {
        return this.minReps;
    }

    public void setMinReplications(int minReps) {
        if (minReps <= 0) {
            throw new IllegalArgumentException("minReps <= 0");
        }
        this.minReps = minReps;
        if (this.maxReps < minReps) {
            this.maxReps = minReps;
        }
    }

    public int getMaxReplications() {
        return this.maxReps;
    }

    public void setMaxReplications(int maxReps) {
        if (maxReps < this.minReps) {
            throw new IllegalArgumentException("maxReps < minReps");
        }
        this.maxReps = maxReps;
    }

    public int getTargetReplications() {
        return this.targetReps;
    }

    public void setTargetReplications(int targetReps) {
        if (targetReps < this.minReps) {
            throw new IllegalArgumentException("Target number of replications too small");
        }
        if (targetReps > this.maxReps) {
            throw new IllegalArgumentException("Target number of replications too large");
        }
        this.targetReps = targetReps;
    }

    public int getCompletedReplications() {
        return this.doneReps;
    }

    public abstract void initReplicationProbes();

    public void performReplication(int r) {
        this.simulator().init();
        this.initReplication(r);
        this.simulator().start();
        this.replicationDone();
        this.addReplicationObs(r);
    }

    protected void replicationDone() {
        ++this.doneReps;
    }

    public abstract void initReplication(int var1);

    public abstract void addReplicationObs(int var1);

    public int getRequiredNewReplications() {
        return 0;
    }

    public void init() {
        if (this.simulating) {
            throw new IllegalStateException("Already simulating");
        }
        this.doneReps = 0;
        if (this.targetReps < this.minReps) {
            this.targetReps = this.minReps;
        }
        this.initReplicationProbes();
    }

    public void adjustTargetReplications(int numNewReplications) {
        if (numNewReplications < 0) {
            throw new IllegalArgumentException("numReplications < 0");
        }
        if (numNewReplications == 0) {
            return;
        }
        this.targetReps = this.doneReps + numNewReplications;
        if (this.targetReps > this.maxReps) {
            this.targetReps = this.maxReps;
        }
    }

    @Override
    public void simulate() {
        this.init();
        this.simulating = true;
        try {
            while (this.doneReps < this.targetReps) {
                for (int i = 0; i < this.targetReps; ++i) {
                    this.performReplication(i);
                }
                this.adjustTargetReplications(this.getRequiredNewReplications());
            }
        }
        finally {
            this.simulating = false;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append('[');
        sb.append("minimal number of replications: ").append(this.minReps);
        if (this.maxReps < Integer.MAX_VALUE) {
            sb.append(", maximal number of replications: ").append(this.maxReps);
        }
        sb.append(", target number of replications: ").append(this.targetReps);
        if (this.simulating) {
            sb.append(", simulation in progress");
        } else {
            sb.append(", simulation stopped");
        }
        sb.append(", number of completed replications: ").append(this.doneReps);
        sb.append(']');
        return sb.toString();
    }
}

