/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.latnetbuilder.weights;

import java.util.ArrayList;
import umontreal.ssj.latnetbuilder.weights.OrderDependentWeights;
import umontreal.ssj.latnetbuilder.weights.SingletonWeightComparable;

public class GeometricWeights
extends OrderDependentWeights {
    protected double baseWeight = 1.0;
    protected int truncationLevel;
    protected double c;

    public GeometricWeights(double base, int truncation, double c) {
        this.baseWeight = base;
        this.truncationLevel = truncation;
        this.c = c;
        this.setWeights();
    }

    public GeometricWeights(double base, int truncation) {
        this(base, truncation, 1.0);
    }

    public GeometricWeights() {
        this.truncationLevel = 0;
    }

    public double getC() {
        return this.c;
    }

    public void setC(double c) {
        this.c = c;
    }

    public double getBaseWeight() {
        return this.baseWeight;
    }

    public void setBaseWeight(double base) {
        this.baseWeight = base;
    }

    public int getTruncationLevel() {
        return this.truncationLevel;
    }

    public void setTruncationLevel(int trLevel) {
        this.truncationLevel = trLevel;
    }

    public void setWeights() {
        double w = 1.0;
        this.weights = new ArrayList(this.truncationLevel);
        for (int order = 1; order <= this.truncationLevel; ++order) {
            this.weights.add(order - 1, new SingletonWeightComparable<Integer>(order, this.c * w));
            w *= this.baseWeight;
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("");
        sb.append("Geometric order dependent weights [default = " + this.getDefaultWeight() + ", base = " + this.baseWeight + "]:\n");
        if (this.weights.size() > 0) {
            sb.append("[");
        }
        sb.append(this.printBody());
        return sb.toString() + (this.weights.size() > 0 ? "]" : "");
    }
}

