/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.charts;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.swing.JFrame;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYLineAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.ui.TextAnchor;
import umontreal.ssj.charts.Axis;
import umontreal.ssj.charts.HistogramChart;
import umontreal.ssj.charts.SSJXYSeriesCollection;

public abstract class XYChart {
    protected Axis XAxis;
    protected Axis YAxis;
    protected SSJXYSeriesCollection dataset;
    protected JFreeChart chart;
    protected boolean latexDocFlag = true;
    protected boolean autoRange;
    protected double[] manualRange;
    protected boolean grid = false;
    protected double xstepGrid;
    protected double ystepGrid;
    protected boolean probFlag = false;
    protected double chartMargin = 0.02;

    public JFreeChart getJFreeChart() {
        return this.chart;
    }

    public Axis getXAxis() {
        return this.XAxis;
    }

    public Axis getYAxis() {
        return this.YAxis;
    }

    public abstract JFrame view(int var1, int var2);

    public String getTitle() {
        return this.chart.getTitle().getText();
    }

    public void setTitle(String title) {
        this.chart.setTitle(title);
    }

    public void setprobFlag(boolean flag) {
        this.probFlag = flag;
    }

    public void setAutoRange() {
        this.setAutoRange(false, false, true, true);
    }

    public void setAutoRange(boolean right, boolean top) {
        this.setAutoRange(false, false, right, top);
    }

    private double[] adjustRangeBounds(double bmin, double bmax) {
        double upper;
        double del = (bmax - bmin) / 20.0;
        int a = (int)Math.floor(0.5 + Math.log10(del));
        double d = Math.pow(10.0, a);
        double lower = d * Math.ceil((bmin - del) / d);
        if (lower > bmin) {
            lower -= d;
        }
        if (0.0 == Math.abs(bmin)) {
            lower = 0.0;
        }
        if ((upper = d * Math.floor((bmax + del) / d)) < bmax) {
            upper += d;
        }
        double[] range = new double[]{lower, upper};
        return range;
    }

    protected void setAutoRange(boolean xZero, boolean yZero, boolean right, boolean top) {
        this.autoRange = true;
        double BorneMin = this.dataset.getDomainBounds()[0];
        double BorneMax = this.dataset.getDomainBounds()[1];
        double del = BorneMax - BorneMin < 1.0 ? (BorneMax - BorneMin) * this.chartMargin : this.chartMargin;
        BorneMin = BorneMin < 0.0 ? (BorneMin *= 1.0 + del) : (BorneMin *= 1.0 - del);
        BorneMax = BorneMax < 0.0 ? (BorneMax *= 1.0 - del) : (BorneMax *= 1.0 + del);
        double[] newRange = new double[2];
        newRange = this.adjustRangeBounds(BorneMin, BorneMax);
        if (this.probFlag && BorneMin == 0.0) {
            newRange[0] = 0.0;
        }
        this.XAxis.getAxis().setLowerBound(newRange[0]);
        this.XAxis.getAxis().setUpperBound(newRange[1]);
        BorneMin = this.dataset.getRangeBounds()[0];
        BorneMax = this.dataset.getRangeBounds()[1];
        del = BorneMax - BorneMin < 1.0 ? (BorneMax - BorneMin) * this.chartMargin : this.chartMargin;
        BorneMin = BorneMin < 0.0 ? (BorneMin *= 1.0 + del) : (BorneMin *= 1.0 - del);
        BorneMax = BorneMax < 0.0 ? (BorneMax *= 1.0 - del) : (BorneMax *= 1.0 + del);
        newRange = this.adjustRangeBounds(BorneMin, BorneMax);
        if (this.probFlag && newRange[0] <= 0.0) {
            newRange[0] = 0.0;
        }
        this.YAxis.getAxis().setLowerBound(newRange[0]);
        this.YAxis.getAxis().setUpperBound(newRange[1]);
        if (xZero) {
            this.XAxis.setTwinAxisPosition(0.0);
        } else if (right) {
            this.XAxis.setTwinAxisPosition(this.XAxis.getAxis().getLowerBound());
        } else {
            this.XAxis.setTwinAxisPosition(this.XAxis.getAxis().getUpperBound());
        }
        if (yZero) {
            this.YAxis.setTwinAxisPosition(0.0);
        } else if (top) {
            this.YAxis.setTwinAxisPosition(this.YAxis.getAxis().getLowerBound());
        } else {
            this.YAxis.setTwinAxisPosition(this.YAxis.getAxis().getUpperBound());
        }
    }

    public void setAutoRange00(boolean xZero, boolean yZero) {
        this.setAutoRange(xZero, yZero, true, true);
    }

    public void setManualRange(double[] range) {
        this.setManualRange(range, false, false, true, true);
    }

    public void setManualRange(double[] range, boolean right, boolean top) {
        this.setManualRange(range, false, false, right, top);
    }

    private void setManualRange(double[] range, boolean xZero, boolean yZero, boolean right, boolean top) {
        if (range.length != 4) {
            throw new IllegalArgumentException("range must have the format: [xmin, xmax, ymin, ymax]");
        }
        this.autoRange = false;
        this.XAxis.getAxis().setLowerBound(Math.min(range[0], range[1]));
        this.XAxis.getAxis().setUpperBound(Math.max(range[0], range[1]));
        this.YAxis.getAxis().setLowerBound(Math.min(range[2], range[3]));
        this.YAxis.getAxis().setUpperBound(Math.max(range[2], range[3]));
        if (xZero) {
            this.XAxis.setTwinAxisPosition(0.0);
        } else if (right) {
            this.XAxis.setTwinAxisPosition(this.XAxis.getAxis().getLowerBound());
        } else {
            this.XAxis.setTwinAxisPosition(this.XAxis.getAxis().getUpperBound());
        }
        if (yZero) {
            this.YAxis.setTwinAxisPosition(0.0);
        } else if (top) {
            this.YAxis.setTwinAxisPosition(this.YAxis.getAxis().getLowerBound());
        } else {
            this.YAxis.setTwinAxisPosition(this.YAxis.getAxis().getUpperBound());
        }
    }

    public void setManualRange00(double[] range, boolean xZero, boolean yZero) {
        this.setManualRange(range, xZero, yZero, true, true);
    }

    public double getChartMargin() {
        return this.chartMargin;
    }

    public void setChartMargin(double margin) {
        if (margin < 0.0) {
            throw new IllegalArgumentException("margin < 0");
        }
        this.chartMargin = margin;
    }

    public abstract void setTicksSynchro(int var1);

    public void drawVerticalLine(double x, String name, double yfrac, boolean right) {
        double ybottom = this.YAxis.getAxis().getLowerBound();
        XYChart o = this;
        if (this instanceof HistogramChart) {
            ybottom = 0.0;
        }
        double ytop = this.YAxis.getAxis().getUpperBound();
        XYLineAnnotation line = new XYLineAnnotation(x, ybottom, x, ytop);
        XYTextAnnotation text = new XYTextAnnotation(name, x, ytop * yfrac);
        if (!right) {
            text.setTextAnchor(TextAnchor.HALF_ASCENT_RIGHT);
        } else {
            text.setTextAnchor(TextAnchor.HALF_ASCENT_LEFT);
        }
        XYPlot plot = this.getJFreeChart().getXYPlot();
        plot.addAnnotation((XYAnnotation)line);
        plot.addAnnotation((XYAnnotation)text);
    }

    public void enableGrid(double xstep, double ystep) {
        this.grid = true;
        this.xstepGrid = xstep;
        this.ystepGrid = ystep;
    }

    public void disableGrid() {
        this.grid = false;
    }

    public abstract String toLatex(double var1, double var3);

    public void toLatexFile(String fileName, double width, double height) {
        String output = this.toLatex(width, height);
        FileWriter file = null;
        try {
            file = new FileWriter(fileName);
            file.write(output);
            ((Writer)file).close();
        }
        catch (IOException e) {
            System.err.println("   toLatexFile:  cannot write to  " + fileName);
            e.printStackTrace();
            try {
                if (file != null) {
                    ((Writer)file).close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setLatexDocFlag(boolean flag) {
        this.latexDocFlag = flag;
    }

    protected void setTick0Flags() {
        double minAxis = Math.min(this.XAxis.getAxis().getRange().getLowerBound(), this.XAxis.getTwinAxisPosition());
        double maxAxis = Math.max(this.XAxis.getAxis().getRange().getUpperBound(), this.XAxis.getTwinAxisPosition());
        if (this.XAxis.getTwinAxisPosition() == minAxis || this.XAxis.getTwinAxisPosition() == maxAxis) {
            this.YAxis.setTick0Flag(false);
        } else {
            this.YAxis.setTick0Flag(true);
        }
        minAxis = Math.min(this.YAxis.getAxis().getRange().getLowerBound(), this.YAxis.getTwinAxisPosition());
        maxAxis = Math.max(this.YAxis.getAxis().getRange().getUpperBound(), this.YAxis.getTwinAxisPosition());
        if (this.YAxis.getTwinAxisPosition() == minAxis || this.YAxis.getTwinAxisPosition() == maxAxis) {
            this.XAxis.setTick0Flag(false);
        } else {
            this.XAxis.setTick0Flag(true);
        }
    }

    protected double computeXScale(double position) {
        double[] bounds = new double[]{this.XAxis.getAxis().getLowerBound(), this.XAxis.getAxis().getUpperBound()};
        if (position < bounds[0]) {
            bounds[0] = position;
        }
        if (position > bounds[1]) {
            bounds[1] = position;
        }
        bounds[0] = bounds[0] - position;
        bounds[1] = bounds[1] - position;
        return this.computeScale(bounds);
    }

    protected double computeYScale(double position) {
        double[] bounds = new double[]{this.YAxis.getAxis().getLowerBound(), this.YAxis.getAxis().getUpperBound()};
        if (position < bounds[0]) {
            bounds[0] = position;
        }
        if (position > bounds[1]) {
            bounds[1] = position;
        }
        bounds[0] = bounds[0] - position;
        bounds[1] = bounds[1] - position;
        return this.computeScale(bounds);
    }

    protected double computeScale(double[] bounds) {
        int tenPowerRatio = 0;
        while (bounds[1] > 1000.0 || bounds[0] < -1000.0) {
            bounds[1] = bounds[1] / 10.0;
            bounds[0] = bounds[0] / 10.0;
            ++tenPowerRatio;
        }
        while (bounds[1] < 100.0 && bounds[0] > -100.0) {
            bounds[1] = bounds[1] * 10.0;
            bounds[0] = bounds[0] * 10.0;
            --tenPowerRatio;
        }
        return 1.0 / Math.pow(10.0, tenPowerRatio);
    }
}

