/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.stat.matrix;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import umontreal.ssj.stat.Tally;
import umontreal.ssj.stat.TallyStore;
import umontreal.ssj.stat.matrix.MatrixOfStatProbes;

public class MatrixOfTallies<E extends Tally>
extends MatrixOfStatProbes<E> {
    public MatrixOfTallies(int numRows, int numColumns) {
        super(numRows, numColumns);
    }

    public MatrixOfTallies(String name, int numRows, int numColumns) {
        super(name, numRows, numColumns);
    }

    public static MatrixOfTallies<Tally> createWithTally(int numRows, int numColumns) {
        MatrixOfTallies<Tally> matrix = new MatrixOfTallies<Tally>(numRows, numColumns);
        for (int r = 0; r < numRows; ++r) {
            for (int c = 0; c < numColumns; ++c) {
                matrix.set(r, c, new Tally());
            }
        }
        return matrix;
    }

    public static MatrixOfTallies<TallyStore> createWithTallyStore(int numRows, int numColumns) {
        MatrixOfTallies<TallyStore> matrix = new MatrixOfTallies<TallyStore>(numRows, numColumns);
        for (int r = 0; r < numRows; ++r) {
            for (int c = 0; c < numColumns; ++c) {
                matrix.set(r, c, new TallyStore());
            }
        }
        return matrix;
    }

    public void add(DoubleMatrix2D x) {
        int rows = this.rows();
        int columns = this.columns();
        if (x.rows() != rows || x.columns() != columns) {
            throw new IllegalArgumentException("Incompatible matrix dimensions: given " + x.rows() + "x" + x.columns() + ", required " + this.rows() + "x" + this.columns());
        }
        if (this.collect) {
            for (int r = 0; r < rows; ++r) {
                for (int c = 0; c < columns; ++c) {
                    double v = x.getQuick(r, c);
                    Tally ta = (Tally)this.get(r, c);
                    if (Double.isNaN(v) || ta == null) continue;
                    ta.add(v);
                }
            }
        }
        this.notifyListeners(x);
    }

    public void add(double[][] x) {
        int rows = this.rows();
        int columns = this.columns();
        if (x.length != rows) {
            throw new IllegalArgumentException("Incompatible number of rows: given " + x.length + ", required " + rows);
        }
        if (this.collect) {
            for (int r = 0; r < rows; ++r) {
                if (x[r].length != columns) {
                    throw new IllegalArgumentException("Incompatible number of columns in row " + r + ": given " + x[r].length + ", but required " + columns);
                }
                for (int c = 0; c < columns; ++c) {
                    double v = x[r][c];
                    Tally ta = (Tally)this.get(r, c);
                    if (Double.isNaN(v) || ta == null) continue;
                    ta.add(v);
                }
            }
        }
        this.notifyListeners((DoubleMatrix2D)new DenseDoubleMatrix2D(x));
    }

    public int numberObs() {
        if (this.rows() == 0 || this.columns() == 0) {
            return 0;
        }
        Tally t0 = (Tally)this.get(0, 0);
        return t0 == null ? 0 : t0.numberObs();
    }

    public boolean areAllNumberObsEqual() {
        int nr = this.rows();
        int nc = this.columns();
        int n = this.numberObs();
        for (int r = 0; r < nr; ++r) {
            for (int c = 0; c < nc; ++c) {
                Tally t = (Tally)this.get(r, c);
                if (t.numberObs() == n) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void average(DoubleMatrix2D m) {
        for (int i = 0; i < m.rows(); ++i) {
            for (int j = 0; j < m.columns(); ++j) {
                Tally ta = (Tally)this.get(i, j);
                double v = ta == null || ta.numberObs() == 0 ? Double.NaN : ta.average();
                m.setQuick(i, j, v);
            }
        }
    }

    public void variance(DoubleMatrix2D m) {
        if (m.rows() != this.rows()) {
            throw new IllegalArgumentException("Invalid number of rows in the given matrix: required " + this.rows() + " but found " + m.rows());
        }
        if (m.columns() != this.columns()) {
            throw new IllegalArgumentException("Invalid number of columns in the given matrix: required " + this.columns() + " but found " + m.columns());
        }
        for (int r = 0; r < this.rows(); ++r) {
            for (int c = 0; c < this.columns(); ++c) {
                Tally tally = (Tally)this.get(r, c);
                m.setQuick(r, c, tally != null && tally.numberObs() >= 2 ? tally.variance() : Double.NaN);
            }
        }
    }

    public void standardDeviation(DoubleMatrix2D m) {
        if (m.rows() != this.rows()) {
            throw new IllegalArgumentException("Invalid number of rows in the given matrix: required " + this.rows() + " but found " + m.rows());
        }
        if (m.columns() != this.columns()) {
            throw new IllegalArgumentException("Invalid number of columns in the given matrix: required " + this.columns() + " but found " + m.columns());
        }
        for (int r = 0; r < this.rows(); ++r) {
            for (int c = 0; c < this.columns(); ++c) {
                Tally tally = (Tally)this.get(r, c);
                m.setQuick(r, c, tally != null && tally.numberObs() >= 2 ? tally.standardDeviation() : Double.NaN);
            }
        }
    }

    @Override
    public MatrixOfTallies<E> clone() {
        return (MatrixOfTallies)super.clone();
    }
}

